/*
 * c1.r.c
 * Copyright (C) 2010-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <c1-types.h>
#include <e4.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const char *const x1f4_c1_empty_string;

int
_x1f4_c1_post_text(void *program, void *context, void *post)
{
    int status;
    X1f4_E4_C_TEXT text_1;
    struct context_type *context_data;

    text_1 = I_TEXT(post);

    context_data = context;

    if (text_1 == x1f4_c1_empty_string) {
	status = 0;
    } else {
	unsigned length;

	length = strlen(text_1);

	if (length) {
	    void *string;

	    length++;

	    status = ((struct c1_program_type *) program)->v.c.link
		(((struct c1_program_type *) program)->u.data, &string,
		 length);
	    if (status) {
	    } else {
		l_TEXT(string, post);

		memcpy(string, text_1, length);
	    }
	} else {
	    l_TEXT((char *) x1f4_c1_empty_string, post);
	    if (1) {
		status = 0;
	    }
	}
    }

    return status;
}
