/*
 * c1.q.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-config.h>

#if __SAVE_STACK_SIZE__
# include <string.h>
#endif				/* __SAVE_STACK_SIZE__ */

#include <c1-types.h>

int
x1f4_fast_program(struct c1_program_type *program_data, void *data)
{
    struct c1_miss_type *miss_data;

    miss_data = program_data->miss;
    if (miss_data) {
	struct c1_lead_type *lead_data;

	lead_data = data;

	do {
	    *(struct c1_lead_type *) miss_data->link = *lead_data++;
	    miss_data = miss_data->last_miss;
	} while (miss_data);

#if __SAVE_STACK_SIZE__
	data = lead_data;
#endif				/* __SAVE_STACK_SIZE__ */
    }

#if __SAVE_STACK_SIZE__
    memcpy(program_data->v1st, data, program_data->s1st);
    memcpy(program_data->v2nd, (char *) data + program_data->s1st,
	   program_data->s2nd);
#endif				/* __SAVE_STACK_SIZE__ */

    return 0;
}
