/*
 * c1.p.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-config.h>

#if __SAVE_STACK_SIZE__
# include <string.h>
#endif				/* __SAVE_STACK_SIZE__ */

#include <c1-types.h>

extern const char *const x1f4_c1_empty_string;

int
x1f4_push_program(struct c1_program_type *program_data, void *data)
{
    int status = 0;
    struct c1_miss_type *miss_data;

    miss_data = program_data->miss;
    if (miss_data) {
	struct c1_lead_type *lead_data;

	lead_data = data;

	do {
	    const struct c1_type_type *type_data;

	    *lead_data++ = *(struct c1_lead_type *) miss_data->link;

	    type_data = miss_data->type;
	    if (type_data) {
		int (*link) (void *, void **);

		link = type_data->link;
		if (link) {
		    status = link(type_data->context, miss_data->link);
		    if (status) {
			break;
		    }
		}
	    } else {
		if (((struct x1f4_variable_type *) miss_data->data)->type
		    == X1f4_E4_TEXT) {
		    X1f4_E4_C_TEXT *link;

		    link = miss_data->link;
		    *link = (char *) x1f4_c1_empty_string;
		}
	    }

	    miss_data = miss_data->last_miss;
	} while (miss_data);

#if __SAVE_STACK_SIZE__
	data = lead_data;
#endif				/* __SAVE_STACK_SIZE__ */
    }

#if __SAVE_STACK_SIZE__
    if (status) {
    } else {
	memcpy(data, program_data->v1st, program_data->s1st);
	memcpy((char *) data + program_data->s1st, program_data->v2nd,
	       program_data->s2nd);
    }
#endif				/* __SAVE_STACK_SIZE__ */

    return status;
}
