/*
 * c1.h
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_c1_H__
#define __LIBx1f4_c1_H__

#include <e4.h>
#include <e4jack.h>

/*
 * completion definitions
 */
#define X1f4_C1_BACK_COMPLETION		0
#define X1f4_C1_BYTE_COMPLETION		1
#define X1f4_C1_TURN_COMPLETION		2

/*
 * error definitions
 */
#define X1f4_C1_ALLOC_ERROR		1
#define X1f4_C1_PARSE_ERROR		2

/*
 * generation flag definitions
 */
#define X1f4_C1_BCOLLECT		(1L << 0x00)
#define X1f4_C1_COMPOSER		(1L << 0x01)
#define X1f4_C1_DDACCESS		(1L << 0x02)
#define X1f4_C1_IMPLICIT		(1L << 0x04)
#define X1f4_C1_LEADPOST		(1L << 0x05)
#define X1f4_C1_OPTIMIZE		(1L << 0x06)
#define X1f4_C1_RESOURCE		(1L << 0x07)
#define X1f4_C1_SCOMMENT		(1L << 0x08)
#define X1f4_C1_SIDELIST		(1L << 0x09)
#define X1f4_C1_SLIPTEST		(1L << 0x0a)
#define X1f4_C1_TRANSFER		(1L << 0x0b)
#define X1f4_C1_TURNCAST		(1L << 0x0c)
#define X1f4_C1_TYPELIST		(1L << 0x0d)

/*
 * record definitions
 */
#define X1f4_C1_HINT_MASK		(1L << 0x00)

typedef struct x1f4_c1record_type {
    const char *line;
    struct {
	int (*rule) (void *, unsigned, unsigned);
	void *data;
    } hint;
    union {
	struct {
	    x1f4_eerecord_type eerecord;
	} e_syntax;
	struct {
	    x1f4_ejrecord_type ejrecord;
	} higherof;
	struct {
	    int slip, type;
	} m_return;
	struct {
	    unsigned size;
	} reserved;
	struct {
	    unsigned size;
	} variable;
	struct {
	    int type;
	} w_scalar;
    } data;
    unsigned code, pick;
} x1f4_c1record_type;

typedef struct x1f4_datatext_type {
    struct x1f4_datatext_type *datatext_data;
    void *data, *link;
    const void *type;
} x1f4_datatext_type;

#if !defined __x1f4_datatype_type_defined__
typedef struct x1f4_datatype_type {
    const char *name;
    int (*flat) (void *, void *, void **), (*lead) (void *, void *, void **),
	(*line) (void *, void *, void **), (*link) (void *, void *, void **),
	(*shut) (void *, void *, void **), (*slip) (void *, void *, void **),
	type;
    unsigned size;
    void *context;
} x1f4_datatype_type;
#endif				/* !__x1f4_datatype_type_defined__ */

#if !defined __x1f4_datatype_type_defined__
# define __x1f4_datatype_type_defined__
#endif				/* !__x1f4_datatype_type_defined__ */

#if !defined __x1f4_function_type_defined__
typedef struct x1f4_function_type {
    const char *name;
    int (*function) (void *, void *, void **), type;
    const int *args;
    unsigned count, flags, length;
} x1f4_function_type;
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_function_type_defined__
# define __x1f4_function_type_defined__
#endif				/* !__x1f4_function_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
typedef struct x1f4_linetext_type {
    struct x1f4_function_type function;
    const void *context;
} x1f4_linetext_type;
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_linetext_type_defined__
# define __x1f4_linetext_type_defined__
#endif				/* !__x1f4_linetext_type_defined__ */

#if !defined __x1f4_operator_type_defined__
typedef struct x1f4_operator_type {
    const char *name;
    int (*operator) (void *, void *, void **), priority, type;
    const int *args;
    unsigned flags, length;
    const void *extension1, *extension2;
} x1f4_operator_type;
#endif				/* !__x1f4_operator_type_defined__ */

#if !defined __x1f4_operator_type_defined__
# define __x1f4_operator_type_defined__
#endif				/* !__x1f4_operator_type_defined__ */

typedef struct x1f4_c1_type {
    int completion, detail;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } function_set;
    struct {
	const void *context;
    } variable_set;
    struct {
	int type;
	void *text;
    } castlink_set;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_operator_type **);
	const void *context;
    } implicit_set;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_linetext_type **);
	const void *context;
    } composer_set;
    struct {
	struct x1f4_c1record_type *c1record_data;
    } bcollect_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *context;
    } resource_set;
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *context;
    } autolead_set;
    struct {
	const void *miss;
    } datatype_set;
    struct {
	const void *miss;
    } sidetype_set;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
} x1f4_c1_type;

extern const char *const x1f4_c1_empty_string;

extern int x1f4_aime_program
    (void *, void *);
extern int x1f4_ever_program
    (void *, void *);
extern int x1f4_fast_program
    (void *, void *);
extern int x1f4_fini_program
    (void **);
extern int x1f4_flat_program
    (void *);
extern int x1f4_head_program
    (void *);
extern int x1f4_inIt_program
    (void **, const char **, unsigned, const struct x1f4_c1_type *);
extern int x1f4_init_program
    (void **, const char *, unsigned, const struct x1f4_c1_type *);
extern int x1f4_lame_program
    (void *, int (*) (void *, const char *, unsigned), const char *, unsigned,
     struct x1f4_c1record_type *, struct x1f4_eelookup_type *);
extern int x1f4_link_program
    (void *);
extern int x1f4_lock_program
    (void *, void *, unsigned *);
extern int x1f4_long_program
    (void *, int *, void *, int (*) (void *), void *);
extern int x1f4_look_program
    (void *, unsigned *);
extern int x1f4_note_program
    (void *, int *, void *, int (*) (void *));
extern int x1f4_pick_program
    (void *, void **);
extern int x1f4_push_program
    (void *, void *);
extern int x1f4_size_program
    (void *, unsigned *);
extern int x1f4_slip_program
    (void *);
extern int x1f4_stat_program
    (void *, int (*) (void *, const char *, unsigned), const char *,
     struct x1f4_c1record_type *, struct x1f4_eelookup_type *);
extern int x1f4_sweep_program
    (void *);
extern int x1f4_tail_program
    (void *);
extern int x1f4_text_program
    (void *, int (*) (void *, void *), void *);

extern void x1f4_air_state
    (void *);

#endif				/* __LIBx1f4_c1_H__ */
