/*
 * c1.g.c
 * Copyright (C) 2008-2009, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-config.h>

#include <c1-types.h>

int
x1f4_size_program(struct c1_program_type *program_data, unsigned *class)
{
#if __ENABLE_STATE_COPY__
    struct c1_miss_type *miss_data;
    unsigned size;
#endif				/* __ENABLE_STATE_COPY__ */

#if __SAVE_STACK_SIZE__
    size = program_data->s1st + program_data->s2nd;
#elif __ENABLE_STATE_COPY__
    size = 0;
#endif				/* __SAVE_STACK_SIZE__ */

#if __ENABLE_STATE_COPY__
    miss_data = program_data->miss;
    if (miss_data) {
	unsigned fast = 1;

	miss_data = miss_data->last_miss;
	while (miss_data) {
	    miss_data = miss_data->last_miss;
	    fast++;
	}

	size += fast * sizeof(struct c1_lead_type);
    }
#endif				/* __ENABLE_STATE_COPY__ */

#if __ENABLE_STATE_COPY__
    *class = size;
#endif				/* __ENABLE_STATE_COPY__ */

    return 0;
}
