/*
 * c1.e.c
 * Copyright (C) 2007-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-defs.h>
#include <c1-errors.h>
#include <c1-types.h>
#include <e4.h>

int
_x1f4_c1_080707_error_0(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = E_SYNTAX;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_1(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = USEDVOID;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_2(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = B_SYNTAX;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_3(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = MISSTEST;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_4(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = BLOCKOUT;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_5(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = T_SYNTAX;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_6(struct c1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = VARIABLE;
	back_data->line = line;
	if (1) {
	    back_data->data.variable.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_7(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = LOOSE_DB;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_8(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = MISSLOOP;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_9(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = LOOPEXIT;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_a(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = OUTBREAK;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_b(struct c1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = RESERVED;
	back_data->line = line;
	if (1) {
	    back_data->data.reserved.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_c(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = COMPLETE;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_d(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = S_SYNTAX;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_e(struct c1_back_type *back_data, const char *line,
			int slip, int type)
{
    if (back_data) {
	back_data->code = M_RETURN;
	back_data->line = line;
	if (1) {
	    back_data->data.m_return.slip = slip;
	    back_data->data.m_return.type = type;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_080707_error_f(struct c1_back_type *back_data)
{
    if (back_data) {
	back_data->code = L_SCOPES;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_090828_error_0(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = X_RETURN;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_090828_error_1(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = E_RETURN;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_091025_error_0(struct c1_back_type *back_data, const char *line,
			int type)
{
    if (back_data) {
	back_data->code = W_SCALAR;
	back_data->line = line;
	if (1) {
	    back_data->data.w_scalar.type = type;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_110725_error_0(struct c1_back_type *back_data, const char *line,
			int type)
{
    if (back_data) {
	back_data->code = SIDEDATA;
	back_data->line = line;
	if (1) {
	    back_data->data.sidedata.type = type;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_111221_error_0(struct c1_back_type *back_data, const char *line,
			int delete)
{
    if (back_data) {
	back_data->code = HIGHEROF;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_120115_error_0(struct c1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = NAMEMISS;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_c1_130608_error_0(struct c1_back_type *back_data, const char *line,
			int error)
{
    if (back_data) {
	do {
	    if (error == X1f4_E4_PARSE_ERROR) {
		struct x1f4_eerecord_type *eerecord_data;

		eerecord_data = &back_data->data.e_syntax.eerecord;
		if (eerecord_data->code == X1f4_E4_MISSTURN) {
		    _x1f4_c1_080707_error_e
			(back_data, line,
			 eerecord_data->data.missturn.f1st,
			 eerecord_data->data.missturn.f2nd);
		    break;
		}
	    }

	    _x1f4_c1_080707_error_0(back_data, line);
	} while (0);
    }

    return PARSE_ERROR;
}
