/*
 * c1.7.7.c
 * Copyright (C) 2007, 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <c1-inter.h>
#include <c1-types.h>
#include <e4.h>

extern const char *const x1f4_c1_empty_string;

static int ceil_lead(void *, void *, void **);

const struct x1f4_function_type _x1f4_c1_here_lead[] = {
/* *INDENT-OFF* */
    {	"____x1f4_c1_7_7_c_stupid_hack__",
    				ceil_lead,
	X1f4_E4_VOID,		NULL,		0,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	31		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
};

static int
ceil_lead(void *context, void *output, void **input)
{
    struct c1_program_type *program_data;
    void *post;

    program_data = context;

    x1f4_deck_expression
	(((struct c1_node_type *) program_data->line)->data.data, &post);

    return program_data->u.near(program_data, context, post);
}
