/*
 * c1.7.6.c
 * Copyright (C) 2007-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <c1-defs.h>
#include <c1-parse.h>
#include <c1-types.h>
#include <e4.h>

extern const char *const x1f4_c1_empty_string;

static int ceil_miss(void *, void *, void **);
static int ever_miss(void *, void *, void **);

const struct x1f4_function_type _x1f4_c1_here_case[] = {
/* *INDENT-OFF* */
    {	"____x1f4_c1_7_6_c_stupid_hack__",
    				ceil_miss,
	X1f4_E4_VOID,		NULL,		0,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	31		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
}, _x1f4_c1_here_deck[] = {
/* *INDENT-OFF* */
    {	"____x1f4_c1_7_6_c_stupid_hack__",
    				ever_miss,
	X1f4_E4_VOID,		NULL,		0,
	X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,	31		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
};

static int
ceil_miss(void *context, void *output, void **input)
{
    int status = 0;
    struct c1_half_type *half_data;
    struct c1_miss_type *miss_data;
    unsigned miss;

    half_data = context;

    miss_data = half_data->miss;

    miss = half_data->size;
    while (miss) {
	const struct c1_type_type *type_data;

	miss--;

	type_data = miss_data->type;
	if (type_data) {
	    int (*flat) (void *, void **);

	    flat = type_data->flat;
	    if (flat) {
		const X1f4_E4_C_USER *user;
		int excess;
		void *cell, *text;

		user = miss_data->link;
		cell = (void *) *user;

		text = type_data->context;

		excess = flat(text, &cell);
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}

		{
		    *user = cell;
		}
	    }
	}

	miss_data = miss_data->last_miss;
    }

    return status;
}


static int
ever_miss(void *context, void *output, void **input)
{
    int status = 0;
    struct c1_half_type *half_data;
    struct c1_miss_type *miss_data;
    struct c1_program_type *program_data;
    unsigned miss;

    half_data = context;

    miss_data = half_data->miss;

    program_data = half_data->post;

    miss = half_data->size;
    while (miss) {
	const struct c1_type_type *type_data;

	miss--;

	type_data = miss_data->type;
	if (((struct x1f4_variable_type *) miss_data->data)->type
	    == X1f4_E4_TEXT) {
	    X1f4_E4_C_TEXT text;
	    void *link;

	    link = miss_data->link;
	    text = *(X1f4_E4_C_TEXT *) link;
	    if (text != x1f4_c1_empty_string) {
		program_data->m.free(program_data->m.data, text);
		if (1) {
		    *(X1f4_E4_C_TEXT *) link = (char *) x1f4_c1_empty_string;
		}
	    }
	}

	miss_data = miss_data->last_miss;
    }

    return status;
}
