/*
 * c1.6.c
 * Copyright (C) 2006-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-types.h>
#include <e4.h>
#include <mxdeck.h>

int
_x1f4_c1_select_variable(const char *f, unsigned length, const void *context,
			 const struct x1f4_variable_type **variable,
			 void **state)
{
    int status = X1f4_E4_PARSE_ERROR;

    if (context) {
	const void *key;

	if (x1f4_find_mxpath((void *) context, f, length, &key)) {
	    status = 0;
	    *state = ((const struct c1_miss_type *) key)->link;
	    *variable = ((const struct c1_miss_type *) key)->data;
	}
    }

    return status;
}
