/*
 * c1.3.c
 * Copyright (C) 2006-2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1-inter.h>
#include <c1-types.h>
#include <e4.h>

int
x1f4_slip_program(struct c1_program_type *program_data)
{
    int status;
    struct c1_node_type *node_data;
    void *data;

    node_data = program_data->slip;
    data = node_data->data.data;
    if (data) {
	status = x1f4_lead_expression(data);
	if (status) {
	} else {
	    program_data->slip = node_data->node_data;
	}
    } else {
	data = (node_data + 1)->data.data;

	if (!data) {
	    node_data++;
	    program_data->slip = node_data->node_data;
	    status = 0;
	} else {
	    int deck;

	    status = x1f4_case_expression(data, &deck);
	    if (status) {
	    } else {
		if (deck) {
		    program_data->slip = node_data->node_data;
		} else {
		    node_data++;
		    program_data->slip = node_data->node_data->node_data;
		}
	    }
	}
    }

    return status;
}
