/*
 * c1-v.4.c
 * Copyright (C) 2006-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>

#include <c1-types.h>
#include <mxdeck.h>

static int air_node(void *, const void *);

static int
air_node(void *none, const void *miss)
{
    struct c1_miss_type *miss_data;

    miss_data = (void *) miss;

    free(miss_data->data);

    free(miss_data);

    return 0;
}


void
x1f4_air_state(void *context)
{
    x1f4_lime_mxdeck(context, NULL, air_node);
    x1f4_fini_mxdeck(&context);
}
