/*
 * c1-e.7.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

static const char tabs[] = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

int
_x1f4_c1_print_level(void *data, int (*this) (void *, const char *, unsigned),
		     unsigned level)
{
    int status;
    unsigned class;

    class = level >> 1;
    if (!class) {
	status = this(data, "    ", 4);
    } else {
	unsigned shift;

	shift = class >> 4;
	if (!shift) {
	    status = this(data, tabs, class & 15);
	    if (level & 1) {
		status = this(data, "    ", 4);
	    }
	} else {
	    while (shift) {
		status = this(data, tabs, 16);
		if (status) {
		    break;
		} else {
		    shift--;
		}
	    }
	    if (!status) {
		shift = class & 15;
		if (!shift) {
		    if (level & 1) {
			status = this(data, "    ", 4);
		    }
		} else {
		    status = this(data, tabs, shift);
		    if (!status) {
			if (level & 1) {
			    status = this(data, "    ", 4);
			}
		    }
		}
	    }
	}
    }

    return status;
}
