/*
 * c-types.h
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_c_TYPES_H__
#define __LIBx1f4_c_TYPES_H__

#include <config.h>

#include <limits.h>

/*
 * type definitions
 */
#define C_BILL				unsigned long
#define C_MODE				long
#define C_REAL				double
#define C_TEXT				char *
#define C_USER				void *

/*
 * type definitions (continued)
 */
#define C_DECK				unsigned long

/*
 * type range definitions
 */
#define C_MODE_MAX			LONG_MAX
#define C_MODE_MIN			LONG_MIN

/*
 * type size definitions
 */
#define C_BILL_SIZEOF			SIZEOF_UNSIGNED_LONG
#define C_MODE_SIZEOF			SIZEOF_LONG
#define C_REAL_SIZEOF			SIZEOF_DOUBLE
#define C_TEXT_SIZEOF			SIZEOF_CHAR_P
#define C_USER_SIZEOF			SIZEOF_VOID_P

#endif				/* __LIBx1f4_c_TYPES_H__ */
