/*
 * bqpx.m.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-types.h>

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_sand_bqpset(void *bqfset, unsigned mind, void *node,
		       integral_q **lead, integral_q **path, unsigned *pace,
		       integral_q *file, integral_q **turn, integral_q **lane,
		       unsigned rate, integral_q mode)
{
    int status;
    integral_q *club, *tier;
    unsigned hold = 0, pick;

    pick = *pace;

    club = *lead;

    tier = *lane;

    file = ND(node)[pick];

    if (0) {
    } else {
	integral_q lack, last, next;
	unsigned deck, ever;

	if (club) {
	    last = *club & ~Lx55555555;
	    if (last) {
		if (last & (last - 1)) {
		    deck = 4;
		    ever = 0;
		    next = ~Q(0);
		} else {
		    if (tier) {
			deck = 1;
			next = *tier & ~Lx55555555;
			if (next) {
			    if (next & (next - 1)) {
				ever = 4;
			    } else {
				ever = 1;
			    }
			} else {
			    ever = 0;
			}
		    } else {
			if (mind ^ 1) {
			    deck = 4;
			} else {
			    deck = 1;
			}

			ever = 0;
			next = ~Q(0);
		    }
		}

		lack = last;
	    } else {
		deck = 0;
		if (tier) {
		    next = *tier & ~Lx55555555;
		    if (next) {
			if (next & (next - 1)) {
			    ever = 4;
			} else {
			    ever = 1;
			}
		    } else {
			ever = 0;
		    }

		    lack = next;
		} else {
		    ever = 0;
		    next = ~Q(0);
		    if (mind ^ 1) {
			lack = *KD(ND(node)[pick - 2]) & ~Lx55555555;
			if (lack) {
			    if (pick - 2) {
				deck = 4;
			    } else {
				if (lack & (lack - 1)) {
				    deck = 4;
				}
			    }

			    hold = 2;
			    lack = Q(1) << integral_q_last;
			} else {
			    lack = last;
			}
		    } else {
			lack = last;
		    }
		}
	    }
	} else {
	    deck = 0;
	    next = *tier & ~Lx55555555;
	    if (next) {
		if (mind ^ 1) {
		    ever = 4;
		} else {
		    if (next & (next - 1)) {
			ever = 4;
		    } else {
			ever = 1;
		    }
		}

		lack = next;
		last = ~Q(0);
	    } else {
		ever = 0;
		last = ~Q(0);
		if (mind ^ 1) {
		    lack = *KD(ND(node)[2]) & ~Lx55555555;
		    if (lack) {
			if (mind ^ 2) {
			    ever = 4;
			} else {
			    if (lack & (lack - 1)) {
				ever = 4;
			    }
			}

			hold = 1;
			lack = Q(1) << integral_q_last;
		    } else {
			lack = next;
		    }
		} else {
		    lack = next;
		}
	    }
	}

	if (lack) {
	    if ((deck | ever) & 4) {
		status = 0;

		if (deck < ever) {
		    integral_q data, *fast, *side, text;

		    if (hold) {
			club = tier;

			tier = ND(node)[pick + 2];

			next = *tier & ~Lx55555555;
		    }

		    fast = tier;

		    text = next;
		    text &= (text - 1) << 1;

		    *KD(fast) = Lx55555555 | (next & ~text);

		    text >>= 2;
		    if (text) {
			fast += 2;

			side = fast + integral_q_bits - 1;

			last = *fast;

			data = *side;

			text >>= 2;

			for (; text; text >>= 2) {
			    *fast = *(fast + 2);
			    fast += 2;
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *fast = *(fast + 1);
			}
			{
			    *side = *(side + 1);
			}
		    } else {
			last = fast[1];

			data = fast[integral_q_bits];
		    }

		    if (hold) {
			fast = club + 2;

			side = fast + integral_q_bits - 1;

			text = KD(node)[pick + 2];

			KD(node)[pick + 2] = last;

			last = *fast;

			next = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *fast = *(fast + 2);
			    fast += 2;
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *fast = text;
			}
			{
			    *side = next;
			}
		    }

		    fast = file;

		    *KD(fast) = Lx55555555 | Q(1) << integral_q_last;

		    if (0) {
		    } else {
			fast += integral_q_last;

			*fast = **turn;

			fast += integral_q_bits;

			{
			    *(fast - 1) = *fast;
			}

			{
			    *fast = data;
			}
		    }

		    KD(node)[pick + 1] = last;
		} else {
		    integral_q data, *fast, *side, text;

		    if (hold) {
			tier = club;

			club = ND(node)[pick - 2];

			last = *club & ~Lx55555555;
		    }

		    fast = club;

		    text = last;

		    if (text & Q(1) << integral_q_last) {
			next = fast[integral_q_last];

		        fast += (integral_q_bits << 1) - 1;

			data = *fast;
			*fast = *(fast - 1);

			*KD(club) = Lx55555555
			    | (last ^ Q(1) << integral_q_last);
		    } else {
			fast += integral_q_bits - 2;

			side = fast + integral_q_bits + 1;

			next = *fast;

			data = *side;

			text <<= 2;

			for (; !(text & Q(1) << integral_q_last); text <<= 2) {
			    *fast = *(fast - 2);
			    fast -= 2;
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *fast = *(fast - 1);
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 1);
			}

			*KD(club) = Lx55555555
			    | (last ^ Q(1) << (fast - club - 1));
		    }

		    if (hold) {
			fast = tier + integral_q_bits - 2;

			side = fast + integral_q_bits + 1;

			text = KD(node)[pick - 1];

			KD(node)[pick - 1] = next;

			next = *fast;

			last = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *fast = *(fast - 2);
			    fast -= 2;
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *fast = text;
			}
			{
			    *side = last;
			}
		    }

		    fast = file;

		    *KD(fast) = Lx55555555 | 2;

		    if (0) {
		    } else {
			fast += 1;

			side = fast + integral_q_bits - 1;

			{
			    *fast = **path;
			}
			{
			    *side = data;
			}
		    }

		    KD(node)[pick] = next;
		}
	    } else {
		if (mind ^ 1) {
		    if (pick) {
			if (pick ^ mind) {
			} else {
			    pick--;

			    *pace = pick;

			    *lane = file;
			    file = club;
			    *lead = ND(node)[pick - 1];
			    *path = KD(node) + pick;
			    *turn = KD(node) + pick + 1;
			}
		    } else {
			pick++;

			*pace = pick;

			*lead = file;
			file = tier;
			*lane = ND(node)[pick + 1];
			*path = KD(node) + pick;
			*turn = KD(node) + pick + 1;
		    }

		    status = _libx1f4l2_lane_bqpset
			(bqfset, mind, node, lead, path, pace, file, turn,
			 lane, rate, mode);
		    if (status) {
		    } else {
			status = LAST_ERROR + integral_q_bits;
		    }
		} else {
#if 0
		    status = 0;
		    if (1) {
			*sign = hold;
		    }
#else
		    status = _libx1f4l2_root_bqpset(bqfset, node, rate);
#endif				/* 0 */
		}
	    }
	} else {
	    status = _libx1f4l2_join_bqpset
		(bqfset, mind, node, lead, path, pace, file, turn, lane, rate,
		 mode);
	    if (status) {
	    } else {
		status = LAST_ERROR + integral_q_bits;
	    }
	}
    }

    return status;
}
