/*
 * bqpx.3.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <bcount.h>
#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <bqpx-scope.h>
#include <bqpx-types.h>
#include <reverse.h>
#include <xfs.h>
#include <xls.h>

#define __HALF_TRANSFER__		1

#define __FINE_EXCESS__			1
#define __FINE_SECOND__			2
#define __FINE_SELECT__			3
#define __FINE_TARGET__			4

#define __FINE_METHOD__			__FINE_EXCESS__

#define ____FINE_METHOD__		__FINE_METHOD__

#define __LOSE_DOUBLE__			1

#define __LOSE_METHOD__			__LOSE_DOUBLE__

#define __UNROLL_TRANSFER__		0

#define __HEAD_LEFT__			1

#define FINE_ERROR			(LAST_ERROR + 8)

#define false(e)			0

#define here_two_test(___h) \
    ((___h) & 8192)

#undef here_two_test

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_l_count(___h, ___e, ___v) \
    ___n = (___e) & ~Lx55555555;					      \
    ___p = (___n | ___n >> (half_integral_q_bits + 1))			      \
	& ((Q(1) << half_integral_q_bits) - 1);				      \
    if ((___v)) {							      \
	___t = 1024;							      \
    } else {								      \
	___t = 1024 | 2048;						      \
    }
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_n_count(___h, ___e, ___v) \
    ___n = (___e) & ~Lx55555555;					      \
    ___p |= (___n | ___n << (half_integral_q_bits - 1))			      \
	& ~Q(0) << half_integral_q_bits;				      \
    if ((___v)) {							      \
	___t |= Q(1024) << half_integral_q_bits;			      \
    } else {								      \
	___t |= Q(1024 | 2048) << half_integral_q_bits;			      \
    }
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_l_reset(___h) \
    ___p = 0;								      \
    ___t = 0
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_n_reset(___h)
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_declarations \
    integral_q ___n, ___p, ___t
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#if __LOSE_METHOD__ == __LOSE_DOUBLE__
# define here_two_setup(___f, ___g) \
    l2_q_heap_1up(___p);						      \
									      \
    ___p &= Q(0xff) | Q(0xff) << half_integral_q_bits;			      \
									      \
    ___p |= ___t;							      \
    ___p |=								      \
	((___p								      \
	  - ((___t & (Q(1024) | Q(1024) << half_integral_q_bits)) >> 10))     \
	 & (Q(1024) | Q(1024) << half_integral_q_bits)) << 3;		      \
									      \
    (___f) = ___p & ((Q(1) << half_integral_q_bits) - 1);		      \
    (___g) = ___p >> half_integral_q_bits
#endif				/* __LOSE_METHOD__ == __LOSE_DOUBLE__ */

#define here_two_test(___h) \
    ((___h) & 8192)

#define text_rate(late, bqfset) \
    ((late) + 2 < bqfset((bqfset))->link_a.fpnews.link_v.rate)

#define trap(___n)			((___n) + half_integral_q_bits)

#define true(e)				1

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int clip(void *, integral_q);
static int east(void *, unsigned);
static int edge(void *, unsigned);
static int fine(void *, void *, integral_q);
static int lose(void *, void *, integral_q *, void *, unsigned, integral_q *,
		void *, unsigned, integral_q);
static int miss(void *, unsigned, void *, unsigned, unsigned, integral_q);
static int shut(void *, void *, unsigned, integral_q);

static int
clip(void *node, integral_q mode)
{
    int status;
    integral_q *call;
    unsigned mind, size;

    call = node;

    size = *call;
    if (size) {
	mind = size;

	call++;

	size--;
	while (size) {
	    unsigned half;

	    half = (size + 1) >> 1;
	    if (mode < call[half]) {
		size = half - 1;
	    } else {
		call += half;
		size -= half;
	    }
	}

	if (*call == mode) {
	    status = 0;

	    memmove(call, call + 1,
		    (mind - (call - (integral_q *) node))
		    * sizeof(integral_q));

	    *((integral_q *) node) = mind - 1;
	} else {
	    status = MISS_CLASS;
	}
    } else {
	status = MISS_CLASS;
    }

    return status;
}


static int
east(void *node, unsigned call)
{
    integral_q news, slip;

    news = *KD(node);

    slip = news & ~Lx55555555;

    {
	if (false(call ^ (integral_q_bits - 1))) {
	} else {
	    unsigned deck, ever;

	    l2_q_xls(deck, slip);
	    if (1) {
		deck ^= integral_q_last;
		if (deck ^ (integral_q_bits - 1)) {
		    integral_q *data, *text;

		    *KD(node) = news & ~(Q(1) << deck);

		    PD(node)[integral_q_bits - 1] =
			PD(node)[integral_q_bits - 3];

		    call--;
		    data = KD(node) + call;
		    call--;
		    text = (integral_q *) PD(node) + call;

		    ever = (integral_q_bits - 3 - deck) >> 1;
		    for (; ever; ever--) {
			*data = *(data - 2);
			data -= 2;
			*text = *(text - 2);
			text -= 2;
		    }
		    {
			*data = *(data - 1);
			*text = *(text - 1);
		    }
		} else {
		    *KD(node) = news & ~(Q(1) << deck);

		    PD(node)[integral_q_bits - 1] =
			PD(node)[integral_q_bits - 2];
		}
	    }
	}
    }

    return 0;
}


static int
edge(void *node, unsigned call)
{
    integral_q news, slip;

    news = *KD(node);

    slip  = news & ~Lx55555555;

    {
	if (1) {
	    call++;

	    if (call & 1) {
		*KD(node) = news & ~(Q(1) << call);
	    } else {
		if (news & (Q(1) << (call - 1))) {
		    *KD(node) = news & ~(Q(1) << (call - 1));
		    KD(node)[call] = KD(node)[call - 1];
		    call--;
		    PD(node)[call] = PD(node)[call - 1];
		} else {
		    if (news & (Q(1) << (call + 1))) {
			*KD(node) = news & ~(Q(1) << (call + 1));
			if (2) {
			    KD(node)[call] = KD(node)[call + 1];
			    PD(node)[call - 1] = PD(node)[call];
			}
		    } else {
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << call);
			if (back) {
			    l2_q_xfs(ever, back);
#if __HEAD_LEFT__
			    slip &= ((Q(1) << ever) - (Q(1) << call))
				>> (ever - call);
			    if (slip) {
				l2_q_xls(deck, slip);
				deck ^= integral_q_last;
				if (1) {
				    integral_q *data, *text;

				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    data = KD(node) + call;
				    call--;
				    text = (integral_q *) PD(node) + call;
				    for (; ever; ever--) {
					*data = *(data - 2);
					data -= 2;
					*text = *(text - 2);
					text -= 2;
				    }
				    {
					*data = *(data - 1);
					*text = *(text - 1);
				    }
				}
			    } else {
				if (2) {
				    integral_q *data, *text;

				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    text = (integral_q *) PD(node) + call;
				    call++;
				    data = KD(node) + call;
				    for (; deck; deck--) {
					*text = *(text + 2);
					text += 2;
					*data = *(data + 2);
					data += 2;
				    }
				    {
					*text = *(text + 1);
					*data = *(data + 1);
				    }
				}
			    }
#else
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (deck ^ integral_q_bits) {
				deck ^= integral_q_last;
				if (call - deck < ever - call) {
				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    for (; ever; ever--) {
					KD(node)[call] = KD(node)[call - 2];
					call--;
					PD(node)[call] = PD(node)[call - 2];
					call--;
				    }
				    {
					KD(node)[call] = KD(node)[call - 1];
					call--;
					PD(node)[call] = PD(node)[call - 1];
				    }
				} else {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    for (; deck; deck--) {
					PD(node)[call] = PD(node)[call + 2];
					call++;
					KD(node)[call] = KD(node)[call + 2];
					call++;
				    }
				    {
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    } else {
				if (2) {
				    *KD(node) = news & ~(Q(1) << ever);
				    deck = (ever - call) >> 1;
				    call--;
				    for (; deck; deck--) {
					PD(node)[call] = PD(node)[call + 2];
					call++;
					KD(node)[call] = KD(node)[call + 2];
					call++;
				    }
				    {
					PD(node)[call] = PD(node)[call + 1];
					call++;
					KD(node)[call] = KD(node)[call + 1];
				    }
				}
			    }
#endif				/* __HEAD_LEFT__ */
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << call) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    integral_q *data, *text;

				    *KD(node) = news & ~(Q(1) << deck);
				    ever = (call - deck) >> 1;
				    data = KD(node) + call;
				    call--;
				    text = (integral_q *) PD(node) + call;
				    for (; ever; ever--) {
					*data = *(data - 2);
					data -= 2;
					*text = *(text - 2);
					text -= 2;
				    }
				    {
					*data = *(data - 1);
					*text = *(text - 1);
				    }
				}
			    }
			}
		    }
		}
	    }
	}
    }

    return 0;
}


static int
fine(void *bqfset, void *node, integral_q mode)
{
    int status;

    do {
	integral_q *fast, news, slip;
	unsigned copy;

	news = *KD(node);

	if (1) {
#if SIZEOF_integral_q == 8
	    if (mode < KD(node)[040]) {
#endif				/* SIZEOF_integral_q == 8 */
		if (mode < KD(node)[020]) {
		    if (mode < KD(node)[010]) {
			if (mode < KD(node)[004]) {
			    if (mode < KD(node)[002]) {
				if (news & 2) {
				    if (mode < KD(node)[1]) {
					status = FINE_ERROR - 2;
				    } else {
					if (mode ^ KD(node)[1]) {
					    status = MISS_CLASS;
					} else {
					    status = 0;

					    *KD(node) = news & ~Q(2);
					}
				    }
				} else {
				    status = FINE_ERROR
					+ (integral_q_bits << 2);
				}

				break;
			    } else {
				copy = 002;
			    }
			} else {
			    if (mode < KD(node)[006]) {
				copy = 004;
			    } else {
				copy = 006;
			    }
			}
		    } else {
			if (mode < KD(node)[014]) {
			    if (mode < KD(node)[012]) {
				copy = 010;
			    } else {
				copy = 012;
			    }
			} else {
			    if (mode < KD(node)[016]) {
				copy = 014;
			    } else {
				copy = 016;
			    }
			}
		    }
		} else {
		    if (mode < KD(node)[030]) {
			if (mode < KD(node)[024]) {
			    if (mode < KD(node)[022]) {
				copy = 020;
			    } else {
				copy = 022;
			    }
			} else {
			    if (mode < KD(node)[026]) {
				copy = 024;
			    } else {
				copy = 026;
			    }
			}
		    } else {
			if (mode < KD(node)[034]) {
			    if (mode < KD(node)[032]) {
				copy = 030;
			    } else {
				copy = 032;
			    }
			} else {
			    if (mode < KD(node)[036]) {
				copy = 034;
			    } else {
				copy = 036;
			    }
			}
		    }
		}
#if SIZEOF_integral_q == 8
	    } else {
		if (mode < KD(node)[060]) {
		    if (mode < KD(node)[050]) {
			if (mode < KD(node)[044]) {
			    if (mode < KD(node)[042]) {
				copy = 040;
			    } else {
				copy = 042;
			    }
			} else {
			    if (mode < KD(node)[046]) {
				copy = 044;
			    } else {
				copy = 046;
			    }
			}
		    } else {
			if (mode < KD(node)[054]) {
			    if (mode < KD(node)[052]) {
				copy = 050;
			    } else {
				copy = 052;
			    }
			} else {
			    if (mode < KD(node)[056]) {
				copy = 054;
			    } else {
				copy = 056;
			    }
			}
		    }
		} else {
		    if (mode < KD(node)[070]) {
			if (mode < KD(node)[064]) {
			    if (mode < KD(node)[062]) {
				copy = 060;
			    } else {
				copy = 062;
			    }
			} else {
			    if (mode < KD(node)[066]) {
				copy = 064;
			    } else {
				copy = 066;
			    }
			}
		    } else {
			if (mode < KD(node)[074]) {
			    if (mode < KD(node)[072]) {
				copy = 070;
			    } else {
				copy = 072;
			    }
			} else {
			    if (mode < KD(node)[076]) {
				copy = 074;
			    } else {
				copy = 076;
			    }
			}
		    }
		}
	    }
#endif				/* SIZEOF_integral_q == 8 */
	}

	slip = news & ~Lx55555555;

	fast = KD(node) + copy;

	if (mode ^ *fast) {
	    copy++;
	    if (news & Q(1) << copy) {
		fast++;
		if (mode ^ *fast) {
		    status = MISS_CLASS;
		    if (1) {
			break;
		    }
		} else {
		    *KD(node) = news & ~(Q(1) << copy);

		    status = 0;

		    if (1) {
			break;
		    }
		}
	    } else {
		status = MISS_CLASS;
		if (1) {
		    break;
		}
	    }
	}

	if (slip) {
	    status = 0;

	    if (0) {
	    } else {
		mode = Q(1) << (copy - 1);
		if (news & mode) {
		    *KD(node) = news & ~mode;
		    *fast = *(fast - 1);
		} else {
		    mode <<= 2;
		    if (news & mode) {
			*KD(node) = news & ~mode;
			*fast = *(fast + 1);
		    } else {
#if ____FINE_METHOD__ == __FINE_SELECT__
			integral_q last, next;

			next = slip >> (copy + 1);
			last = slip << (integral_q_bits - copy);
			l2_q_reverse_1up(next);
			next <<= 1;
			if (last < next) {
			    for (; !(next & 15 << (integral_q_bits - 4));
				 next <<= 4) {
				integral_q *side;

				side = fast + 2;
				*fast = *side;
				fast = side + 2;
				*side = *fast;
			    }
			    if (!(next & 3 << (integral_q_bits - 2))) {
				integral_q *side;

				side = fast + 2;
				*fast = *side;
				fast = side;
			    }
			    {
				*fast = *(fast + 1);
			    }

			    *KD(node) =
				news & ~(Q(1) << (fast - KD(node) + 1));
			} else {
			    for (; !(last & 15 << (integral_q_bits - 4));
				 last <<= 4) {
				integral_q *side;

				side = fast - 2;
				*fast = *side;
				fast = side - 2;
				*side = *fast;
			    }
			    if (!(last & 3 << (integral_q_bits - 2))) {
				integral_q *side;

				side = fast - 2;
				*fast = *side;
				fast = side;
			    }
			    {
				*fast = *(fast - 1);
			    }

			    *KD(node) =
				news & ~(Q(1) << (fast - KD(node) - 1));
			}
#elif __FINE_METHOD__ == __FINE_EXCESS__
			integral_q last, next;

			next = slip >> (copy + 1);
			last = slip << (integral_q_bits - copy);
			l2_q_reverse_1up(last);
			last >>= 1;
			slip = last | next;
			slip &= (slip - 1) << 1;
			if (last & slip) {
			    last = slip >> 4;
			    for (; last; last >>= 4) {
				integral_q *side;

				side = fast - 2;
				*fast = *side;
				fast = side - 2;
				*side = *fast;
			    }
			    if (slip & Lx44444444) {
				integral_q *side;

				side = fast - 2;
				*fast = *side;
				fast = side;
			    }
			    {
				*fast = *(fast - 1);
			    }

			    *KD(node) =
				news & ~(Q(1) << (fast - KD(node) - 1));
			} else {
			    next = slip >> 4;
			    for (; next; next >>= 4) {
				integral_q *side;

				side = fast + 2;
				*fast = *side;
				fast = side + 2;
				*side = *fast;
			    }
			    if (slip & Lx44444444) {
				integral_q *side;

				side = fast + 2;
				*fast = *side;
				fast = side;
			    }
			    {
				*fast = *(fast + 1);
			    }

			    *KD(node) =
				news & ~(Q(1) << (fast - KD(node) + 1));
			}
#elif __FINE_METHOD__ == __FINE_SECOND__
			if (copy < half_integral_q_bits) {
			    if (slip & ((Q(1) << copy) - 1)) {
				if (1) {
				    integral_q *fast;

				    slip <<= integral_q_bits - copy;

				    fast = KD(node) + copy;

				    for (; !(slip
					     & 15 << (integral_q_bits - 4));
					 slip <<= 4) {
					integral_q *side;

					side = fast - 2;
					*fast = *side;
					fast = side - 2;
					*side = *fast;
				    }
				    if (!(slip & 3 << (integral_q_bits - 2))) {
					integral_q *side;

					side = fast - 2;
					*fast = *side;
					fast = side;
				    }
				    {
					*fast = *(fast - 1);
				    }

				    *KD(node) = news
					& ~(Q(1) << (fast - KD(node) - 1));
				}
			    } else {
				if (1) {
				    integral_q *fast;

				    slip >>= copy;

				    fast = KD(node) + copy;

				    for (; !(slip & 15); slip >>= 4) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side + 2;
					*side = *fast;
				    }
				    if (!(slip & 3)) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side;
				    }
				    {
					*fast = *(fast + 1);
				    }

				    *KD(node) = news
					& ~(Q(1) << (fast - KD(node) + 1));
				}
			    }
			} else {
			    if (slip & ~Q(0) << copy) {
				if (1) {
				    integral_q *fast;

				    slip >>= copy;

				    fast = KD(node) + copy;

				    for (; !(slip & 15); slip >>= 4) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side + 2;
					*side = *fast;
				    }
				    if (!(slip & 3)) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side;
				    }
				    {
					*fast = *(fast + 1);
				    }

				    *KD(node) = news
					& ~(Q(1) << (fast - KD(node) + 1));
				}
			    } else {
				if (1) {
				    integral_q *fast;

				    slip <<= integral_q_bits - copy;

				    fast = KD(node) + copy;

				    for (; !(slip
					     & 15 << (integral_q_bits - 4));
					 slip <<= 4) {
					integral_q *side;

					side = fast - 2;
					*fast = *side;
					fast = side - 2;
					*side = *fast;
				    }
				    if (!(slip & 3 << (integral_q_bits - 2))) {
					integral_q *side;

					side = fast - 2;
					*fast = *side;
					fast = side;
				    }
				    {
					*fast = *(fast - 1);
				    }

				    *KD(node) = news
					& ~(Q(1) << (fast - KD(node) - 1));
				}
			    }
			}
#elif __FINE_METHOD__ == __FINE_TARGET__
			integral_q back;
			unsigned deck, ever;

			back = slip & (~Q(0) << copy);
			if (back) {
			    l2_q_xfs(ever, back);
# if __HEAD_LEFT__
			    slip &= ((Q(1) << ever) - (Q(1) << copy))
				>> (ever - copy);
			    if (slip) {
				l2_q_xls(deck, slip);
				deck ^= integral_q_last;
				if (1) {
				    *KD(node) = news & ~(Q(1) << deck);

				    ever = (copy - deck) >> 1;
				    deck = ever >> 1;
				    for (; deck; deck--) {
					*fast = *(fast - 2);
					fast -= 2;
					*fast = *(fast - 2);
					fast -= 2;
				    }
				    if (ever & 1) {
					*fast = *(fast - 2);
					fast -= 2;
				    }
				    {
					*fast = *(fast - 1);
				    }
				}
			    } else {
				if (1) {
				    *KD(node) = news & ~(Q(1) << ever);

				    deck = (ever - copy) >> 1;
				    ever = deck >> 1;
				    for (; ever; ever--) {
					*fast = *(fast + 2);
					fast += 2;
					*fast = *(fast + 2);
					fast += 2;
				    }
				    if (deck & 1) {
					*fast = *(fast + 2);
					fast += 2;
				    }
				    {
					*fast = *(fast + 1);
				    }
				}
			    }
# else
			    back = slip & ((Q(1) << copy) - 1);
			    if (back) {
				l2_q_xls(deck, back);
				deck ^= integral_q_last;
				if (copy - deck < ever - copy) {
				    *KD(node) = news & ~(Q(1) << deck);

				    ever = (copy - deck) >> 1;
				    for (; ever; ever--) {
					*fast = *(fast - 2);
					fast -= 2;
				    }
				    {
					*fast = *(fast - 1);
				    }
				} else {
				    *KD(node) = news & ~(Q(1) << ever);

				    deck = (ever - copy) >> 1;
				    for (; deck; deck--) {
					*fast = *(fast + 2);
					fast += 2;
				    }
				    {
					*fast = *(fast + 1);
				    }
				}
			    } else {
				if (1) {
				    *KD(node) = news & ~(Q(1) << ever);

				    deck = (ever - copy) >> 1;
				    for (; deck; deck--) {
					*fast = *(fast + 2);
					fast += 2;
				    }
				    {
					*fast = *(fast + 1);
				    }
				}
			    }
# endif				/* __HEAD_LEFT__ */
			} else {
			    l2_q_xls(deck, slip & ((Q(1) << copy) - 1));
			    if (1) {
				deck ^= integral_q_last;
				if (1) {
				    *KD(node) = news & ~(Q(1) << deck);

				    ever = (copy - deck) >> 1;
				    deck = ever >> 1;
				    for (; deck; deck--) {
					*fast = *(fast - 2);
					fast -= 2;
					*fast = *(fast - 2);
					fast -= 2;
				    }
				    if (ever & 1) {
					*fast = *(fast - 2);
					fast -= 2;
				    }
				    {
					*fast = *(fast - 1);
				    }
				}
			    }
			}
#endif				/* ____FINE_METHOD__ == __FINE_SELECT__ */
		    }
		}
	    }
	} else {
	    *KD(node) = news & ~(Q(1) << copy);
	    if (1) {
		status = FINE_ERROR + copy;
	    }
	}
    } while (0);

    return status;
}


static int
lose(void *bqfset, void *date, integral_q *path, void *high, unsigned pass,
     integral_q *turn, void *near, unsigned rate, integral_q mode)
{
    int status;
    integral_q *file, pipe;
    unsigned call;
    void *node;

    node = PD(high)[pass];

    pipe = *KD(node);

    while (1) {
#if 1
	seek_rate(node, pipe, mode, call);
#else
	seek_copy(node, mode, call);
#endif				/* 0 */

	file = PD(node)[call];

	if (rate) {
	    integral_q lane;

	    lane = *file;

	    if (lane & ~Lx55555555) {
		if (call ^ (integral_q_bits - 1)) {
		    if (pipe & ((Q(1) << call) - 1) << 1) {
			date = NULL;
			near = NULL;
		    } else {
			near = NULL;
			if (date) {
			    date = PD(date)[integral_q_last];
			} else {
			    if (text_rate(rate, bqfset)) {
				integral_q fold, late;

				late = Q(1) << pass;

				fold = *KD(high);
				if (fold & (late - 1) << 1) {
				    if (fold & late) {
					date = PD(high)[pass - 1];
					path = KD(high) + pass;
				    } else {
					date = PD(high)[pass - 2];
					path = KD(high) + pass - 1;
				    }

				    date = PD(date)[integral_q_last];
				}
			    }
			}
		    }
		} else {
		    date = NULL;
		    if (near) {
			if (*KD(near) & 2) {
			    near = PD(near)[0];
			} else {
			    near = PD(near)[1];
			}
		    } else {
			if (text_rate(rate, bqfset)) {
			    if (pass ^ (integral_q_bits - 1)) {
				turn = KD(high) + pass + 1;
				if (pass & 1) {
				    if (*KD(high) & (Q(1) << (pass + 2))) {
					near = PD(high)[pass + 1];
				    } else {
					near = PD(high)[pass + 2];
				    }
				} else {
				    near = PD(high)[pass + 1];
				}

				if (*KD(near) & 2) {
				    near = PD(near)[0];
				} else {
				    near = PD(near)[1];
				}
			    }
			}
		    }
		}

		high = node;

		pass = call;

		node = file;

		pipe = lane;

		rate = rate - 1;
	    } else {
		integral_q *club, *head, *past, *tier;

		if (call & 1) {
		    if (pipe & (Q(1) << call)) {
			club = PD(node)[call - 1];
			head = KD(node) + call;
		    } else {
			if (call ^ 1) {
			    club = PD(node)[call - 2];
			    head = KD(node) + call - 1;
			} else {
			    head = path;
			    if (date) {
				club = PD(date)[integral_q_last];
			    } else {
				club = NULL;
				if (text_rate(rate, bqfset)) {
				    integral_q fold;

				    fold = *KD(high);
				    if (fold & ((Q(1) << pass) - 1) << 1) {
					if (fold & (Q(1) << pass)) {
					    date = PD(high)[pass - 1];
					    path = KD(high) + pass;
					} else {
					    date = PD(high)[pass - 2];
					    path = KD(high) + pass - 1;
					}

					head = path;
					club = PD(date)[integral_q_last];
				    }
				}
			    }
			}
		    }
		    if (call ^ (integral_q_bits - 1)) {
			past = KD(node) + call + 1;
			if (pipe & (Q(1) << (call + 2))) {
			    tier = PD(node)[call + 1];
			} else {
			    tier = PD(node)[call + 2];
			}
		    } else {
			past = turn;
			if (near) {
			    if (*KD(near) & 2) {
				tier = PD(near)[0];
			    } else {
				tier = PD(near)[1];
			    }
			} else {
			    tier = NULL;
			    if (text_rate(rate, bqfset)) {
				if (pass ^ (integral_q_bits - 1)) {
				    turn = KD(high) + pass + 1;
				    if (pass & 1) {
					if (*KD(high) & (Q(1) << (pass + 2))) {
					    near = PD(high)[pass + 1];
					} else {
					    near = PD(high)[pass + 2];
					}
				    } else {
					near = PD(high)[pass + 1];
				    }

				    past = turn;
				    if (*KD(near) & 2) {
					tier = PD(near)[0];
				    } else {
					tier = PD(near)[1];
				    }
				}
			    }
			}
		    }
		} else {
		    past = KD(node) + call + 1;
		    tier = PD(node)[call + 1];
		    if (call) {
			club = PD(node)[call - 1];
			head = KD(node) + call;
		    } else {
			head = path;
			if (date) {
			    club = PD(date)[integral_q_last];
			} else {
			    club = NULL;
			    if (text_rate(rate, bqfset)) {
				integral_q fold;

				fold = *KD(high);
				if (fold & ((Q(1) << pass) - 1) << 1) {
				    if (fold & (Q(1) << pass)) {
					date = PD(high)[pass - 1];
					path = KD(high) + pass;
				    } else {
					date = PD(high)[pass - 2];
					path = KD(high) + pass - 1;
				    }

				    head = path;
				    club = PD(date)[integral_q_last];
				}
			    }
			}
			{
			}
			{
			}
		    }
		}

		status = _libx1f4l2_lift_bqpset
		    (bqfset, date, path, &head, &club, pipe, &node, &call,
		     &file, &tier, &past, turn, near, mode);
		if (status == FREE_ERROR) {
		    break;
		} else {
		}

		date = club;

		path = head;

		high = node;

		pass = call;

		node = file;

		pipe = *KD(file);

		turn = past;

		near = tier;

		rate = rate - 1;
	    }
	} else {
	    status = fine(bqfset, file, mode);
	    if (status) {
		if (status < FINE_ERROR) {
		    if (status < LAST_ERROR) {
		    } else {
			integral_q *head;

			if (call & 1) {
			    if (pipe & (Q(1) << call)) {
				head = KD(node) + call;
			    } else {
				if (call ^ 1) {
				    head = KD(node) + call - 1;
				} else {
				    head = path;
				    if (date) {
				    } else {
					if (text_rate(0, bqfset)) {
					    integral_q fold;

					    fold = *KD(high);
					    if (fold
						& ((Q(1) << pass) - 1) << 1) {
						if (fold & (Q(1) << pass)) {
						    path = KD(high) + pass;
						} else {
						    path = KD(high) + pass - 1;
						}

						head = path;
					    } else {
					    }
					} else {
					}
				    }
				}
			    }
			} else {
			    if (call) {
				head = KD(node) + call;
			    } else {
				head = path;
				if (date) {
				} else {
				    if (text_rate(0, bqfset)) {
					integral_q fold;

					fold = *KD(high);
					if (fold & ((Q(1) << pass) - 1) << 1) {
					    if (fold & (Q(1) << pass)) {
						path = KD(high) + pass;
					    } else {
						path = KD(high) + pass - 1;
					    }

					    head = path;
					}
				    } else {
				    }
				}
			    }
			}

			if (head) {
			    if (mode ^ *head) {
				status = MISS_CLASS;
			    } else {
				status = 0;

				*KD(file) ^= Q(2);

				*head = *(file + 1);
			    }
			} else {
			    status = MISS_CLASS;
			}
		    }
		} else {
		    integral_q *club, *head, last, next, *past, *tier;
		    unsigned copy, deck, ever;

		    if (call & 1) {
			if (pipe & (Q(1) << call)) {
			    club = PD(node)[call - 1];
			    head = KD(node) + call;
			    date = NULL;
			} else {
			    if (call ^ 1) {
				club = PD(node)[call - 2];
				head = KD(node) + call - 1;
				date = NULL;
			    } else {
				head = path;
				if (date) {
				    club = PD(date)[integral_q_last];
				} else {
				    club = NULL;
				    if (text_rate(0, bqfset)) {
					integral_q fold;

					fold = *KD(high);
					if (fold & ((Q(1) << pass) - 1) << 1) {
					    if (fold & (Q(1) << pass)) {
						date = PD(high)[pass - 1];
						path = KD(high) + pass;
					    } else {
						date = PD(high)[pass - 2];
						path = KD(high) + pass - 1;
					    }

					    head = path;
					    club = PD(date)[integral_q_last];
					}
				    }
				}
			    }
			}
			if (call ^ (integral_q_bits - 1)) {
			    past = KD(node) + call + 1;
			    near = NULL;
			    if (pipe & (Q(1) << (call + 2))) {
				tier = PD(node)[call + 1];
			    } else {
				tier = PD(node)[call + 2];
			    }
			} else {
			    past = turn;
			    if (near) {
				if (*KD(near) & 2) {
				    tier = PD(near)[0];
				} else {
				    tier = PD(near)[1];
				}
			    } else {
				tier = NULL;
				if (text_rate(0, bqfset)) {
				    if (pass ^ (integral_q_bits - 1)) {
					turn = KD(high) + pass + 1;
					if (pass & 1) {
					    if (*KD(high)
						& (Q(1) << (pass + 2))) {
						near = PD(high)[pass + 1];
					    } else {
						near = PD(high)[pass + 2];
					    }
					} else {
					    near = PD(high)[pass + 1];
					}

					past = turn;
					if (*KD(near) & 2) {
					    tier = PD(near)[0];
					} else {
					    tier = PD(near)[1];
					}
				    }
				}
			    }
			}
		    } else {
			past = KD(node) + call + 1;
			near = NULL;
			if (call) {
			    club = PD(node)[call - 1];
			    tier = PD(node)[call + 1];
			    head = KD(node) + call;
			    date = NULL;
			} else {
			    head = path;
			    if (date) {
				club = PD(date)[integral_q_last];
			    } else {
				club = NULL;
				if (text_rate(0, bqfset)) {
				    integral_q fold;

				    fold = *KD(high);
				    if (fold & ((Q(1) << pass) - 1) << 1) {
					if (fold & (Q(1) << pass)) {
					    date = PD(high)[pass - 1];
					    path = KD(high) + pass;
					} else {
					    date = PD(high)[pass - 2];
					    path = KD(high) + pass - 1;
					}

					head = path;
					club = PD(date)[integral_q_last];
				    }
				}
			    }
			    {
				tier = PD(node)[call + 1];
			    }
			}
		    }

		    copy = status - FINE_ERROR;

		    if (copy ^ (integral_q_bits << 2)) {
		    } else {
			if (head) {
			    if (mode ^ *head) {
				status = MISS_CLASS;

				break;
			    } else {
				integral_q *fast, news, slip;

				news = *KD(file);

				slip = news & ~Lx55555555;

				if (slip) {
				    status = 0;

				    slip &= (slip - 1) << 1;

				    *KD(file) = news ^ slip;

				    fast = file + 2;

				    *head = *fast;

				    slip >>= 2;

				    news = slip >> 4;
				    for (; news; news >>= 4) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side + 2;
					*side = *fast;
				    }
				    if (slip & (Lx44444444 << 1)) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side;
				    }
				    {
					*fast = *(fast + 1);
				    }

				    break;
				} else {
				    copy = 0;
				}
			    }
			} else {
			    status = MISS_CLASS;

			    break;
			}
		    }

		    status = 0;

		    {
			here_two_declarations;

			if (club) {
			    last = *club;
			    here_two_l_count(deck, last, date);
			} else {
			    here_two_l_reset(deck);

			    /*
			     * rubbish warnings...
			     */
			    last = 0;
			}

			if (tier) {
			    next = *tier;
			    here_two_n_count(ever, next, near);
			} else {
			    here_two_n_reset(ever);

			    /*
			     * rubbish warnings...
			     */
			    next = 0;
			}

			here_two_setup(deck, ever);
		    }

		    if (here_two_test(deck | ever)) {
			if (deck < ever) {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q *fast, *side, text;

				fast = file;

				if (copy) {
				} else {
				    copy = 2;

				    *head = *(file + 2);
				}

				fast += copy;

				deck = (integral_q_bits - copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				for (; deck; deck--) {
				    *fast = *(fast + 2);
				    fast += 2;
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				ever &= 254;

				if (ever < 4) {
				    ever = 1;

				    *KD(fast) = Lx55555555;

				    fast += integral_q_bits - 2;
				} else {
				    *KD(fast) = Lx55555555
					| ~Q(0)
					<< (integral_q_bits - ever + 2);

				    if (ever < 8) {
					ever >>= 1;

					fast += integral_q_bits - ever;
				    } else {
					fast += integral_q_bits - ever + 3;

					side = fast + 1;

					ever >>= 1;

					deck = ever - 3;
					for (; deck; deck--) {
					    *fast = *side;
					    side += 2;
					    fast++;
					}
				    }
				}

				*fast = *past;

				fast++;

				ever--;

				side = tier;

				text = *side;

				while (ever & ~1) {
				    if (text & Q(2)) {
					side++;
					*fast = *side;
					fast++;
					side++;
					*fast = *side;
					fast++;

					ever -= 2;
				    } else {
					ever--;

					side += 2;
					*fast = *side;
					fast++;
				    }

				    text >>= 2;
				}
				if (ever) {
				    if (text & Q(2)) {
					side++;
					*fast = *side;
					side++;
					*past = *side;

					ever = 0;
				    } else {
					side += 2;
					*fast = *side;
				    }

				    text >>= 2;
				} else {
				    ever = 1;
				}
				if (ever) {
				    if (text & Q(2)) {
					side++;
					*past = *side;

					side++;

					fast = tier + 2;

					text >>= 1;
				    } else {
					side += 2;
					*past = *side;

					side++;

					fast = tier + 2;

					text >>= 2;

					if (fast < side) {
					    text >>= 1;
					    if (text & Q(1)) {
						*fast = *side;
						fast += 2;
					    } else {
					    }

					    side++;
					}
				    }
				} else {
				    side++;

				    fast = tier + 2;

				    if (fast < side) {
					text >>= 1;
					if (text & Q(1)) {
					    *fast = *side;
					    fast += 2;
					} else {
					}

					side++;
				    }
				}
				while (fast < side) {
				    if (text & Q(4)) {
					*fast = *side;
					fast += 2;
					side++;
					*fast = *side;
					fast += 2;
					side++;
				    } else {
					*fast = *side;
					fast += 2;
					side += 2;
				    }

				    text >>= 2;
				}

				*KD(tier) &= Lx55555555
				    | ~Q(0) << 2 << (fast - tier - 2);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			} else {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q *fast, *side, text;

				fast = file;

				if (copy) {
				} else {
				    copy = 2;

				    *head = *(file + 2);
				}

				fast += copy;

				ever = (copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				for (; ever; ever--) {
				    *fast = *(fast - 2);
				    fast -= 2;
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				deck &= 254;

				if (deck < 4) {
				    deck = 1;

				    *KD(fast) = Lx55555555;

				    fast += 2;
				} else {
				    *KD(fast) = Lx55555555
					| ((Q(1) << (deck - 2)) - 1);

				    if (deck < 8) {
					deck >>= 1;

					fast += deck;
				    } else {
					fast += deck - 3;

					side = fast - 1;

					deck >>= 1;

					ever = deck - 3;
					for (; ever; ever--) {
					    *fast = *side;
					    side -= 2;
					    fast--;
					}
				    }
				}

				*fast = *head;

				fast--;

				deck--;

				side = club;

				text = *side;

				side += integral_q_bits;

				while (deck & ~1) {
				    if (text & Q(1) << integral_q_last) {
					side--;
					*fast = *side;
					fast--;
					side--;
					*fast = *side;
					fast--;

					deck -= 2;
				    } else {
					deck--;

					side -= 2;
					*fast = *side;
					fast--;
				    }

				    text <<= 2;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					side--;
					*fast = *side;
					side--;
					*head = *side;

					deck = 0;
				    } else {
					side -= 2;
					*fast = *side;
				    }

				    text <<= 2;
				} else {
				    deck = 1;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					side--;
					*head = *side;

					side--;

					fast = club + integral_q_bits - 2;

					text <<= 1;
				    } else {
					side -= 2;
					*head = *side;

					side--;

					fast = club + integral_q_bits - 2;

					text <<= 2;

					if (side < fast) {
					    if (text
						& Q(1) << integral_q_last) {
						*fast = *side;
						fast -= 2;
					    }

					    side--;

					    text <<= 1;
					}
				    }
				} else {
				    side--;

				    fast = club + integral_q_bits - 2;

				    if (side < fast) {
					if (text & Q(1) << integral_q_last) {
					    *fast = *side;
					    fast -= 2;
					}

					side--;

					text <<= 1;
				    }
				}
				while (side < fast) {
				    if (text & Q(1) << (integral_q_bits - 2)) {
					*fast = *side;
					fast -= 2;
					side--;
					*fast = *side;
					fast -= 2;
					side--;
				    } else {
					*fast = *side;
					fast -= 2;
					side -= 2;
				    }

				    text <<= 2;
				}

				*KD(club) &=
				    Lx55555555 | ((Q(1) << (fast - club)) - 1);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			}
		    } else {
			do {
			    integral_q *fast;

			    if (tier) {
				if (club) {
				} else {
				    head = past;

				    _libx1f4l2_four_bqpset
					(bqfset, last, &club, pipe, &node,
					 &call, &file, &past, &tier, next,
					 &copy);
				    if (club) {
				    } else {
					break;
				    }
				}
			    } else {
				if (1) {
				    past = head;

				    _libx1f4l2_nine_bqpset
					(bqfset, last, &club, pipe, &node,
					 &call, &head, &file, &tier, next,
					 &copy);
				    if (tier) {
				    } else {
					break;
				    }
				}
			    }

			    if (copy ^ half_integral_q_bits) {
				fast = file;

				if (copy) {
				} else {
				    copy = 2;

				    *head = *(file + 2);
				}

				fast += copy;

				if (copy < half_integral_q_bits) {
				    deck = (half_integral_q_bits - copy) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					*fast = *(fast + 2);
					fast += 2;
				    }
# endif				/* __UNROLL_TRANSFER__ */
				} else {
				    deck = (copy - half_integral_q_bits) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					*fast = *(fast - 2);
					fast -= 2;
				    }
# endif				/* __UNROLL_TRANSFER__ */
				}
			    }

			    {
				integral_q *side;

				fast = club;

				*fast = Lxdddddddd ^ Q(1) << integral_q_last;

				if (0) {
				} else {
				    fast += 4;

				    side = fast - 1;

				    *side = *fast;
				    fast += 2;
				    side++;
				}

				deck = (integral_q_bits - 6) / 6;
				for (; deck; deck--) {
				    *side = *fast;
				    fast += 2;
				    side += 2;
				    *side = *fast;
				    fast += 2;
				    side++;
				    *side = *fast;
				    fast += 2;
				    side++;
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					*side = *fast;

					fast = file;

					fast += 2;
					side += 2;
					*side = *head;
					side++;
					*side = *fast;
					side++;
				    } else {
					*side = *fast;
					fast += 2;
					side += 2;
					*side = *fast;

					fast = file;

					side++;
					*side = *head;
					side++;
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    fast += 2;
				    *side = *fast;
				    side += 2;
				    fast += 2;
				    *side = *fast;
				    side++;
				    fast += 2;
				    *side = *fast;
				    side++;
				}

				{
				    fast += 2;
				    *side = *fast;
				    side += 2;
				    fast += 2;
				    *side = *fast;
				}

				fast = tier;

				fast += integral_q_bits;

				side = fast;

				deck = integral_q_bits / 6;
				for (; deck; deck--) {
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side -= 2;
				    fast -= 2;
				    *side = *fast;
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					fast = file + integral_q_bits - 2;

					side--;
					*side = *past;
					side--;
					*side = *fast;
					side -= 2;
					fast -= 2;
					*side = *fast;
				    } else {
					side--;
					fast -= 2;
					*side = *fast;

					fast = file + integral_q_bits - 2;

					side--;
					*side = *past;
					side -= 2;
					*side = *fast;
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side -= 2;
				    fast -= 2;
				    *side = *fast;
				}

				{
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side--;
				    fast -= 2;
				    *side = *fast;
				}

				*(side - 2) = Lxdddddddd;
			    }

			    if (call ^ integral_q_last) {
				int excess;

				*head = *(fast - 4);

				status = edge(node, call);

				excess = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (excess) {
				    status = FREE_ERROR;
				}
			    } else {
				int excess;

				*past = *(fast - 4);

				status = east(node, call);

				excess = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (excess) {
				    status = FREE_ERROR;
				}
			    }
			} while (0);
		    }
		}
	    }

	    break;
	}
    }

    return status;
}


static int
miss(void *bqfset, unsigned mind, void *node, unsigned pick, unsigned rate,
     integral_q mode)
{
    int status;

    if (1) {
	integral_q *club, *head, *past, *tier;

	if (pick) {
	    club = ND(node)[pick - 1];
	    head = KD(node) + pick;
	    if (pick ^ mind) {
		past = KD(node) + pick + 1;
		tier = ND(node)[pick + 1];
	    } else {
		past = NULL;
		tier = NULL;
	    }
	} else {
	    club = NULL;
	    head = NULL;
	    past = KD(node) + pick + 1;
	    tier = ND(node)[pick + 1];
	}

	do {
	    integral_q *file;

	    file = ND(node)[pick];

	    if (*file & ~Lx55555555) {
	    } else {
		status = _libx1f4l2_sand_bqpset
		    (bqfset, mind, node, &club, &head, &pick, file, &past,
		     &tier, rate, mode);
		if (status) {
		    if (status < LAST_ERROR) {
			break;
		    } else {
			if (status ^ (LAST_ERROR + integral_q_bits)) {
			    status = shut
				(bqfset, bqfset(bqfset)->link_a.fpnews.node,
				 rate, mode);

			    break;
			} else {
			    mind--;

			    file = ND(node)[pick];
			}
		    }
		}
	    }

	    status = lose
		(bqfset, club, head, node, trap(pick), past, tier, rate - 1,
		 mode);
	} while (0);
    }

    return status;
}


static int
shut(void *bqfset, void *node, unsigned rate, integral_q mode)
{
    int status;
    integral_q *call;
    unsigned mind, pick, size;

    call = node;

    size = *call;

    mind = size;

    call++;

    size--;
    while (size) {
	unsigned half;

	half = (size + 1) >> 1;
	if (mode < call[half]) {
	    size = half - 1;
	} else {
	    call += half;
	    size -= half;
	}
    }

    if (mode < *call) {
	call--;
    } else {
    }

    pick = call - (integral_q *) node;

    if (rate ^ 1) {
	status = miss(bqfset, mind, node, pick, rate - 1, mode);
    } else {
	do {
	    integral_q *file;

	    file = (integral_q *) ND(node)[pick];

	    status = fine(bqfset, file, mode);
	    if (status) {
		if (status < FINE_ERROR) {
		    if (status < LAST_ERROR) {
		    } else {
			if (pick) {
			    if (mode ^ *call) {
				status = MISS_CLASS;
			    } else {
				status = 0;

				*KD(file) ^= Q(2);

				*call = *(file + 1);
			    }
			} else {
			    status = MISS_CLASS;
			}
		    }
		} else {
		    integral_q *club, last, next, *tier;
		    unsigned copy, deck, ever;

		    copy = status - FINE_ERROR;

		    if (copy ^ (integral_q_bits << 2)) {
		    } else {
			if (pick) {
			    if (mode ^ *call) {
				status = MISS_CLASS;

				break;
			    } else {
				integral_q *fast, news, slip;

				news = *KD(file);

				slip = news & ~Lx55555555;

				if (slip) {
				    status = 0;

				    slip &= (slip - 1) << 1;

				    *KD(file) = news ^ slip;

				    fast = file + 2;

				    *call = *fast;

				    slip >>= 2;

				    news = slip >> 4;
				    for (; news; news >>= 4) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side + 2;
					*side = *fast;
				    }
				    if (slip & (Lx44444444 << 1)) {
					integral_q *side;

					side = fast + 2;
					*fast = *side;
					fast = side;
				    }
				    {
					*fast = *(fast + 1);
				    }

				    break;
				} else {
				    copy = 0;
				}
			    }
			} else {
			    status = MISS_CLASS;

			    break;
			}
		    }

		    status = 0;

		    if (pick) {
			club = (integral_q *) ND(node)[pick - 1];
			last = *club;
			l2_q_bitcount(deck, last);
		    } else {
			deck = 0;

			/*
			 * rubbish warnings...
			 */
			last = 0;
			club = NULL;
		    }

		    if (pick ^ mind) {
			tier = (integral_q *) ND(node)[pick + 1];
			next = *tier;
			l2_q_bitcount(ever, next);
		    } else {
			ever = 0;

			/*
			 * rubbish warnings...
			 */
			next = 0;
			tier = NULL;
		    }

		    if (half_integral_q_bits < deck
			|| half_integral_q_bits < ever) {
			if (deck < ever) {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q *fast, *side, text;

				fast = file;

				if (copy) {
				} else {
				    copy = 2;

				    KD(node)[pick] = *(file + 2);
				}

				fast += copy;

				deck = (integral_q_bits - copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				for (; deck; deck--) {
				    *fast = *(fast + 2);
				    fast += 2;
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				ever -= half_integral_q_bits;

				if (ever < 4) {
				    ever = 1;

				    *KD(fast) = Lx55555555;

				    fast += integral_q_bits - 2;
				} else {
				    ever &= ~1;

				    *KD(fast) = Lx55555555
					| ~Q(0)
					<< (integral_q_bits - ever + 2);

				    if (ever < 8) {
					ever >>= 1;

					fast += integral_q_bits - ever;
				    } else {
					fast += integral_q_bits - ever + 3;

					side = fast + 1;

					ever >>= 1;

					deck = ever - 3;
					for (; deck; deck--) {
					    *fast = *side;
					    side += 2;
					    fast++;
					}
				    }
				}

				*fast = KD(node)[pick + 1];

				fast++;

				ever--;

				side = tier;

				text = *side;

				while (ever & ~1) {
				    if (text & Q(2)) {
					side++;
					*fast = *side;
					fast++;
					side++;
					*fast = *side;
					fast++;

					ever -= 2;
				    } else {
					ever--;

					side += 2;
					*fast = *side;
					fast++;
				    }

				    text >>= 2;
				}
				if (ever) {
				    if (text & Q(2)) {
					side++;
					*fast = *side;
					side++;
					KD(node)[pick + 1] = *side;

					ever = 0;
				    } else {
					side += 2;
					*fast = *side;
				    }

				    text >>= 2;
				} else {
				    ever = 1;
				}
				if (ever) {
				    if (text & Q(2)) {
					side++;
					KD(node)[pick + 1] = *side;

					side++;

					fast = tier + 2;

					text >>= 1;
				    } else {
					side += 2;
					KD(node)[pick + 1] = *side;

					side++;

					fast = tier + 2;

					text >>= 2;

					if (fast < side) {
					    text >>= 1;
					    if (text & Q(1)) {
						*fast = *side;
						fast += 2;
					    } else {
					    }

					    side++;
					}
				    }
				} else {
				    side++;

				    fast = tier + 2;

				    if (fast < side) {
					text >>= 1;
					if (text & Q(1)) {
					    *fast = *side;
					    fast += 2;
					} else {
					}

					side++;
				    }
				}
				while (fast < side) {
				    if (text & Q(4)) {
					*fast = *side;
					fast += 2;
					side++;
					*fast = *side;
					fast += 2;
					side++;
				    } else {
					*fast = *side;
					fast += 2;
					side += 2;
				    }

				    text >>= 2;
				}

				*KD(tier) &= Lx55555555
				    | ~Q(0) << 2 << (fast - tier - 2);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			} else {
#if __HALF_TRANSFER__
			    if (1) {
				integral_q *fast, *side, text;

				fast = file;

				if (copy) {
				} else {
				    copy = 2;

				    KD(node)[pick] = *(file + 2);
				}

				fast += copy;

				ever = (copy - 2) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				for (; ever; ever--) {
				    *fast = *(fast - 2);
				    fast -= 2;
				}
# endif				/* __UNROLL_TRANSFER__ */

				fast = file;

				deck -= half_integral_q_bits;

				if (deck < 4) {
				    deck = 1;

				    *KD(fast) = Lx55555555;

				    fast += 2;
				} else {
				    deck &= ~1;

				    *KD(fast) = Lx55555555
					| ((Q(1) << (deck - 2)) - 1);

				    if (deck < 8) {
					deck >>= 1;

					fast += deck;
				    } else {
					fast += deck - 3;

					side = fast - 1;

					deck >>= 1;

					ever = deck - 3;
					for (; ever; ever--) {
					    *fast = *side;
					    side -= 2;
					    fast--;
					}
				    }
				}

				*fast = KD(node)[pick];

				fast--;

				deck--;

				side = club;

				text = *side;

				side += integral_q_bits;

				while (deck & ~1) {
				    if (text & Q(1) << integral_q_last) {
					side--;
					*fast = *side;
					fast--;
					side--;
					*fast = *side;
					fast--;

					deck -= 2;
				    } else {
					deck--;

					side -= 2;
					*fast = *side;
					fast--;
				    }

				    text <<= 2;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					side--;
					*fast = *side;
					side--;
					KD(node)[pick] = *side;

					deck = 0;
				    } else {
					side -= 2;
					*fast = *side;
				    }

				    text <<= 2;
				} else {
				    deck = 1;
				}
				if (deck) {
				    if (text & Q(1) << integral_q_last) {
					side--;
					KD(node)[pick] = *side;

					side--;

					fast = club + integral_q_bits - 2;

					text <<= 1;
				    } else {
					side -= 2;
					KD(node)[pick] = *side;

					side--;

					fast = club + integral_q_bits - 2;

					text <<= 2;

					if (side < fast) {
					    if (text
						& Q(1) << integral_q_last) {
						*fast = *side;
						fast -= 2;
					    }

					    side--;

					    text <<= 1;
					}
				    }
				} else {
				    side--;

				    fast = club + integral_q_bits - 2;

				    if (side < fast) {
					if (text & Q(1) << integral_q_last) {
					    *fast = *side;
					    fast -= 2;
					}

					side--;

					text <<= 1;
				    }
				}
				while (side < fast) {
				    if (text & Q(1) << (integral_q_bits - 2)) {
					*fast = *side;
					fast -= 2;
					side--;
					*fast = *side;
					fast -= 2;
					side--;
				    } else {
					*fast = *side;
					fast -= 2;
					side -= 2;
				    }

				    text <<= 2;
				}

				*KD(club) &=
				    Lx55555555 | ((Q(1) << (fast - club)) - 1);
			    }
#else
# error
#endif				/* __HALF_TRANSFER__ */
			}
		    } else {
			do {
			    integral_q *fast;

			    if (mind ^ 1) {
			    } else {
				if (copy) {
				} else {
				    copy = 2;

				    KD(node)[pick] = *(file + 2);
				}

				status = _libx1f4l2_fold_bqpset
				    (bqfset, club, file, tier, pick, copy,
				     node);
				if (1) {
				    break;
				}
			    }

			    if (pick) {
				if (pick ^ mind) {
				} else {
				    _libx1f4l2_gray_bqpset
					(bqfset, &club, node, &pick, &file,
					 &tier, &copy);
				    if (tier) {
				    } else {
					break;
				    }
				}
			    } else {
				if (1) {
				    _libx1f4l2_blue_bqpset
					(bqfset, &club, node, &pick, &file,
					 &tier, &copy);
				    if (club) {
				    } else {
					break;
				    }
				}
			    }

			    if (copy ^ half_integral_q_bits) {
				fast = file;

				if (copy) {
				} else {
				    copy = 2;

				    KD(node)[pick] = *(file + 2);
				}

				fast += copy;

				if (copy < half_integral_q_bits) {
				    deck = (half_integral_q_bits - copy) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					*fast = *(fast + 2);
					fast += 2;
				    }
# endif				/* __UNROLL_TRANSFER__ */
				} else {
				    deck = (copy - half_integral_q_bits) >> 1;

# if __UNROLL_TRANSFER__
#  error
# else
				    for (; deck; deck--) {
					*fast = *(fast - 2);
					fast -= 2;
				    }
# endif				/* __UNROLL_TRANSFER__ */
				}
			    }

			    {
				integral_q *side;

				fast = club;

				*fast = Lxdddddddd ^ Q(1) << integral_q_last;

				if (0) {
				} else {
				    fast += 4;

				    side = fast - 1;

				    *side = *fast;
				    fast += 2;
				    side++;
				}

				deck = (integral_q_bits - 6) / 6;
				for (; deck; deck--) {
				    *side = *fast;
				    fast += 2;
				    side += 2;
				    *side = *fast;
				    fast += 2;
				    side++;
				    *side = *fast;
				    fast += 2;
				    side++;
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					*side = *fast;

					fast = file;

					fast += 2;
					side += 2;
					*side = KD(node)[pick];
					side++;
					*side = *fast;
					side++;
				    } else {
					*side = *fast;
					fast += 2;
					side += 2;
					*side = *fast;

					fast = file;

					side++;
					*side = KD(node)[pick];
					side++;
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    fast += 2;
				    *side = *fast;
				    side += 2;
				    fast += 2;
				    *side = *fast;
				    side++;
				    fast += 2;
				    *side = *fast;
				    side++;
				}

				{
				    fast += 2;
				    *side = *fast;
				    side += 2;
				    fast += 2;
				    *side = *fast;
				}

				fast = tier;

				fast += integral_q_bits;

				side = fast;

				deck = integral_q_bits / 6;
				for (; deck; deck--) {
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side -= 2;
				    fast -= 2;
				    *side = *fast;
				}

				if (0) {
				} else {
				    if (half_integral_q_bits % 3 ^ 2) {
					fast = file + integral_q_bits - 2;

					side--;
					*side = KD(node)[pick + 1];
					side--;
					*side = *fast;
					side -= 2;
					fast -= 2;
					*side = *fast;
				    } else {
					side--;
					fast -= 2;
					*side = *fast;

					fast = file + integral_q_bits - 2;

					side--;
					*side = KD(node)[pick + 1];
					side -= 2;
					*side = *fast;
				    }
				}

				deck = integral_q_bits / 4
				    - integral_q_bits / 6 - 2;
				for (; deck; deck--) {
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side -= 2;
				    fast -= 2;
				    *side = *fast;
				}

				{
				    side--;
				    fast -= 2;
				    *side = *fast;
				    side--;
				    fast -= 2;
				    *side = *fast;
				}

				*(side - 2) = Lxdddddddd;
			    }

			    if (1) {
				integral_q *side;
				void **trap;

				trap = ND(node) + pick;

				memmove(trap, trap + 1,
					(mind - pick) * sizeof(void *));

				side = KD(node) + pick;

				*side = *(fast - 4);

				side++;

				memmove(side, side + 1,
					(mind - pick) * sizeof(integral_q));

				*KD(node) = mind - 1;

				status = bqfset(bqfset)->link_m.free
				    (bqfset(bqfset)->link_m.data, file);
				if (status) {
				    status = FREE_ERROR;
				}
			    }
			} while (0);
		    }
		}
	    }
	} while (0);
    }

    return status;
}


int
x1f4_cast_bqpset(void *bqfset, integral_q mode)
{
    int status;
    unsigned rate;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
    if (rate) {
	status = shut(bqfset, bqfset(bqfset)->link_a.fpnews.node, rate, mode);
    } else {
	status = clip(bqfset(bqfset)->link_a.fpnews.node, mode);
    }

    return status;
}
