/*
 * bqpx-shift.h
 * Copyright (C) 2008-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#ifndef __LIBx1f4_bqpx_shift_H__
#define __LIBx1f4_bqpx_shift_H__

#include <bqpx-types.h>

#define SHIFT_M(node, ever, deck) \
    {									      \
	for (; deck; deck--) {						      \
	    KD(node)[ever] = KD(node)[ever - 1];			      \
	    ever--;							      \
	}								      \
    }

#undef SHIFT_M

#define SHIFT_M(node, ever, deck) \
    {									      \
	integral_q *slip;						      \
									      \
	slip = KD(node) + ever;						      \
	for (; deck; deck--) {						      \
	    *slip = slip[-1];						      \
	    slip--;							      \
	}								      \
    }

#undef SHIFT_M

#define SHIFT_M(node, ever, deck) \
    {									      \
	integral_q *slip;						      \
	unsigned miss;							      \
									      \
	slip = KD(node) + ever;						      \
	miss = deck >> 1;						      \
	if (miss) {							      \
	    for (; miss; miss--) {					      \
		*slip = *(slip - 1);					      \
		slip--;							      \
		*slip = *(slip - 1);					      \
		slip--;							      \
	    }								      \
	    if (deck & 1) {						      \
		*slip = *(slip - 1);					      \
	    }								      \
	} else {							      \
	    {								      \
		*slip = *(slip - 1);					      \
	    }								      \
	}								      \
    }

#define SHIFT_P(node, deck, ever) \
    {									      \
	for (; ever; ever--) {						      \
	    KD(node)[deck] = KD(node)[deck + 1];			      \
	    deck++;							      \
	}								      \
    }

#undef SHIFT_P

#define SHIFT_P(node, deck, ever) \
    {									      \
	integral_q *slip;						      \
									      \
	slip = KD(node) + deck;						      \
	for (; ever; ever--) {						      \
	    *slip = slip[1];						      \
	    slip++;							      \
	}								      \
    }

#undef SHIFT_P

#define SHIFT_P(node, deck, ever) \
    {									      \
	integral_q *slip;						      \
	unsigned miss;							      \
									      \
	slip = KD(node) + deck;						      \
	miss = ever >> 1;						      \
	if (miss) {							      \
	    for (; miss; miss--) {					      \
		*slip = *(slip + 1);					      \
		slip++;							      \
		*slip = *(slip + 1);					      \
		slip++;							      \
	    }								      \
	    if (ever & 1) {						      \
		*slip = *(slip + 1);					      \
	    }								      \
	} else {							      \
	    {								      \
		*slip = *(slip + 1);					      \
	    }								      \
	}								      \
    }

#define STRIP_M(node, ever, deck) \
    {									      \
	integral_q *slip;						      \
									      \
	slip = KD(node) + ever;						      \
	deck = deck >> 1;						      \
	if (1) {							      \
	    for (; deck; deck--) {					      \
		*slip = *(slip - 1);					      \
		slip--;							      \
		*slip = *(slip - 1);					      \
		slip--;							      \
	    }								      \
	    {								      \
		*slip = *(slip - 1);					      \
	    }								      \
	}								      \
    }

#define STRIP_P(node, deck, ever) \
    {									      \
	integral_q *slip;						      \
									      \
	slip = KD(node) + deck;						      \
	ever = ever >> 1;						      \
	if (1) {							      \
	    for (; ever; ever--) {					      \
		*slip = *(slip + 1);					      \
		slip++;							      \
		*slip = *(slip + 1);					      \
		slip++;							      \
	    }								      \
	    {								      \
		*slip = *(slip + 1);					      \
	    }								      \
	}								      \
    }

#define TRANS_M(node, ever, deck) \
    {									      \
	integral_q *slip;						      \
									      \
	slip = KD(node) + ever;						      \
	deck = deck >> 1;						      \
	if (1) {							      \
	    for (; deck; deck--) {					      \
		*slip = *(slip - 1);					      \
		slip--;							      \
		*slip = *(slip - 1);					      \
		slip--;							      \
	    }								      \
	}								      \
    }

#define TRANS_P(node, deck, ever) \
    {									      \
	integral_q *slip;						      \
									      \
	slip = KD(node) + deck;						      \
	ever = ever >> 1;						      \
	if (1) {							      \
	    for (; ever; ever--) {					      \
		*slip = *(slip + 1);					      \
		slip++;							      \
		*slip = *(slip + 1);					      \
		slip++;							      \
	    }								      \
	}								      \
    }

#endif				/* __LIBx1f4_bqpx_shift_H__ */
