/*
 * bqfx.n.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_lift_bqfset(void *bqfset, void *date, void *data, void **path,
		       void **lead, integral_q pipe, void **lift,
		       unsigned *mile, void **lock, void **lane, void **turn,
		       void *text, void *near, void *aime)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned call, size;
    void *club, *file, *node, *tier;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    call = *mile;

    club = *lead;

    file = *lock;

    node = *lift;

    tier = *lane;

    if (0) {
    } else {
	integral_q last, next;
	unsigned deck, ever;
	unsigned hold = 0;

	if (1) {
	    if (club) {
		last = *(integral_q *) club & ~Lx55555555;
		if (last) {
		    if (last & (last - 1)) {
			deck = 4;
			ever = 0;
			next = ~Q(0);
		    } else {
			if (tier) {
			    deck = 1;
			    next = *(integral_q *) tier & ~Lx55555555;
			    if (next) {
				if (next & (next - 1)) {
				    ever = 4;
				} else {
				    ever = 1;
				}
			    } else {
				ever = 0;
			    }
			} else {
			    deck = 4;
			    ever = 0;
			    next = ~Q(0);
			}
		    }
		} else {
		    deck = 0;
		    if (tier) {
			next = *(integral_q *) tier & ~Lx55555555;
			if (next) {
			    if (next & (next - 1)) {
				ever = 4;
			    } else {
				ever = 1;
			    }
			} else {
			    ever = 0;
			}
		    } else {
			ever = 0;
			next = ~Q(0);
			if (pipe & Q(1) << integral_q_last) {
			    hold = integral_q_bits - 3;
			} else {
			    if (pipe & Q(1) << (integral_q_bits - 3)) {
				hold = integral_q_bits - 4;
			    } else {
				hold = integral_q_bits - 5;
			    }
			}

			last =
			    *(integral_q *) ZD(node, size)[hold] & ~Lx55555555;
			if (last & (last - 1)) {
			    deck = 4;
			} else {
			    deck = 1;
			}
		    }
		}
	    } else {
		deck = 0;
		last = ~Q(0);
		next = *(integral_q *) tier & ~Lx55555555;
		if (next) {
		    ever = 4;
		} else {
		    ever = 0;
		    if (call) {
			if (pipe & Q(1) << 3) {
			    hold = 3;
			} else {
			    if (pipe & Q(1) << 5) {
				hold = 4;
			    } else {
				hold = 5;
			    }
			}
		    } else {
			if (pipe & Q(1) << 3) {
			    hold = 2;
			} else {
			    hold = 3;
			}
		    }

		    next = *(integral_q *) ZD(node, size)[hold] & ~Lx55555555;
		    if (next & (next - 1)) {
			ever = 4;
		    } else {
			ever = 1;
		    }
		}
	    }
	}

	if (deck | ever) {
	    status = 0;

	    if ((deck | ever) & 4) {
		if (call ^ (integral_q_bits - 1)) {
		    if (pipe & ((Q(1) << call) - 1) << 1) {
		    } else {
			ever += 2;
		    }
		} else {
		    deck += 2;
		}

		if (deck < ever) {
		    integral_q text;
		    void *data, *fast, **side, *trip;

		    if (0) {
		    } else {
			move(rule(file, size, integral_q_last), *turn, 1);
		    }

		    if (hold) {
			club = tier;

			tier = ZD(node, size)[hold];

			fast = road(club, size);

			if (hold & 1) {
			    if (pipe & Q(1) << hold) {
				trip = rule(node, size, hold);
			    } else {
				trip = rule(node, size, hold - 1);
			    }
			} else {
			    trip = rule(node, size, hold);
			}

			move(*turn, fast, 1);

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    void *this;

			    this = road(fast, size);
			    move(fast, this, 1);
			    fast = this;
			}
			{
			    move(fast, trip, 1);
			}
		    } else {
			trip = *turn;
		    }

		    text = next;
		    text &= (text - 1) << 1;

		    *(integral_q *) tier = Lx55555555 | (next & ~text);

		    text >>= 2;
		    if (text) {
			fast = road(tier, size);

			side = ZD(tier, size) + 1;

			move(trip, fast, 1);

			data = *side;

			text >>= 2;

			for (; text; text >>= 2) {
			    void *this;

			    this = road(fast, size);
			    move(fast, this, 1);
			    fast = this;
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    move(fast, sans(fast, size), 1);
			}
			{
			    *side = *(side + 1);
			}
		    } else {
			move(trip, sans(tier, size), 1);

			data = *ZD(tier, size);
		    }

		    if (hold) {
			void *sail;

			side = ZD(club, size) + 1;

			sail = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = sail;
			}
		    }

		    *(integral_q *) file =
			Lx55555555 | Q(1) << integral_q_last;

		    if (0) {
		    } else {
			side = ZD(file, size) + integral_q_last;

			{
			    *(side - 1) = *side;
			}

			{
			    *side = data;
			}
		    }
		} else {
		    integral_q text;
		    void *data, *fast, **side, *trip;

		    if (0) {
		    } else {
			move(sans(file, size), *path, 1);
		    }

		    if (hold) {
			tier = club;

			club = ZD(node, size)[hold];

			fast = rule(tier, size, integral_q_bits - 2);

			if (1) {
			    trip = rule(node, size, hold + 1);
			}

			move(*path, fast, 1);

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    void *this;

			    this = lola(fast, size);
			    move(fast, this, 1);
			    fast = this;
			}
			{
			    move(fast, trip, 1);
			}
		    } else {
			trip = *path;
		    }

		    text = last;

		    if (text & Q(1) << integral_q_last) {
			move(trip, rule(club, size, integral_q_last), 1);

		        side = ZD(club, size) + integral_q_bits - 1;

			data = *side;
			*side = *(side - 1);

			*(integral_q *) club = Lx55555555
			    | (last ^ Q(1) << integral_q_last);
		    } else {
			fast = rule(club, size, integral_q_bits - 2);

		        side = ZD(club, size) + integral_q_bits - 1;

			move(trip, fast, 1);

			data = *side;

			text <<= 2;

			for (; !(text & Q(1) << integral_q_last); text <<= 2) {
			    void *this;

			    this = lola(fast, size);
			    move(fast, this, 1);
			    fast = this;
			    *side = *(side - 2);
			    side -= 2;
			    
			}
			{
			    move(fast, life(fast, size), 1);
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 1);
			}

			*(integral_q *) club = Lx55555555
			    | (last ^ Q(1) << (side - ZD(club, size)));
		    }

		    if (hold) {
			void *sail;

			side = ZD(tier, size) + integral_q_bits - 1;

			sail = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = sail;
			}
		    }

		    *(integral_q *) file = Lx55555555 | 2;

		    if (0) {
		    } else {
			side = ZD(file, size);

			{
			    *side = data;
			}
		    }
		}
	    } else {
		if (club) {
		    if (tier) {
		    } else {
			if (pipe & Q(1) << integral_q_last) {
			    call = integral_q_bits - 2;
			} else {
			    call = integral_q_bits - 3;
			}

			*mile = call;

			*lane = file;
			*lock = club;
			*lead = ZD(node, size)[hold];

			*turn = *path;
			if (pipe & Q(1) << integral_q_last) {
			    *path = rule(node, size, integral_q_bits - 2);
			} else {
			    if (pipe & Q(1) << (integral_q_bits - 3)) {
				*path = rule(node, size, integral_q_bits - 3);
			    } else {
				*path = rule(node, size, integral_q_bits - 4);
			    }
			}
		    }
		} else {
		    if (call) {
			if (pipe & Q(1) << 3) {
			    call = 2;
			} else {
			    call = 3;
			}
		    } else {
			call++;
		    }

		    *mile = call;

		    *lead = file;
		    *lock = tier;
		    *lane = ZD(node, size)[hold];

		    *path = *turn;
		    *turn = rule(node, size, call + 1);
		}

		status = _libx1f4l2_pack_bqfset
		    (bqfset, date, data, path, lead, pipe, lift, mile, lock,
		     lane, turn, text, near, aime);
	    }
	} else {
	    status = _libx1f4l2_pack_bqfset
		(bqfset, date, data, path, lead, pipe, lift, mile, lock, lane,
		 turn, text, near, aime);
	}
    }

    return status;
}
