/*
 * bqfx.m.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define life(___s, ___n) \
    ((char *) (___s) - (___n))

#define lola(___s, ___n) \
    ((char *) (___s) - ((___n) << 1))

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_sand_bqfset(void *bqfset, unsigned mind, void *node, void **lead,
		       void **path, unsigned *pace, void *file, void **turn,
		       void **lane, unsigned rate, void *aime)
{
    int (*move) (void *, void *, unsigned), status;
    unsigned hold = 0, pick, size;
    void *club, *tier;

    move = bqfset(bqfset)->link_f.move;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    pick = *pace;

    club = *lead;

    tier = *lane;

    file = MD(node, size)[pick];

    if (0) {
    } else {
	integral_q lack, last, next;
	unsigned deck, ever;

	if (club) {
	    last = *(integral_q *) club & ~Lx55555555;
	    if (last) {
		if (last & (last - 1)) {
		    deck = 4;
		    ever = 0;
		    next = ~Q(0);
		} else {
		    if (tier) {
			deck = 1;
			next = *(integral_q *) tier & ~Lx55555555;
			if (next) {
			    if (next & (next - 1)) {
				ever = 4;
			    } else {
				ever = 1;
			    }
			} else {
			    ever = 0;
			}
		    } else {
			if (mind ^ 1) {
			    deck = 4;
			} else {
			    deck = 1;
			}

			ever = 0;
			next = ~Q(0);
		    }
		}

		lack = last;
	    } else {
		deck = 0;
		if (tier) {
		    next = *(integral_q *) tier & ~Lx55555555;
		    if (next) {
			if (next & (next - 1)) {
			    ever = 4;
			} else {
			    ever = 1;
			}
		    } else {
			ever = 0;
		    }

		    lack = next;
		} else {
		    ever = 0;
		    next = ~Q(0);
		    if (mind ^ 1) {
			lack = *(integral_q *) MD(node, size)[pick - 2]
			    & ~Lx55555555;
			if (lack) {
			    if (pick - 2) {
				deck = 4;
			    } else {
				if (lack & (lack - 1)) {
				    deck = 4;
				}
			    }

			    hold = 2;
			    lack = Q(1) << integral_q_last;
			} else {
			    lack = last;
			}
		    } else {
			lack = last;
		    }
		}
	    }
	} else {
	    deck = 0;
	    next = *(integral_q *) tier & ~Lx55555555;
	    if (next) {
		if (mind ^ 1) {
		    ever = 4;
		} else {
		    if (next & (next - 1)) {
			ever = 4;
		    } else {
			ever = 1;
		    }
		}

		lack = next;
		last = ~Q(0);
	    } else {
		ever = 0;
		last = ~Q(0);
		if (mind ^ 1) {
		    lack = *(integral_q *) MD(node, size)[2] & ~Lx55555555;
		    if (lack) {
			if (mind ^ 2) {
			    ever = 4;
			} else {
			    if (lack & (lack - 1)) {
				ever = 4;
			    }
			}

			hold = 1;
			lack = Q(1) << integral_q_last;
		    } else {
			lack = next;
		    }
		} else {
		    lack = next;
		}
	    }
	}

	if (lack) {
	    if ((deck | ever) & 4) {
		status = 0;

		if (deck < ever) {
		    integral_q text;
		    unsigned call;
		    void *data, *fast, **side;

		    if (0) {
		    } else {
			/* _*turn_ is _rule(node, size, pick + 1)_ */
			move(rule(file, size, integral_q_last), *turn, 1);
		    }

		    if (hold) {
			club = tier;

			tier = MD(node, size)[pick + 2];

			next = *(integral_q *) tier & ~Lx55555555;

			call = pick + 2;

			fast = road(club, size);

			move(rule(node, size, pick + 1), fast, 1);

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    void *this;

			    this = road(fast, size);
			    move(fast, this, 1);
			    fast = this;
			}
			{
			    move(fast, rule(node, size, call), 1);
			}
		    } else {
			call = pick + 1;
		    }

		    fast = tier;

		    text = next;
		    text &= (text - 1) << 1;

		    *(integral_q *) fast = Lx55555555 | (next & ~text);

		    text >>= 2;
		    if (text) {
			dana(fast, size);

			side = ZD(tier, size) + 1;

			move(rule(node, size, call), fast, 1);

			data = *side;

			text >>= 2;

			for (; text; text >>= 2) {
			    void *this;

			    this = road(fast, size);
			    move(fast, this, 1);
			    fast = this;
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    move(fast, sans(fast, size), 1);
			}
			{
			    *side = *(side + 1);
			}
		    } else {
			move(rule(node, size, call), sans(fast, size), 1);

			data = *ZD(tier, size);
		    }

		    if (hold) {
			void *sail;

			side = ZD(club, size) + 1;

			sail = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = *(side + 2);
			    side += 2;
			}
			{
			    *side = sail;
			}
		    }

		    *(integral_q *) file =
			Lx55555555 | Q(1) << integral_q_last;

		    if (0) {
		    } else {
			side = ZD(file, size) + integral_q_last;

			{
			    *(side - 1) = *side;
			}

			{
			    *side = data;
			}
		    }
		} else {
		    integral_q text;
		    unsigned call;
		    void *data, *fast, **side;

		    if (0) {
		    } else {
			/* _*path_ is _rule(node, size, pick)_ */
			move(sans(file, size), *path, 1);
		    }

		    if (hold) {
			tier = club;

			club = MD(node, size)[pick - 2];

			last = *(integral_q *) club & ~Lx55555555;

			call = pick - 1;

			fast = rule(tier, size, integral_q_bits - 2);

			move(rule(node, size, pick), fast, 1);

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    void *this;

			    this = lola(fast, size);
			    move(fast, this, 1);
			    fast = this;
			}
			{
			    move(fast, rule(node, size, call), 1);
			}
		    } else {
			call = pick;
		    }

		    text = last;

		    if (text & Q(1) << integral_q_last) {
			move(rule(node, size, call),
			     rule(club, size, integral_q_last), 1);

			side = ZD(club, size) + integral_q_bits - 1;

			data = *side;
			*side = *(side - 1);

			*(integral_q *) club = Lx55555555
			    | (last ^ Q(1) << integral_q_last);
		    } else {
			fast = rule(club, size, integral_q_bits - 2);

			side = ZD(club, size) + integral_q_bits - 1;

			move(rule(node, size, call), fast, 1);

			data = *side;

			text <<= 2;

			for (; !(text & Q(1) << integral_q_last); text <<= 2) {
			    void *this;

			    this = lola(fast, size);
			    move(fast, this, 1);
			    fast = this;
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    move(fast, life(fast, size), 1);
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 1);
			}

			*(integral_q *) club = Lx55555555
			    | (last ^ Q(1) << (side - ZD(club, size)));
		    }

		    if (hold) {
			void *sail;

			side = ZD(tier, size) + integral_q_bits - 1;

			sail = data;

			data = *side;

			ever = half_integral_q_bits - 2;
			for (; ever; ever--) {
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = *(side - 2);
			    side -= 2;
			}
			{
			    *side = sail;
			}
		    }

		    *(integral_q *) file = Lx55555555 | 2;

		    if (0) {
		    } else {
			side = ZD(file, size);

			{
			    *side = data;
			}
		    }
		}
	    } else {
		if (mind ^ 1) {
		    if (pick) {
			if (pick ^ mind) {
			} else {
			    pick--;

			    *pace = pick;

			    *lane = file;
			    file = club;
			    *lead = MD(node, size)[pick - 1];
			    *path = rule(node, size, pick);
			    *turn = rule(node, size, pick + 1);
			}
		    } else {
			pick++;

			*pace = pick;

			*lead = file;
			file = tier;
			*lane = MD(node, size)[pick + 1];
			*path = rule(node, size, pick);
			*turn = rule(node, size, pick + 1);
		    }

		    status = _libx1f4l2_lane_bqfset
			(bqfset, mind, node, lead, path, pace, file, turn,
			 lane, rate, aime);
		    if (status) {
		    } else {
			status = LAST_ERROR + integral_q_bits;
		    }
		} else {
#if 0
		    status = 0;
		    if (1) {
			*sign = hold;
		    }
#else
		    status = _libx1f4l2_root_bqfset(bqfset, node, rate);
#endif				/* 0 */
		}
	    }
	} else {
	    status = _libx1f4l2_join_bqfset
		(bqfset, mind, node, lead, path, pace, file, turn, lane, rate,
		 aime);
	    if (status) {
	    } else {
		status = LAST_ERROR + integral_q_bits;
	    }
	}
    }

    return status;
}
