/*
 * bqfx.h.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bcount.h>
#include <bqfx-defs.h>
#include <bqfx-lines.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <xfs.h>
#include <xls.h>

#define __HEAD_LEFT__			1

#define SCALE_P(news, copy, node, deck, ever, slip, sect) \
    {									      \
	*(integral_q *) node = news | Q(1) << (deck + 1);		      \
	ever = copy - deck - 1;						      \
	move(rule(node, size, deck + 1), rule(node, size, deck + 2), ever);   \
	for (; ever; ever--) {						      \
	    ZD(node, size)[deck] = ZD(node, size)[deck + 1];		      \
	    deck++;							      \
	}								      \
									      \
	ZD(node, size)[deck] = ZD(node, size)[deck + 1];		      \
									      \
	ZD(node, size)[deck + 1] = sect;				      \
									      \
	if (slip) {							      \
	    move(rule(node, size, deck + 1), slip, 1);			      \
	} else {							      \
	    *edit = rule(node, size, deck + 1);				      \
	}								      \
    }

#undef SCALE_P

#define SCALE_P(news, copy, node, deck, ever, slip, sect) \
    {									      \
	void *data, **text;						      \
									      \
	*(integral_q *) node = news | Q(1) << (deck + 1);		      \
	ever = copy - deck - 1;						      \
	data = rule(node, size, deck + 1);				      \
	move(data, sans(data, size), ever);				      \
	text = ZD(node, size) + deck;					      \
	for (; ever; ever--) {						      \
	    *text = *(text + 1);					      \
	    text++;							      \
	}								      \
	{								      \
	    *text = *(text + 1);					      \
	    text++;							      \
	}								      \
									      \
	{								      \
	    *text = sect;						      \
	}								      \
									      \
	if (slip) {							      \
	    move(rule(node, size, copy), slip, 1);			      \
	} else {							      \
	    *edit = rule(node, size, copy);				      \
	}								      \
    }

#define SCALE_M(news, copy, node, ever, deck, slip, sect) \
    {									      \
	*(integral_q *) node = news | Q(1) << (ever + 1);		      \
	deck = ever - copy - 1;						      \
	move(rule(node, size, copy + 2), rule(node, size, copy + 1),	      \
	     deck + 1);							      \
	for (; deck; deck--) {						      \
	    ZD(node, size)[ever] = ZD(node, size)[ever - 1];		      \
	    ever--;							      \
	}								      \
									      \
	ZD(node, size)[ever] = sect;					      \
									      \
	if (slip) {							      \
	    move(rule(node, size, ever), slip, 1);			      \
	} else {							      \
	    *edit = rule(node, size, ever);				      \
	}								      \
    }

#undef SCALE_M

#define SCALE_M(news, copy, node, ever, deck, slip, sect) \
    {									      \
	void *data, **text;						      \
									      \
	*(integral_q *) node = news | Q(1) << (ever + 1);		      \
	deck = ever - copy - 1;						      \
	data = rule(node, size, copy + 1);				      \
	move(sans(data, size), data, deck + 1);				      \
	text = ZD(node, size) + ever;					      \
	for (; deck; deck--) {						      \
	    *text = *(text - 1);					      \
	    text--;							      \
	}								      \
									      \
	{								      \
	    *text = sect;						      \
	}								      \
									      \
	if (slip) {							      \
	    move(rule(node, size, copy + 1), slip, 1);			      \
	} else {							      \
	    *edit = rule(node, size, copy + 1);				      \
	}								      \
    }

#define beta(___s, ___n) \
    (___s) = (char *) (___s) - ((___n) << 1)

#define dana(___s, ___n) \
    (___s) = (char *) (___s) + ((___n) << 1)

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define road(___s, ___n) \
    ((char *) (___s) + ((___n) << 1))

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#define sans(___s, ___n) \
    ((char *) (___s) + (___n))

#define skip(___s, ___n) \
    (___s) = (char *) (___s) + (___n)

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
_libx1f4l2_fare_bqfset(void *bqfset, void *node, unsigned copy,
		       void **fare, unsigned rate, void *aime, void **edit)
{
    int status;

    do {
	unsigned i, side, size;
	void *down, *sect, *slip;

	size = bqfset(bqfset)->link_a.fpnews.link_v.size;

	down = *fare;

	if (rate ^ 1) {
	    side = 1013;
	    slip = (char *) down + half_integral_q_bits * size;
	} else {
	    status = bqfset(bqfset)->link_f.pick(aime, down, &side);
	    if (status) {
		status = EVER_MATCH;
		if (1) {
		    break;
		}
	    } else {
		if (side ^ (half_integral_q_bits - 1)) {
		    if (side < half_integral_q_bits - 1) {
			slip = rule(down, size, half_integral_q_bits - 1);
		    } else {
			slip = rule(down, size, half_integral_q_bits - 0);
		    }
		} else {
		    slip = (void *) 0;
		}
	    }
	}

	status = bqfset(bqfset)->link_m.link
	    (bqfset(bqfset)->link_m.data, &sect,
	     integral_q_bits * (rate ^ 1 ? SIZEOF_integral_q + size : size));
	if (status) {
	    status = LINK_ERROR;
	    if (1) {
		break;
	    }
	} else {
	    int (*move) (void *, void *, unsigned);
	    integral_q news;

	    move = bqfset(bqfset)->link_f.move;

	    news = *(integral_q *) node;

	    if (copy & 1) {
		if (news & Q(1) << copy) {
		    if (copy ^ integral_q_last) {
			if (news & Q(1) << (copy + 2)) {
			    integral_q hour;
			    unsigned deck, ever;

			    hour = ~news & ~Q(0) << copy;
			    if (hour) {
				l2_q_xfs(ever, hour);
#if __HEAD_LEFT__
				hour = ((Q(1) << ever) - (Q(1) << copy))
				    >> (ever - copy - 2) & ~news;
				if (hour) {
				    l2_q_xls(deck, hour);
				    deck ^= integral_q_last;
				    deck--;
				    if (1) {
					SCALE_P(news, copy, node, deck, ever,
						slip, sect);
				    }
				} else {
				    ever--;
				    if (1) {
					SCALE_M(news, copy, node, ever, deck,
						slip, sect);
				    }
				}
#else
				ever--;
				hour = ~news & ((Q(1) << copy) - 1);
				if (hour) {
				    l2_q_xls(deck, hour);
				    deck ^= integral_q_last;
				    deck--;
				    if (copy - deck < ever - copy) {
					SCALE_P(news, copy, node, deck, ever,
						slip, sect);
				    } else {
					SCALE_M(news, copy, node, ever, deck,
						slip, sect);
				    }
				} else {
				    if (1) {
					SCALE_M(news, copy, node, ever, deck,
						slip, sect);
				    }
				}
#endif				/* __HEAD_LEFT */
			    } else {
				l2_q_xls(deck, ~news);
				if (1) {
				    deck ^= integral_q_last;
				    deck--;
				    if (1) {
					SCALE_P(news, copy, node, deck, ever,
						slip, sect);
				    }
				}
			    }
			} else {
			    void *data;

			    *(integral_q *) node = news | Q(1) << (copy + 2);

			    ZD(node, size)[copy + 1] = sect;

			    data = rule(node, size, copy + 1);

			    move(sans(data, size), data, 1);

			    if (slip) {
				move(data, slip, 1);
			    } else {
				*edit = data;
			    }
			}
		    } else {
			if (2) {
			    unsigned deck, ever;

			    l2_q_xls(deck, ~news);
			    if (1) {
				if (1) {
				    deck ^= integral_q_last;
				    deck--;
				    if (1) {
					SCALE_P(news, copy, node, deck, ever,
						slip, sect);
				    }
				}
			    }
			}
		    }
		} else {
		    *(integral_q *) node = news | Q(1) << copy;

		    ZD(node, size)[copy - 1] = down;
		    ZD(node, size)[copy] = sect;

		    if (slip) {
			move((char *) node + copy * size, slip, 1);
		    } else {
			*edit = (char *) node + copy * size;
		    }
		}
	    } else {
		if (copy) {
		    if (2) {
			if (1) {
			    integral_q hour;
			    unsigned deck, ever;

			    hour = ~news & ~Q(0) << copy;
			    if (hour) {
				l2_q_xfs(ever, hour);
#if __HEAD_LEFT__
				hour = ((Q(1) << ever) - (Q(1) << copy))
				    >> (ever - copy - 2) & ~news;
				if (hour) {
				    l2_q_xls(deck, hour);
				    deck ^= integral_q_last;
				    deck--;
				    if (1) {
					SCALE_P(news, copy, node, deck, ever,
						slip, sect);
				    }
				} else {
				    ever--;
				    if (1) {
					SCALE_M(news, copy, node, ever, deck,
						slip, sect);
				    }
				}
#else
				ever--;
				hour = ~news & ((Q(1) << (copy + 1)) - 1);
				if (hour) {
				    l2_q_xls(deck, hour);
				    deck ^= integral_q_last;
				    deck--;
				    if (copy - deck < ever - copy) {
					SCALE_P(news, copy, node, deck, ever,
						slip, sect);
				    } else {
					SCALE_M(news, copy, node, ever, deck,
						slip, sect);
				    }
				} else {
				    if (1) {
					SCALE_M(news, copy, node, ever, deck,
						slip, sect);
				    }
				}
#endif				/* __HEAD_LEFT */
			    } else {
				l2_q_xls(deck, ~news);
				if (1) {
				    deck ^= integral_q_last;
				    deck--;
				    if (1) {
					SCALE_P(news, copy, node, deck, ever,
						slip, sect);
				    }
				}
			    }
			}
		    }
		} else {
		    if (4) {
			if (3) {
			    unsigned deck, ever;

			    l2_q_xfs(ever, ~news);
			    ever--;
			    if (2) {
				if (1) {
				    if (1) {
					SCALE_M(news, copy, node, ever, deck,
						slip, sect);
				    }
				}
			    }
			}
		    }
		}
	    }

	    if (rate ^ 1) {
#if 1
		int select;
		void **data, *fast, *side, **text;

		select = bqfset(bqfset)->link_f.fare(aime, slip);

		*((integral_q *) sect) = Lx55555555;

		*((integral_q *) down) = Lx55555555;

		data = ZD(down, size) + half_integral_q_bits;

		fast = road(sect, size);

		side = rule(down, size, + half_integral_q_bits + 1);

		text = ZD(sect, size) + 1;

		for (i = half_integral_q_bits - 1; i; i--) {
		    move(fast, side, 1);
		    skip(side, size);
		    dana(fast, size);
		    *text = *data;
		    data++;
		    text += 2;
		}

		{
		    *text = *data;
		}

		data = ZD(down, size) + half_integral_q_bits - 1;

		fast = rule(down, size, integral_q_bits - 2);

		side = rule(down, size, half_integral_q_bits - 1);

		text = ZD(down, size) + integral_q_last;

		{
		    *text = *data;
		}

		for (i = half_integral_q_bits - 1; i; i--) {
		    move(fast, side, 1);
		    posh(side, size);
		    beta(fast, size);
		    data--;
		    text -= 2;
		    *text = *data;
		}

		if (1) {
		    if (select < 0) {
		    } else {
			if (select) {
			    *fare = sect;
			} else {
			    status = EVER_MATCH;
			}
		    }
		}
#else
		int select;

		select = bqfset(bqfset)->link_f.fare(aime, slip);

		*((integral_q *) sect) = Lx55555555;

		*((integral_q *) down) = Lx55555555;

		for (i = 0; i < half_integral_q_bits - 1; i++) {
		    move((char *) sect + (2 + (i << 1)) * size,
			 (char *) down + (1 + half_integral_q_bits + i) * size,
			 1);
		    ZD(sect, size)[1 + (i << 1)] =
			ZD(down, size)[half_integral_q_bits - 1 + 1 + i];
		}

		ZD(sect, size)[integral_q_last] =
		    ZD(down, size)[integral_q_last];

		ZD(down, size)[integral_q_last] =
		    ZD(down, size)[half_integral_q_bits - 1];

		for (i = half_integral_q_bits - 2; ~i; i--) {
		    move((char *) down + (2 + (i << 1)) * size,
			 (char *) down + (i + 1) * size, 1);
		    ZD(down, size)[1 + (i << 1)] = ZD(down, size)[i];
		}

		if (1) {
		    if (select < 0) {
		    } else {
			if (select) {
			    *fare = sect;
			} else {
			    status = EVER_MATCH;
			}
		    }
		}
#endif
	    } else {
		void *data, *text;

		*((integral_q *) sect) = Lx55555555 | 2;

		*((integral_q *) down) = Lx55555555;

		data = (char *) down + (integral_q_last) * size;

		text = (char *) sect + (integral_q_bits - 2) * size;

		if (side < half_integral_q_bits - 1) {
		    i = half_integral_q_bits - 1;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }

		    move((char *) text + size, data, 1);

		    data = (char *) data - (size << 1);

		    text = (char *) down + (integral_q_bits - 2) * size;

		    i = half_integral_q_bits - 2 - side;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }

		    *edit = text;

		    text = (char *) text - (size << 1);

		    i = side;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }
		} else {
		    if (side ^ (half_integral_q_bits - 1)) {
			i = integral_q_last - side;
			for (; i; i--) {
			    move(text, data, 1);
			    data = (char *) data - size;
			    text = (char *) text - (size << 1);
			}

			if (side ^ half_integral_q_bits) {
			    *edit = text;

			    text = (char *) text - (size << 1);

			    i = side - half_integral_q_bits - 1;
			    for (; i; i--) {
				move(text, data, 1);
				data = (char *) data - size;
				text = (char *) text - (size << 1);
			    }

			    move((char *) text + size, data, 1);

			    data = (char *) data - size;
			} else {
			    *edit = (char *) text + size;
			}
		    } else {
			i = half_integral_q_bits - 1;
			for (; i; i--) {
			    move(text, data, 1);
			    data = (char *) data - size;
			    text = (char *) text - (size << 1);
			}

			move((char *) text + size, data, 1);
		    }

		    data = (char *) data - size;

		    text = (char *) down + (integral_q_bits - 2) * size;

		    i = half_integral_q_bits - 1;
		    for (; i; i--) {
			move(text, data, 1);
			data = (char *) data - size;
			text = (char *) text - (size << 1);
		    }
		}
	    }
	}
    } while (0);

    return status;
}
