/*
 * bqfx.f.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfx-defs.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <mask.0.h>
#include <trans.h>

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
x1f4_fast_bqfset(void *bqfset, unsigned flags,
		 struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    unsigned size;
    void *text;

    if (flags & TRANS_MASK) {
	struct trans_type *trans_data;

	trans_data = screen_data->trans_data;

	link = trans_data->link;
	text = trans_data->data;
    } else {
	link = _libx1f4l2_link_data;
	text = (void *) 0;
    }

    if (flags & SIZE_FRAME) {
	size = screen_data->size;
    } else {
	size = SIZEOF_integral_q;
    }

    status = link
	(text, &text, integral_q_bits_and_half * (size + SIZEOF_integral_q));
    if (status) {
	status = LINK_ERROR;
    } else {
	bqfset(bqfset)->link_a.fpnews.node = text;

	bqfset(bqfset)->link_a.fpnews.link_v.rate = 0;

	bqfset(bqfset)->link_a.fpnews.link_v.size = size;

	*((integral_q *) text) = 0;

	bqfset(bqfset)->link_f.fare = screen_data->fare;
	bqfset(bqfset)->link_f.look = screen_data->look;
	bqfset(bqfset)->link_f.move = screen_data->move;
	bqfset(bqfset)->link_f.pick = screen_data->pick;

	if (flags & TRANS_MASK) {
	    struct trans_type *trans_data;

	    trans_data = screen_data->trans_data;

	    bqfset(bqfset)->link_m.data = trans_data->data;
	    bqfset(bqfset)->link_m.free = trans_data->free;
	    bqfset(bqfset)->link_m.link = trans_data->link;
	    bqfset(bqfset)->link_m.mode = trans_data->mode;
	} else {
	    bqfset(bqfset)->link_m.free = _libx1f4l2_free_data;
	    bqfset(bqfset)->link_m.link = _libx1f4l2_link_data;
	    bqfset(bqfset)->link_m.mode = _libx1f4l2_mode_data;
	}
    }

    return status;
}
