/*
 * bqfx.d.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int miss(void *, unsigned, unsigned, void *, int (*) (void *, void *));

static int
miss(void *node, unsigned rate, unsigned size, void *data,
     int (*free) (void *, void *))
{
    int status = 0;
    integral_q news;
    void **text;

    news = *(integral_q *) node;

    text = (void **) ((char *) node + size * integral_q_bits);

    rate--;

    while (news) {
	if (news & 2) {
	    node = *text;
	    if (rate) {
		status = miss(node, rate, size, data, free);
		if (status) {
		    break;
		}
	    }
	    status = free(data, node);
	    if (status) {
		status = FREE_ERROR;
		if (1) {
		    break;
		}
	    }
	}

	text++;

	{
	    node = *text;
	    if (rate) {
		status = miss(node, rate, size, data, free);
		if (status) {
		    break;
		}
	    }
	    status = free(data, node);
	    if (status) {
		status = FREE_ERROR;
		if (1) {
		    break;
		}
	    }
	}

	text++;

	news >>= 2;
    }

    return status;
}


int
_libx1f4l2_ceil_bqfset(void *bqfset)
{
    int status;
    unsigned rate;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
    if (rate) {
	int (*free) (void *, void *);
	unsigned call, size;
	void *data, **text;

	free = bqfset(bqfset)->link_m.free;

	data = bqfset(bqfset)->link_m.data;

	text = (void *) bqfset(bqfset)->link_a.fpnews.node;

	size = bqfset(bqfset)->link_a.fpnews.link_v.size;

	call = *(integral_q *) text + 1;

	text = (void **) ((char *) text + size * integral_q_bits_and_half)
	    + call;

	status = 0;

	rate--;

	while (call) {
	    void *node;

	    --text;
	    node = *text;
	    if (rate) {
		status = miss(node, rate, size, data, free);
		if (status) {
		    break;
		}
	    }
	    status = free(data, node);
	    if (status) {
		status = FREE_ERROR;
		if (1) {
		    break;
		}
	    }

	    call--;
	}
    } else {
	status = 0;
    }

    return status;
}
