/*
 * bqfx.b.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define posh(___s, ___n) \
    (___s) = (char *) (___s) - (___n)

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

static int line(void *, unsigned, void *, int (*) (void *, void *));
static int mind(void *, unsigned, void *, int (*) (void *, void *));
static int pick(void *, unsigned, unsigned, void *, int (*) (void *, void *));
static int slip(void *, unsigned, unsigned, void *, int (*) (void *, void *));

static int
line(void *node, unsigned size, void *back, int (*call) (void *, void *))
{
    int delete;
    unsigned note;

    note = *(integral_q *) node;
    if (note) {
	node = rule(node, size, note);
	while (1) {
	    delete = call(back, node);
	    if (delete) {
		break;
	    } else {
		note--;
		if (note) {
		    posh(node, size);
		} else {
		    break;
		}
	    }
	}
    } else {
	delete = 0;
    }

    return delete;
}


static int
mind(void *node, unsigned size, void *back, int (*call) (void *, void *))
{
    int delete = 0;
    integral_q lead, news;

    news = *(integral_q *) node;
    lead = news;
    news &= ~3;

    node = rule(node, size, integral_q_last);

    while (news) {
	if (news & Q(1) << integral_q_last) {
	    delete = call(back, node);
	    if (delete) {
		break;
	    }
	}

	posh(node, size);

	news <<= 2;

	{
	    delete = call(back, node);
	    if (delete) {
		break;
	    }
	}

	posh(node, size);
    }

    if (delete) {
    } else {
	if (lead & Q(1) << 1) {
	    delete = call(back, node);
	}
    }

    return delete;
}


static int
pick(void *node, unsigned rate, unsigned size, void *back,
     int (*call) (void *, void *))
{
    int delete = 0;
    integral_q lead, news;
    void **text;

    news = *(integral_q *) node;
    lead = news;
    news &= ~3;

    text = (void **) ((char *) node + size * integral_q_bits);
    text += integral_q_last;

    rate--;

    node = rule(node, size, integral_q_last);

    if (rate) {
	while (news) {
	    delete = pick(*text, rate, size, back, call);
	    if (delete) {
		break;
	    }

	    text--;

	    if (news & Q(1) << integral_q_last) {
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    delete = pick(*text, rate, size, back, call);
		    if (delete) {
			break;
		    }
		}
	    }

	    posh(node, size);

	    news <<= 2;

	    {
		delete = call(back, node);
		if (delete) {
		    break;
		}
	    }

	    text--;

	    posh(node, size);
	}

	if (delete) {
	} else {
	    delete = pick(*text, rate, size, back, call);
	    if (delete) {
	    } else {
		if (lead & Q(1) << 1) {
		    delete = call(back, node);
		    if (delete) {
		    } else {
			text--;
			delete = pick(*text, rate, size, back, call);
		    }
		}
	    }
	}
    } else {
	while (news) {
	    delete = mind(*text, size, back, call);
	    if (delete) {
		break;
	    }

	    text--;

	    if (news & Q(1) << integral_q_last) {
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    delete = mind(*text, size, back, call);
		    if (delete) {
			break;
		    }
		}
	    }

	    posh(node, size);

	    news <<= 2;

	    {
		delete = call(back, node);
		if (delete) {
		    break;
		}
	    }

	    text--;

	    posh(node, size);
	}

	if (delete) {
	} else {
	    delete = mind(*text, size, back, call);
	    if (delete) {
	    } else {
		if (lead & Q(1) << 1) {
		    delete = call(back, node);
		    if (delete) {
		    } else {
			text--;
			delete = mind(*text, size, back, call);
		    }
		}
	    }
	}
    }

    return delete;
}


static int
slip(void *node, unsigned rate, unsigned size, void *back,
     int (*call) (void *, void *))
{
    int delete;
    unsigned note;
    void **text;

    note = *(integral_q *) node;

    text = (void **) ((char *) node + size * integral_q_bits_and_half);

    rate--;

    if (rate) {
	text += note;

	delete = pick(*text, rate, size, back, call);
	if (delete) {
	} else {
	    node = rule(node, size, note);

	    do {
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    text--;
		    delete = pick(*text, rate, size, back, call);
		    if (delete) {
			break;
		    } else {
			posh(node, size);
		    }
		}

		note--;
	    } while (note);
	}
    } else {
	text += note;

	delete = mind(*text, size, back, call);
	if (delete) {
	} else {
	    node = rule(node, size, note);

	    do {
		delete = call(back, node);
		if (delete) {
		    break;
		} else {
		    text--;
		    delete = mind(*text, size, back, call);
		    if (delete) {
			break;
		    } else {
			posh(node, size);
		    }
		}

		note--;
	    } while (note);
	}
    }

    return delete;
}


int
x1f4_draw_bqfset(void *bqfset, void *back, int (*call) (void *, void *))
{
    int delete;
    unsigned rate;

    rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;
    if (rate) {
	delete = slip
	    (bqfset(bqfset)->link_a.fpnews.node, rate,
	     bqfset(bqfset)->link_a.fpnews.link_v.size, back, call);
    } else {
	delete = line
	    (bqfset(bqfset)->link_a.fpnews.node,
	     bqfset(bqfset)->link_a.fpnews.link_v.size, back, call);
    }

    return delete;
}
