/*
 * bqfx.a.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-names.h>
#include <bqfx-types.h>

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
x1f4_high_bqfset(void *bqfset)
{
    int status;

    status = _libx1f4l2_ceil_bqfset(bqfset);
    if (status) {
    } else {
	if (bqfset(bqfset)->link_a.fpnews.link_v.rate) {
	    void *data;

	    data = bqfset(bqfset)->link_a.fpnews.node;

	    status = bqfset(bqfset)->link_m.mode
		(bqfset(bqfset)->link_m.data, &data,
		 integral_q_bits_and_half
		 * (bqfset(bqfset)->link_a.fpnews.link_v.size
		    + SIZEOF_integral_q));
	    if (status) {
		status = MODE_ERROR;
	    } else {
		bqfset(bqfset)->link_a.fpnews.link_v.rate = 0;

		*((integral_q *) data) = 0;

		if (1) {
		    bqfset(bqfset)->link_a.fpnews.node = data;
		}
	    }
	} else {
	    integral_q *data;

	    data = bqfset(bqfset)->link_a.fpnews.node;

	    *data = 0;
	}
    }

    return status;
}
