/*
 * bqfx.7.c
 * Copyright (C) 2009-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfx-names.h>
#include <bqfx-types.h>

#define rule(___s, ___n, ___t) \
    ((char *) (___s) + (___n) * (___t))

#undef Q
#define Q(e)				((integral_q) (e))

#define bqfset(bqfset)			((struct bqfset_type *) (bqfset))

int
x1f4_find_bqfset(void *bqfset, void *aime, void **edit)
{
    int status;
    unsigned copy, size;
    void *node;

    node = bqfset(bqfset)->link_a.fpnews.node;

    size = bqfset(bqfset)->link_a.fpnews.link_v.size;

    status = bqfset(bqfset)->link_f.look(aime, node, &copy);
    if (status) {
	*edit = rule(node, size, copy);
    } else {
	unsigned rate;

	rate = bqfset(bqfset)->link_a.fpnews.link_v.rate;

	if (rate) {
	    int (*pick) (void *, void *, unsigned *);

	    pick = bqfset(bqfset)->link_f.pick;

	    node = MD(node, size)[copy];
	    while (1) {
		status = pick(aime, node, &copy);
		if (status) {
		    if (copy & 1) {
			if (*(integral_q *) node & Q(1) << copy) {
			} else {
			    copy--;
			}
		    }

		    *edit = rule(node, size, copy);

		    break;
		} else {
		    rate--;
		    if (rate) {
			node = ZD(node, size)[copy];
		    } else {
			break;
		    }
		}
	    }
	}
    }

    return status;
}
