/*
 * bqfx.0.c
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfx-defs.h>
#include <bqfx-inter.h>
#include <bqfx-names.h>
#include <bqfx-types.h>
#include <mask.0.h>
#include <trans.h>

int
x1f4_init_bqfset(void **bqfset, unsigned flags,
		 struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *text;

    if (flags & TRANS_MASK) {
	struct trans_type *trans_data;

	trans_data = screen_data->trans_data;

	link = trans_data->link;
	text = trans_data->data;
    } else {
	link = _libx1f4l2_link_data;
	text = (void *) 0;
    }

    do {
	if (flags & SIZE_FRAME) {
	    if (screen_data->size < SIZEOF_integral_q) {
		status = TEXT_ERROR;
		if (1) {
		    break;
		}
	    }
	}

	status = link(text, &text, sizeof(struct bqfset_type));
	if (status) {
	    status = LINK_ERROR;
	}
    } while (0);
    if (status) {
    } else {
	struct bqfset_type *bqfset_data;

	bqfset_data = text;

	status = _libx1f4l2_fast_bqfset(bqfset_data, flags, screen_data);

	if (status) {
	    int (*free) (void *, void *);

	    if (flags & TRANS_MASK) {
		struct trans_type *trans_data;

		trans_data = screen_data->trans_data;

		free = trans_data->free;
		text = trans_data->data;
	    } else {
		free = _libx1f4l2_free_data;
	    }

	    free(text, bqfset_data);
	} else {
	    *bqfset = text;
	}
    }

    return status;
}
