/*
 * bqfx-types.h
 * Copyright (C) 2008-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#ifndef __LIBx1f4_bqfx_types_H__
#define __LIBx1f4_bqfx_types_H__

#include <config.h>

#include <trans.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_VOID_P == SIZEOF_LONG
# define SIZEOF_integral_q		SIZEOF_LONG
#else
# define SIZEOF_integral_q		SIZEOF_INT
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_integral_q == 4
# define integral_q_rate		5
#elif SIZEOF_integral_q == 8
# define integral_q_rate		6
#else
# error Alien pointer size
#endif				/* SIZEOF_integral_q == 4 */

#define half_integral_q_bits		(SIZEOF_integral_q << 2)

#define integral_q_bits			(SIZEOF_integral_q << 3)

#define integral_q_last			(integral_q_bits - 1)

#define integral_q_mask			~((integral_q) 0)

#define MD(___n, ___s) \
    ((void **) ((char *) (___n) + (___s) * integral_q_bits_and_half))

#define ZD(___n, ___s) \
    ((void **) ((char *) (___n) + (___s) * integral_q_bits))

#undef ZD

#define ZD(___n, ___s) \
    ((void **) ((char *) (___n) + ((___s) << integral_q_rate)))

#define HD(___n, ___s, ___t) \
    ((void *) (((char *) (___n) + (___s) * (___t))))

#define integral_q_bits_and_half \
    (half_integral_q_bits + integral_q_bits)

typedef struct fpnews_type {
    void *node;
    struct {
	unsigned rate, size;
    } link_v;
} fpnews_type;

typedef struct screen_type {
    int (*fare) (void *, void *), (*look) (void *, void *, unsigned *),
	(*move) (void *, void *, unsigned),
	(*pick) (void *, void *, unsigned *);
    unsigned size;
    struct trans_type *trans_data;
} screen_type;

typedef struct bqfset_type {
    struct {
	struct fpnews_type fpnews;
    } link_a;
    struct {
	int (*fare) (void *, void *), (*look) (void *, void *, unsigned *),
	    (*move) (void *, void *, unsigned),
	    (*pick) (void *, void *, unsigned *);
    } link_f;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
} bqfset_type;

#endif				/* __LIBx1f4_bqfx_types_H__ */
