/*
 * bqfset.h
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_BQFSET_H__
#define __LIBx1f4_BQFSET_H__

#include <bqfx-names.h>
#include <errors.h>

/*
 * attribute bit definitions
 */
#define X1f4_BQFSET_SIZE_FRAME		(1u << 0x00)
#define X1f4_BQFSET_TRANS_MASK		(1u << 0x01)

/*
 * error definitions
 */
#define X1f4_BQFSET_DECK_ERROR		LIBx1f4L2_DECK_ERROR
#define X1f4_BQFSET_FREE_ERROR		LIBx1f4L2_FREE_ERROR
#define X1f4_BQFSET_LINK_ERROR		LIBx1f4L2_LINK_ERROR
#define X1f4_BQFSET_MODE_ERROR		LIBx1f4L2_MODE_ERROR
#define X1f4_BQFSET_TEXT_ERROR		LIBx1f4L2_TEXT_ERROR

/*
 * error definitions (continued)
 */
#define X1f4_BQFSET_EVER_MATCH		LIBx1f4L2_EVER_MATCH
#define X1f4_BQFSET_MISS_CLASS		LIBx1f4L2_MISS_CLASS

typedef struct x1f4_bqfset_type {
    int (*fare) (void *, void *), (*look) (void *, void *, unsigned *),
	(*move) (void *, void *, unsigned),
	(*pick) (void *, void *, unsigned *);
    unsigned size;
    void *trans;
} x1f4_bqfset_type;

#if !defined __x1f4_trans_type_defined__
typedef struct x1f4_trans_type {
    int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	(*mode) (void *, void **, unsigned);
    void *context;
} x1f4_trans_type;
#endif				/* !__x1f4_trans_type_defined__ */

#if !defined __x1f4_trans_type_defined__
# define __x1f4_trans_type_defined__
#endif				/* !__x1f4_trans_type_defined__ */

extern int x1f4_case_bqfset(void *);
extern int x1f4_cast_bqfset(void *, void *);
extern int x1f4_cast_bqpset(void *, void *);
extern int x1f4_draw_bqfset(void *, void *, int (*) (void *, void *));
extern int x1f4_ever_bqfset(void *, void **);
extern int x1f4_fast_bqfset(void *, unsigned, struct x1f4_bqfset_type *);
extern int x1f4_fgxd_bqfset(void *, void *, void **);
extern int x1f4_fgzd_bqfset(void *, void *, void *, int (*) (void *, void *));
extern int x1f4_find_bqfset(void *, void *, void **);
extern int x1f4_find_bqpset(void *, void *);
extern int x1f4_fini_bqfset(void **);
extern int x1f4_flat_bqfset(void *);
extern int x1f4_flow_bqpset(void *);
extern int x1f4_fmxd_bqfset(void *, void *, void **);
extern int x1f4_fxxd_bqfset(void *, void *, void **);
extern int x1f4_fxzd_bqfset(void *, void *, void *, int (*) (void *, void *));
extern int x1f4_high_bqfset(void *);
extern int x1f4_init_bqfset(void **, unsigned, struct x1f4_bqfset_type *);
extern int x1f4_lead_bqfset(void *, void **);
extern int x1f4_lime_bqfset(void *, void *, int (*) (void *, void *));
extern int x1f4_llxd_bqfset(void *, void *, void **);
extern int x1f4_llzd_bqfset(void *, void *, void *, int (*) (void *, void *));
extern int x1f4_lmxd_bqfset(void *, void *, void **);
extern int x1f4_lxxd_bqfset(void *, void *, void **);
extern int x1f4_lxzd_bqfset(void *, void *, void *, int (*) (void *, void *));
extern int x1f4_post_bqfset(void *, void *, void **);
extern int x1f4_post_bqpset(void *, void *);

#endif				/* __LIBx1f4_BQFSET_H__ */
