/*
 * a12nd.e.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#if !defined HAVE_LIBx1f4i0
# include <cardinal.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <exerrors.h>
#if !defined HAVE_LIBx1f4i0
# include <lintegral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */

#define shuffle(shuffle) \
    ((struct a1_shuffle_type *) (shuffle))

int
_x1f4_a1_stat_deck(void *shuffle, unsigned size, long mode)
{
    int status;

    if (size) {
	status = _x1f4_a1_stat_time(shuffle, size, mode);
    } else {
	status = _x1f4_a1_stat_null(shuffle);
    }

    return status;
}


int
_x1f4_a1_stat_free(void *shuffle)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push(data, "cannot free memory", 18);
	    if (status) {
		break;
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CRITICAL;
}


int
_x1f4_a1_stat_link(void *shuffle)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push(data, "cannot allocate memory", 22);
	    if (status) {
		break;
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CANNOT_CONTINUE;
}


int
_x1f4_a1_stat_miss(void *shuffle)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push(data, "unset function pointer", 22);
	    if (status) {
		break;
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


#if 0
int
_x1f4_a1_stat_mode(void *shuffle)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push(data, "cannot reallocate memory", 24);
	    if (status) {
		break;
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CANNOT_CONTINUE;
}
#endif				/* 0 */


int
_x1f4_a1_stat_null(void *shuffle)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push(data, "function takes no arguments", 27);
	    if (status) {
		break;
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


#if 0
int
_x1f4_a1_stat_post(void *shuffle)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push
		(data, "improper reference argument positional access", 45);
	    if (status) {
		break;
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
#endif				/* 0 */


int
_x1f4_a1_stat_time(void *shuffle, unsigned size, long mode)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	void *data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push(data, "out of range (-", 15);
	    if (status) {
		break;
	    } else {
		status = x1f4_vprint_dcardinal(data, push, size);
		if (status) {
		    break;
		} else {
		    status = push(data, " .. ", 4);
		    if (status) {
			break;
		    } else {
			status = x1f4_vprint_dcardinal(data, push, size - 1);
			if (status) {
			    break;
			} else {
			    status = push(data, ") argument index (", 18);
			    if (status) {
				break;
			    } else {
				status = x1f4_vprint_dlintegral
				    (data, push, mode);
				if (status) {
				    break;
				} else {
				    status = push(data, ")", 1);
				    if (status) {
					break;
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}


int
_x1f4_a1_stat_type(void *shuffle, int target, int source)
{
    do {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned), status;
	const struct x1f4_eelookup_type *eelookup_data;
	void *data;

	eelookup_data = shuffle(shuffle)->y.eelookup_data;

	data = shuffle(shuffle)->x.data;

	line = shuffle(shuffle)->x.line;
	if (line) {
	    status = line(data);
	    if (status) {
		break;
	    }
	}

	push = shuffle(shuffle)->x.push;
	if (push) {
	    status = push(data, "cannot set ", 11);
	    if (status) {
		break;
	    } else {
		status = x1f4_dump_type(data, push, target, eelookup_data);
		if (status) {
		    break;
		} else {
		    status = push(data, " from ", 6);
		    if (status) {
			break;
		    } else {
			status = x1f4_dump_type
			    (data, push, source, eelookup_data);
			if (status) {
			    break;
			}
		    }
		}
	    }
	}

	post = shuffle(shuffle)->x.post;
	if (post) {
	    status = post(data);
	    if (status) {
		break;
	    }
	}
    } while (0);

    return X1f4_EX_CAN_CONTINUE;
}
