/*
 * a12nd.c.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <e4.h>
#include <exerrors.h>
#include <lxcast.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

static int lead_cast(struct a1_link_type *, int, struct a1_shuffle_type *);
static int lead_node(struct a1_link_type *, int, struct a1_shuffle_type *);
static int lead_text(struct a1_link_type *, struct a1_shuffle_type *);

static int
lead_cast(struct a1_link_type *link_data, int type,
	  struct a1_shuffle_type *shuffle_data)
{
    int status;

    if (type < X1f4_E4_LAST) {
	if (type == X1f4_E4_TEXT) {
	    status = lead_text(link_data, shuffle_data);
	} else {
	    status = 0;
	}
    } else {
	if (X1f4_E4_CALL < type) {
	    status = 0;
	} else {
	    status = lead_node(link_data, type, shuffle_data);
	}
    }

    return status;
}


static int
lead_node(struct a1_link_type *link_data, int type,
	  struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    int status;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = shuffle_data->u.datatype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == type) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.sidetype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == type) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	if (datatype_data->lead) {
	    status = datatype_data->lead
		(datatype_data->context, (void *) &link_data->slip.data);
	    if (status) {
		status = X1f4_EX_CANNOT_CONTINUE;
	    } else {
	    }
	} else {
	    status = 0;
	}
    } else {
	status = 0;
    }

    return status;
}


static int
lead_text(a1_link_type *link_data, struct a1_shuffle_type *shuffle_data)
{
    int status;
    unsigned size;
    void *data, *text;

    data = I_TEXT(&link_data->slip.data);

    size = strlen(data) + 1;
    status = shuffle_data->m.link(shuffle_data->m.data, &text, size);
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	memcpy(text, data, size);
	l_TEXT(text, &link_data->slip.data);
    }

    return status;
}


int
_x1f4_a1_lead_slip(struct a1_shuffle_type *shuffle_data, void **input,
		   struct a1_link_type *link_data,
		   const struct x1f4_function_type *function_data,
		   const struct x1f4_function_type *function_slip, void *aime,
		   void *post)
{
    const int *args;
    int object;
    const int *slip;
    int status = 0;
    unsigned count, flags, i;
    void **lead;

    status = 0;

    lead = input;

    count = function_slip->count;

    flags = function_slip->flags;

    object = shuffle_data->r.type;

    slip = function_slip->args;
    args = function_data->args;

    for (i = count; i; i--) {
	if (*slip == X1f4_E4_SLIP) {
	    int type;

	    type = *args;
	    if (0) {
	    } else {
		do {
		    if (flags & X1f4_E4_POST_TYPE) {
			if (slip[count] & X1f4_E4_POST_XSET) {
			    break;
			}
		    }

		    copy_miss(&link_data->slip.data, type, *lead);

		    status = lead_cast(link_data, type, shuffle_data);
		} while (0);
		if (status) {
		    break;
		}
	    }
	} else {
	}

	args++;

	lead++;

	slip++;

	link_data++;
    }

    if (status) {
	count -= i;
	_x1f4_a1_slip_slip
	    (shuffle_data, link_data - count, count, function_data,
	     function_slip);
    }

    return status;
}
