/*
 * a12nd.b.c
 * Copyright (C) 2008, 2009, 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-types.h>
#include <c1i.h>

int
_x1f4_a1_miss_fast(struct a1_shuffle_type *shuffle_data,
		   struct a1_fast_type *fast_head)
{
    int status = 0;

    while (fast_head) {
	int excess;
	struct a1_fast_type *fast_data;

	fast_data = fast_head;
	fast_head = fast_data->fast_data;

	excess = shuffle_data->m.free(shuffle_data->m.data, fast_data);
	if (excess) {
	    if (status) {
	    } else {
		status = _x1f4_a1_stat_free(shuffle_data);
	    }
	}
    }

    return status;
}


int
_x1f4_a1_miss_port(struct a1_trans19_type *trans19_data)
{
    struct x1f4_c1node_type *c1node_data;

    c1node_data = trans19_data->e.slip;
    if (c1node_data->data.data) {
    } else {
	c1node_data++;
    }

    return x1f4_tail_expression(c1node_data->data.data, &trans19_data->e.port);
}
