/*
 * a1.t.c
 * Copyright (C) 2007-2011, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <c1.h>

int
_x1f4_a1_lead_lock(void **context, void **call, struct a1_link_type *link_data)
{
    void *mirror;

    mirror = context[3];
    if (mirror) {
	unsigned lock;
	void *text;

	text = *call;
	if (x1f4_lock_program
	    (((struct a1_node_type *) context[2])->aime, text, &lock)) {
	    link_data->slip.data.wind = (char *) mirror + lock;
	} else {
	    link_data->slip.data.wind = text;
	}
    } else {
	link_data->slip.data.wind = *call;
    }

    return 0;
}
