/*
 * a1.s.c
 * Copyright (C) 2008, 2009, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-defs.h>
#include <a1-types.h>

int
x1f4_near_shuffle(struct a1_trans19_type **trans19,
		  struct a1_shuffle_type *shuffle_data)
{
    int status;
    void *data;

    status = shuffle_data->m.link
	(shuffle_data->m.data, &data, sizeof(struct a1_trans19_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct a1_trans19_type *trans19_data;

	trans19_data = data;

	*trans19 = trans19_data;

	trans19_data->e.deck = NULL;
	trans19_data->e.lock = NULL;
	trans19_data->e.port = NULL;

	trans19_data->f.shuffle_data = shuffle_data;
    }

    return status;
}
