/*
 * a1.r.c
 * Copyright (C) 2009-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-defs.h>
#include <a1-types.h>

int
x1f4_pipe_shuffle(struct a1_shuffle_type *shuffle_data,
		  struct a1_pass_type *pass_data)
{
    int status;
    void *data;

    status = shuffle_data->m.link
	(shuffle_data->m.data, &data, sizeof(struct a1_pipe_type));
    if (status) {
	status = ALLOC_ERROR;
    } else {
	struct a1_pipe_type *back_pipe, *pipe_data;

	pipe_data = data;

	back_pipe = shuffle_data->back_pipe;

	shuffle_data->back_pipe = pipe_data;

	pipe_data->pass = *pass_data;

	pipe_data->pipe_long = NULL;

	if (back_pipe) {
	    back_pipe->pipe_long = pipe_data;
	    pipe_data->back_pipe = back_pipe;
	} else {
	    pipe_data->back_pipe = NULL;

	    shuffle_data->pipe_long = pipe_data;
	}
    }

    return status;
}
