/*
 * a1.i.c
 * Copyright (C) 2007, 2008, 2009, 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <dt.h>
#include <e4.h>
#include <exerrors.h>

int
_x1f4_a1_slip_node(void **context, struct a1_link_type *link_data)
{
    int status;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = link_data->datatext.type;

    status = datatype_data->slip
	(datatype_data->context, (void *) &link_data->slip.data);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    }

    return status;
}
