/*
 * a1.h
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_a1_H__
#define __LIBx1f4_a1_H__

#include <e4.h>

typedef struct x1f4_a1_type {
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } function_set;
    struct {
	const void *context;
    } variable_set;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_operator_type **);
	const void *context;
    } implicit_set;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_linetext_type **);
	const void *context;
    } composer_set;
    struct {
	struct x1f4_a1record_type *a1record_data;
    } bcollect_set;
    struct {
	void *fine;
    } transfer_set;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *context;
    } resource_set;
    struct {
	int (*free) (void *, void *);
	void *data;
    } flattext_set;
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *context;
    } autolead_set;
    struct {
	void *context;
	const void *miss;
    } datatype_set;
    struct {
	const void *miss;
    } sidetype_set;
    const struct x1f4_operator_type *const *operator1s, *const *operator2s;
    void *context;
} x1f4_a1_type;

typedef struct x1f4_a1screen_type {
    int (*back) (void *, const struct x1f4_function_type *),
	(*fast) (void *, const struct x1f4_function_type *),
	(*lose) (void *, const struct x1f4_function_type *);
    void *data;
} x1f4_a1screen_type;

extern int x1f4_init_shuffle
    (void **, const char *, unsigned, const struct x1f4_a1_type *);
extern int x1f4_pipe_shuffle
    (void *, struct x1f4_a1screen_type *);

#endif				/* __LIBx1f4_a1_H__ */
