/*
 * a1.g.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <dt.h>
#include <e4.h>
#include <exerrors.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

int
_x1f4_a1_lead_node(void **context, void **call, struct a1_link_type *link_data)
{
    int status;
    const struct x1f4_datatype_type *datatype_data;
    void *text;

    datatype_data = link_data->datatext.type;

    text = *call;
    call = (void *) &link_data->slip.data;
    *call = I_TEXT(text);

    status = datatype_data->lead(datatype_data->context, call);
    if (status) {
	status = X1f4_EX_CANNOT_CONTINUE;
    }

    return status;
}
