/*
 * a1.e.c
 * Copyright (C) 2007-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-defs.h>
#include <a1-errors.h>
#include <a1-types.h>

int
_x1f4_a1_090818_error_0(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = FAILTYPE;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090818_error_1(struct a1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = MISSTYPE;
	back_data->line = line;
	if (1) {
	    back_data->data.misstype.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090818_error_2(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = FAILNAME;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090818_error_3(struct a1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = MISSNAME;
	back_data->line = line;
	if (1) {
	    back_data->data.missname.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090818_error_4(struct a1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = RESERVED;
	back_data->line = line;
	if (1) {
	    back_data->data.reserved.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090818_error_5(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = OPENLIST;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090818_error_6(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = LOSELIST;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090818_error_7(struct a1_back_type *back_data)
{
    if (back_data) {
	back_data->code = INTERNAL;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090819_error_0(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = FAILLIST;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090819_error_1(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = FAILPOST;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090819_error_2(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = VOIDPOST;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090819_error_3(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = FAILLINK;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090820_error_0(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = C_SYNTAX;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090821_error_0(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = OPENTEXT;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090822_error_0(struct a1_back_type *back_data, const char *line,
			int type)
{
    if (back_data) {
	back_data->code = MAINTYPE;
	back_data->line = line;
	if (1) {
	    back_data->data.maintype.type = type;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090822_error_1(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = MAINLIST;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090822_error_3(struct a1_back_type *back_data)
{
    if (back_data) {
	back_data->code = MISSMAIN;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090822_error_4(struct a1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = MISSLINK;
	back_data->line = line;
	if (1) {
	    back_data->data.misslink.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090822_error_5(struct a1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = LESSLINK;
	back_data->line = line;
	if (1) {
	    back_data->data.lesslink.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_090828_error_0(struct a1_back_type *back_data, const char *line)
{
    if (back_data) {
	back_data->code = LOSETEXT;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_091210_error_0(struct a1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = FLATTYPE;
	back_data->line = line;
	if (1) {
	    back_data->data.flattype.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_101114_error_0(struct a1_back_type *back_data, const char *line,
			struct a1_node_type *node_data)
{
    if (back_data) {
	while (node_data->aime) {
	    node_data = node_data->node_data;
	}

	back_data->code = XDEFINED;
	back_data->line = line + node_data->offset;
	if (1) {
	    back_data->data.xdefined.size =
		node_data->linetext.function.length;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_101115_error_0(struct a1_back_type *back_data, const char *line,
			unsigned call, struct a1_node_type *node_data)
{
    if (back_data) {
	back_data->code = MISSLINE;
	back_data->line = line + call;
	if (1) {
	    back_data->data.missline.code = DEFINITE;
	    back_data->data.missline.fast = line + node_data->offset;
	    back_data->data.missline.size =
		node_data->linetext.function.length;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_101115_error_1(struct a1_back_type *back_data, const char *line,
			const char *pick, unsigned call,
			struct a1_node_type *node_data)
{
    if (back_data) {
	back_data->code = POSTFEAT;
	back_data->line = line;
	if (1) {
	    back_data->data.postfeat.fast = pick + call;
	    back_data->data.postfeat.size =
		node_data->linetext.function.length;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_101116_error_0(struct a1_back_type *back_data, const char *line,
			unsigned call, struct a1_node_type *node_data,
			int slip, int type)
{
    _x1f4_a1_101115_error_0(back_data, line, call, node_data);

    if (back_data) {
	back_data->data.missline.code = SLIPTYPE;
	if (2) {
	    back_data->data.missline.data.sliptype.slip = slip;
	    back_data->data.missline.data.sliptype.type = type;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_101116_error_1(struct a1_back_type *back_data, const char *line,
			unsigned call, struct a1_node_type *node_data,
			unsigned name, int slip, int type)
{
    _x1f4_a1_101115_error_0(back_data, line, call, node_data);

    if (back_data) {
	back_data->data.missline.code = NAMETYPE;
	if (2) {
	    back_data->data.missline.data.nametype.name = name;
	    back_data->data.missline.data.nametype.slip = slip;
	    back_data->data.missline.data.nametype.type = type;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_101116_error_2(struct a1_back_type *back_data, const char *line,
			unsigned call, struct a1_node_type *node_data,
			unsigned name)
{
    _x1f4_a1_101115_error_0(back_data, line, call, node_data);

    if (back_data) {
	back_data->data.missline.code = NAMECALL;
	if (2) {
	    back_data->data.missline.data.namecall.name = name;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_111111_error_0(struct a1_back_type *back_data, const char *line,
			int type)
{
    if (back_data) {
	back_data->code = MISSLEAD;
	back_data->line = line;
	if (1) {
	    back_data->data.misslead.type = type;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_111221_error_0(struct a1_back_type *back_data, const char *line,
			int delete)
{
    if (back_data) {
	back_data->code = HIGHEROF;
	back_data->line = line;
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_130414_error_0(struct a1_back_type *back_data, const char *line,
			unsigned size)
{
    if (back_data) {
	back_data->code = NEARTYPE;
	back_data->line = line;
	if (1) {
	    back_data->data.flattype.size = size;
	}
    }

    return PARSE_ERROR;
}


int
_x1f4_a1_130806_error_0(struct a1_back_type *back_data, const char *line,
			int type)
{
    if (back_data) {
	back_data->code = SIDELINE;
	back_data->line = line;
	if (1) {
	    back_data->data.sideline.type = type;
	}
    }

    return PARSE_ERROR;
}
