/*
 * a1.c.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <e4.h>
#include <lxcast.h>

#define false(e)			0

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_TEXT(i)			(*((X1f4_E4_C_TEXT *) (i)))
#define I_USER(i)			(*((X1f4_E4_C_USER *) (i)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const char *const x1f4_c1_empty_string;

static int lead_node(void *, void *, const struct x1f4_datatype_type *);
static int lead_text(void *, void *, struct a1_shuffle_type *);
static int true_type(const struct x1f4_datatype_type **, int,
		     struct a1_shuffle_type *);

static int
lead_node(void *slip, void *data,
	  const struct x1f4_datatype_type *datatype_data)
{
    int status;

    status = datatype_data->lead(datatype_data->context, data);
    if (status) {
    } else {
	status = datatype_data->slip(datatype_data->context, slip);
	if (status) {
	} else {
	    copy_miss(slip, datatype_data->type, data);
	}
    }

    return status;
}


static int
lead_text(void *slip, void *data, struct a1_shuffle_type *shuffle_data)
{
    int status;
    void *miss, *side;

    miss = I_TEXT(data);
    side = I_TEXT(slip);

    if (side == miss) {
	status = 0;
    } else {
	unsigned size;
	void *text;

	size = strlen(miss) + 1;
	status = shuffle_data->m.link(shuffle_data->m.data, &text, size);
	if (status) {
	    status = _x1f4_a1_stat_link(shuffle_data);
	} else {
	    memcpy(text, miss, size);
	    l_TEXT(text, slip);
	    if (side != x1f4_c1_empty_string) {
		status = shuffle_data->m.free(shuffle_data->m.data, side);
		if (status) {
		    status = _x1f4_a1_stat_free(shuffle_data);
		}
	    }
	}
    }

    return status;
}


static int
true_type(const struct x1f4_datatype_type **datatype, int type,
	  struct a1_shuffle_type *shuffle_data)
{
    const char *name;
    const struct x1f4_datatype_type *datatype_data;

    datatype_data = shuffle_data->u.sidetype_data;
    name = datatype_data->name;
    while (name) {
	if (datatype_data->type == type) {
	    break;
	} else {
	    datatype_data++;
	    name = datatype_data->name;
	}
    }
    if (name) {
    } else {
	datatype_data = shuffle_data->u.datatype_data;
	name = datatype_data->name;
	while (name) {
	    if (datatype_data->type == type) {
		break;
	    } else {
		datatype_data++;
		name = datatype_data->name;
	    }
	}
    }

    if (name) {
	*datatype = datatype_data;
    } else {
	*datatype = NULL;
    }

    return 0;
}


int
_x1f4_a1_beta_call(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;
    int status;
    struct a1_node_type *node_data;
    struct a1_shuffle_type *shuffle_data;
    const struct x1f4_function_type *function_data;
    unsigned count, flags;

    shuffle_data = context;

    node_data = shuffle_data->fail_node;

    function_data = &node_data->linetext.function;

    flags = function_data->flags;

    if (flags & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	function_data = shuffle_data->s.function_data;
	if (1) {
	    flags = function_data->flags;
	}
    }

    count = function_data->count;

    mode = I_MODE(input[0]);
    if (-(X1f4_E4_C_MODE) count - 1 < mode && mode < (X1f4_E4_C_MODE) count) {
	do {
	    const int *args;
	    int type;
	    const struct x1f4_datatype_type *datatype_data;
	    struct x1f4_dxcast_type *object_data;
	    unsigned class;
	    void *slip;

	    class = node_data->linetext.function.count;

	    object_data = I_USER(input[1]);

	    if (mode < 0) {
		mode += count;
	    }

	    args = function_data->args + mode;

	    type = *args;

	    if (type != object_data->type) {
		status = _x1f4_a1_stat_type
		    (shuffle_data, type, object_data->type);
		if (1) {
		    break;
		}
	    }

	    if (mode < class) {
		int true;
		struct a1_link_type *link_data;

		link_data = node_data->link_data;

		link_data += mode;

		true = link_data->variable.type;
		if (true ^ X1f4_E4_SLIP) {
		    datatype_data = link_data->datatext.type;
		} else {
		    true_type(&datatype_data, type, shuffle_data);
		}

		if (false(type == shuffle_data->r.type)) {
		} else {
		    if (flags & X1f4_E4_POST_TYPE) {
			if (args[count] & X1f4_E4_POST_XSET) {
			    slip = link_data->slip.data.wind;
			} else {
			    slip = &link_data->slip.data;
			}
		    } else {
			slip = &link_data->slip.data;
		    }
		}
	    } else {
		const char *name;
		int trap;
		struct x1f4_dxcast_type *object_text;

		status = 0;

		trap = mode - class;

		object_text = shuffle_data->s.lead;
		object_text += trap;

		if (false(type == shuffle_data->r.type)) {
		} else {
		    if (flags & X1f4_E4_POST_TYPE) {
			if (args[count] & X1f4_E4_POST_XSET) {
			    slip = *((void **) (object_text + count - mode)
				     + trap);
			} else {
			    slip = &object_text->data;
			}
		    } else {
			slip = &object_text->data;
		    }
		}

		datatype_data = shuffle_data->u.sidetype_data;
		name = datatype_data->name;
		while (name) {
		    if (datatype_data->type == type) {
			break;
		    } else {
			datatype_data++;
			name = datatype_data->name;
		    }
		}
		if (name) {
		} else {
		    datatype_data = shuffle_data->u.datatype_data;
		    name = datatype_data->name;
		    while (name) {
			if (datatype_data->type == type) {
			    break;
			} else {
			    datatype_data++;
			    name = datatype_data->name;
			}
		    }
		}

		if (name) {
		} else {
		    datatype_data = NULL;
		}
	    }

	    if (datatype_data) {
		if (datatype_data->lead) {
		    status = lead_node
			(slip, &object_data->data, datatype_data);
		    if (1) {
			break;
		    }
		} else {
		}
	    } else {
		if (type == X1f4_E4_TEXT) {
		    status = lead_text
			(slip, &object_data->data, shuffle_data);
		    if (1) {
			break;
		    }
		}
	    }

	    status = 0;

	    copy_miss(slip, type, &object_data->data);
	} while (0);
    } else {
	status = _x1f4_a1_stat_deck(shuffle_data, count, mode);
    }

    return status;
}
