/*
 * a1.b.c
 * Copyright (C) 2008-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <a1-types.h>
#include <c1i.h>
#include <e4.h>

static int peek_aime(void *, const struct x1f4_function_type *);
static int rail_aime(void *, struct x1f4_c1node_type *);

static int
peek_aime(void *none, const struct x1f4_function_type *function_data)
{
    int (*function) (void *, void *, void **);

    function = function_data->function;

    return function == _x1f4_a1_deck_aime || function == _x1f4_a1_link_aime
	|| function == _x1f4_a1_side_aime
	|| function_data->flags & X1f4_E4_WALK_LINK;
}


static int
rail_aime(void *none, struct x1f4_c1node_type *c1node_data)
{
    do {
	int delete;
	void *data;

	data = c1node_data->data.data;
	if (data) {
	} else {
	    data = (c1node_data + 1)->data.data;
	    if (data) {
	    } else {
		break;
	    }
	}

	delete = x1f4_peek_expression(data, NULL, peek_aime);
	if (delete) {
	    c1node_data->state |= X1f4_C1_1st_STATE;
	} else {
	    delete = x1f4_rate_expression(data);
	    if (delete) {
		c1node_data->state |= X1f4_C1_1st_STATE;
	    }
	}
    } while (0);

    return 0;
}


int
x1f4_rail_shuffle(struct a1_shuffle_type *shuffle_data)
{
    int status;
    struct a1_node_type *node_data;

    node_data = shuffle_data->node_data;

    if (node_data) {
	do {
	    status = x1f4_list_program(node_data->aime, NULL, rail_aime);
	    if (status) {
		break;
	    }

	    node_data = node_data->node_data;
	} while (node_data);
    } else {
	status = 0;
    }

    return status;
}
