/*
 * a1.7.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * TODO
 *
 *.extern s1st and s2nd in c1_program_type definition
 *.fix bugs in c1.7.c
 */

/*
 * FEATURES
 *
 *.main can be called - now, that's sort of stupid.  or is it not?
 *.when copying the variable tree the memory manager of the source (tree) is
 * used.  the parsing memory manager should be used instead.
 *.rather stupidly, function parameters list is checked for name conflicts
 * before determining whether a function definition (and not a function
 * declaration) is being parsed.  worse yet, list is checked for conflicts even
 * after a declaration determination is made (a parameter name is missing,
 * hence declaration).
 */

#include <config.h>

#if defined HAVE_LIBx1f4i0
# include <libx1f4i0.h>
#endif				/* HAVE_LIBx1f4i0 */
#include <stddef.h>
#include <string.h>

#include <a1-defs.h>
#include <a1-inter.h>
#include <a1-parse.h>
#include <a1-types.h>
#if !defined HAVE_LIBx1f4i0
# include <akeylook-l.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <c1.h>
#include <ctype.0.h>
#include <dt.h>
#include <e4-m.0.h>
#include <e4.h>
#include <e4fine.h>
#include <e4jack.h>
#include <mxdeck.h>

#define EXTENSION			1
#define REDUCTION			2
#define SIDE_TYPE			3

#define __RECORD_STRAIGHT__		1
#define __SCALAR_STRAIGHT__		2
#define __SIMPLE_STRAIGHT__		3

#define __FUNCTION_RETURN__		__RECORD_STRAIGHT__

#define ____FUNCTION_RETURN__		__FUNCTION_RETURN__

#define M_FREE(mcontext, mdata) \
    (mcontext)->m.free((mcontext)->m.data, (mdata))
#define M_LINK(mcontext, mdata, size) \
    (mcontext)->m.link((mcontext)->m.data, (void *) (mdata), (size))
#define M_MODE(mcontext, mdata, size) \
    (mcontext)->m.mode((mcontext)->m.data, (void *) (mdata), (size))

#define try_line(deck, c1, c2, c3, c4, c5, c6, c7) \
    (try_rate((deck), (c1), (c2), (c3), (c4), (c5), (c6))		      \
     || *(const unsigned char *) ((deck) + 7) != (c7))

#define try_rate(deck, c1, c2, c3, c4, c5, c6) \
    (try_type((deck), (c1), (c2), (c3))					      \
     || *(const unsigned char *) ((deck) + 4) != (c4)			      \
     || *(const unsigned char *) ((deck) + 5) != (c5)			      \
     || *(const unsigned char *) ((deck) + 6) != (c6))

#define try_type(deck, c1, c2, c3) \
    (*(const unsigned char *) ((deck) + 1) != (c1)			      \
     || *(const unsigned char *) ((deck) + 2) != (c2)			      \
     || *(const unsigned char *) ((deck) + 3) != (c3))

#define false(e)			0

#define set_type(a, b, c) \
    x1f4_lock_e4jack((a), (b), (c))

#define fit_type(parser_data, b, c, d) \
    (x1f4_seek_e4jack((parser_data)->datatype_data, (b), (c), (d))	      \
     ? x1f4_seek_e4jack((parser_data)->sidetype_data, (b), (c), (d)) : 0)

#define b_offset(datamiss) \
    ((struct a1_link_type *)						      \
     ((char *) (datamiss) - offsetof(struct a1_link_type, datatext)))

extern const struct x1f4_akeytree_type _x1f4_c1_text_root[];

static int call_3974(struct a1_parser_type *, unsigned,
		     struct a1_link_type **);
static int elk_last(struct a1_parser_type *, struct a1_node_type *);
static int elk_miss(struct a1_parser_type *, struct a1_node_type *);
static int far_side(struct a1_parser_type *, int *, const char **);
static int fit_deck(struct a1_parser_type *);
static int fit_fine(struct a1_parser_type *);
static int fit_list(struct a1_parser_type *, struct a1_link_type *,
		    const char *, unsigned);
static int fix_fine(struct a1_parser_type *, const char *, unsigned,
		    struct a1_link_type *);
static int fix_lane(struct a1_parser_type *, const char *);
static int fix_last(struct a1_parser_type *, struct a1_node_type *);
static int fix_lead(struct a1_parser_type *, const char *, unsigned,
		    struct a1_link_type *);
static int fix_line(struct a1_parser_type *, const char *);
static int fix_list(struct a1_parser_type *, const char *);
static int fix_main(struct a1_parser_type *, const char *, unsigned);
static int fix_miss(struct a1_parser_type *, struct a1_link_type *, int, int,
		    int, const char *, unsigned,
		    const struct x1f4_datatype_type *);
static int fix_name(struct a1_parser_type *, const char **);
static int fix_posh(struct a1_parser_type *, const char *, unsigned);
static int fix_type(struct a1_parser_type *, int *);
static int ink_data(struct a1_parser_type *);
static int ink_fine(struct a1_parser_type *);
static int ink_lane(struct a1_parser_type *);
static int ink_last(struct a1_parser_type *, int *);
static int ink_line(struct a1_parser_type *);
static int ink_list(struct a1_parser_type *);
static int map_data(struct a1_parser_type *);
static int map_miss(struct a1_parser_type *, struct a1_link_type *, unsigned);
static int map_zero(struct a1_parser_type *, const struct a1_context_type *);
static int net_fine(struct a1_parser_type *, int, int,
		    const struct x1f4_datatype_type *);
static int net_last(struct a1_parser_type *, struct a1_node_type *);
static int net_lead(struct a1_parser_type *, int, int,
		    const struct x1f4_datatype_type *);
static int net_list(struct a1_parser_type *, int *, int *);
static int net_miss(struct a1_parser_type *, int *, int *, int *,
		    const char **, unsigned *,
		    const struct x1f4_datatype_type **);
static int net_post(struct a1_parser_type *, int *);
#if __FUNCTION_RETURN__ == __SIMPLE_STRAIGHT__
static int net_type(const char *, unsigned, int *);
#endif				/* __FUNCTION_RETURN__ == __SIMPLE_STRAIG... */
static int new_fine(struct a1_parser_type *, int, struct a1_link_type *,
		    unsigned);
static int new_lead(struct a1_parser_type *, int, struct a1_node_type *,
		    unsigned);
static int new_miss(struct a1_parser_type *, int, const char **, unsigned *,
		    struct a1_link_type *, unsigned);
#if __FUNCTION_RETURN__ == __SCALAR_STRAIGHT__
static int red_type(const char *, unsigned, int *);
#endif				/* __FUNCTION_RETURN__ == __SCALAR_STRAIG... */
static int run_list(struct a1_parser_type *, int *, int *,
		    const struct x1f4_datatype_type **);
static int run_post(struct a1_parser_type *, int *, int *,
		    const struct x1f4_datatype_type **);
static int run_type(struct a1_parser_type *, const char *, unsigned, int *,
		    int *, const struct x1f4_datatype_type **);
static int set_lane(struct a1_parser_type *, int);
static int set_last(struct a1_parser_type *, unsigned);
static int set_line(struct a1_parser_type *, int);
static int set_list(struct a1_parser_type *, int, int,
		    const struct x1f4_datatype_type *);
static int set_miss(struct a1_parser_type *, struct a1_link_type **, unsigned);
static int set_side(struct a1_parser_type *, int);
static int set_slip(struct a1_parser_type *);
static int sub_fine(struct a1_parser_type *, const char *, unsigned,
		    struct a1_link_type *);
static int sub_lead(struct a1_parser_type *, const char *, unsigned,
		    struct a1_link_type *);
static int sub_miss(struct a1_parser_type *, struct a1_link_type *,
		    const char *, unsigned);
static int tie_fine(struct a1_parser_type *, int, struct a1_link_type *,
		    unsigned);
static int tie_lead(struct a1_parser_type *, int, struct a1_node_type *);

static void air_fix(struct a1_parser_type *);
static void air_net(struct a1_parser_type *, struct a1_node_type **);
static void air_set(struct a1_parser_type *);
static void air_way(struct a1_parser_type *);
static void rule_cast(struct a1_parser_type *);
static void way_far(const char **);
static void way_fit(struct a1_parser_type *, struct a1_link_type *);
static void way_fix(struct a1_link_type *, int *, unsigned);
static void way_net(struct a1_link_type *, int *, unsigned);
static void way_new(const char **);
static void way_red(const char **);
static void way_set(struct a1_parser_type *, unsigned *);

static const struct x1f4_datatype_type missed = {
/* *INDENT-OFF* */
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    0,
    0,
    NULL
/* *INDENT-ON* */
};
static const unsigned c_type_1[] = {
/*
 *
 *
 *
 *
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00000000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_4[] = {
/*
 *                   . .     .
 *
 * .
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00002600, 0x00000001, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

static int
call_3974(struct a1_parser_type *parser_data, unsigned count,
	  struct a1_link_type **link)
{
    int status;

    if (count) {
	struct a1_link_type *link_data;

	status = M_LINK
	    (parser_data, &link_data, sizeof(struct a1_link_type) * count);
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    struct a1_link_type *link_slip, *link_text;
	    void *variable_tree;

	    variable_tree = parser_data->variable_tree;

	    link_text = parser_data->link_data;

	    link_slip = link_data;

	    while (1) {
		char *name;
		unsigned length;

		length = link_text->variable.length + 1;

		status = M_LINK(parser_data, &name, length);
		if (status) {
		    status = ALLOC_ERROR;
		    break;
		} else {
		    *link_slip = *link_text;

		    memcpy(name, link_text->variable.name, length);

		    link_slip->variable.name = name;

		    link_slip->datatext.data = &link_slip->variable;

		    if (link_slip->variable.flags & X1f4_E4_REFERENCE) {
		    } else {
			link_slip->datatext.link = &link_slip->slip.data;
		    }

		    length--;
		    if (length) {
			const void **pick;

			x1f4_pick_mxpath(variable_tree, name, length, &pick);
			*pick = &link_slip->datatext;
		    }

		    count--;
		    if (count) {
			void *slip;

			link_slip->datatext.datatext_data =
			    &(link_slip + 1)->datatext;

			link_slip++;

			slip = link_text->datatext.datatext_data;
			if (1) {
			    link_text = b_offset(slip);
			}
		    } else {
			break;
		    }
		}
	    }

	    if (status) {
		while (link_slip != link_data) {
		    link_slip--;
		    M_FREE(parser_data, (void *) link_slip->variable.name);
		}

		M_FREE(parser_data, link_data);
	    } else {
		*link = link_data;

		link_slip->datatext.datatext_data = NULL;

		_x1f4_a1_miss_lane(&parser_data->m, parser_data->link_data);

		parser_data->link_data = NULL;
	    }
	}
    } else {
	status = 0;
	if (1) {
	    *link = NULL;
	}
    }

    return status;
}


static int
elk_last(struct a1_parser_type *parser_data, struct a1_node_type *node_data)
{
    const char *e;
    int c, status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c != 0x3b) {
	if (parser_data->half_expect) {
	    status = _x1f4_a1_090819_error_3
		(parser_data->back_data,
		 parser_data->thirteen + parser_data->offset);
	} else {
	    status = fix_last(parser_data, node_data);
	}
    } else {
	status = 0;

	parser_data->shuffle = e + 1;

	if (1) {
	    void *variable_tree;

	    variable_tree = parser_data->variable_tree;
	    if (variable_tree) {
		parser_data->variable_tree = NULL;
		x1f4_fini_mxdeck(&variable_tree);
	    }
	}
    }

    return status;
}


static int
elk_miss(struct a1_parser_type *parser_data, struct a1_node_type *node_data)
{
    const char *e;
    int c, status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c != 0x3b) {
	status = _x1f4_a1_101115_error_1
	    (parser_data->back_data, e, parser_data->thirteen,
	     parser_data->offset, parser_data->node_data);
    } else {
	status = 0;

	parser_data->shuffle = e + 1;

	if (1) {
	    void *variable_tree;

	    variable_tree = parser_data->variable_tree;
	    if (variable_tree) {
		parser_data->variable_tree = NULL;
		x1f4_fini_mxdeck(&variable_tree);
	    }
	}
    }

    return status;
}


static int
far_side(struct a1_parser_type *parser_data, int *side, const char **shuffle)
{
    int delete = 0;

    if (parser_data->flags & CASTTYPE_LINK) {
	const char *e;
	int miss = EXTENSION;

	e = *shuffle;
	if (*e == 0x26) {
	    e++;
	    miss = REDUCTION;
	    parser_data->slip(&e);
	}
	if (*e == 0x2e) {
	    e++;
	    if (*e == 0x2e) {
		e++;
		if (*e == 0x2e) {
		    e++;
		    parser_data->slip(&e);
		    if (*e == 0x29) {
			*shuffle = e;
			delete = 1;
			*side = miss;
		    }
		}
	    }
	}
    }

    return delete;
}


static int
fit_deck(struct a1_parser_type *parser_data)
{
    struct x1f4_mxdeck_type mxdeck;

    mxdeck.trans = &parser_data->m;

    return x1f4_init_mxdeck
	(&parser_data->function_tree, X1f4_MXDECK_TRANS_MASK, &mxdeck);
}


static int
fit_fine(struct a1_parser_type *parser_data)
{
    int status;
    void *fine;

    fine = parser_data->e4fine;
    if (fine) {
	parser_data->c1.transfer_set.fine = fine;
	if (1) {
	    status = 0;
	}
    } else {
	status = ink_fine(parser_data);
    }

    return status;
}


static int
fit_list(struct a1_parser_type *parser_data, struct a1_link_type *link_data,
	 const char *deck, unsigned size)
{
    int status = 0;

    do {
	const void *none;

	if (x1f4_find_mxpath(parser_data->variable_tree, deck, size, &none)) {
	    void *variable_slip;

	    variable_slip = (void *) parser_data->subtext;
	    if (variable_slip) {
		const void *miss;

		if (x1f4_find_mxpath(variable_slip, deck, size, &miss)) {
		    if (miss == none) {
			break;
		    }
		}
	    }
	} else {
	    break;
	}

	status = _x1f4_a1_090822_error_4(parser_data->back_data, deck, size);
    } while (0);

    return status;
}


static int
fix_fine(struct a1_parser_type *parser_data, const char *name, unsigned length,
	 struct a1_link_type *link_data)
{
    int status;
    void *variable_tree;

    variable_tree = parser_data->variable_tree;
    if (1) {
	if (0) {
	} else {
	    const void **pick;

	    if (x1f4_pick_mxpath(variable_tree, name, length, &pick)) {
		*pick = &link_data->datatext;

		status = 0;
	    } else {
		status = x1f4_post_mxpath
		    (variable_tree, name, length, &link_data->datatext);
	    }
	    if (status) {
		status = ALLOC_ERROR;
	    }
	}
    }

    return status;
}


static int
fix_lane(struct a1_parser_type *parser_data, const char *land)
{
    const char *e;
    int c, status;

    parser_data->half_expect = 1;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c != 0x28) {
	status = _x1f4_a1_090818_error_5(parser_data->back_data, e);
    } else {
	e++;

	parser_data->shuffle = e;

	status = ink_lane(parser_data);
	if (status) {
	} else {
	    e = parser_data->shuffle;

	    c = *(const unsigned char *) e;
	    if (c != 0x29) {
		status = _x1f4_a1_090818_error_6(parser_data->back_data, e);
	    } else {
		if (land) {
		    e = land;
		} else {
		    e++;
		}
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
fix_last(struct a1_parser_type *parser_data, struct a1_node_type *node_data)
{
    const char *e;
    int c, status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c != 0x7b) {
	status = _x1f4_a1_090821_error_0(parser_data->back_data, e);
    } else {
	e++;

	parser_data->shuffle = e;

	status = net_last(parser_data, node_data);
	if (status) {
	} else {
	    e = parser_data->shuffle;

	    parser_data->slip(&e);

	    c = *(const unsigned char *) e;
	    if (c != 0x7d) {
		status = _x1f4_a1_090828_error_0(parser_data->back_data, e);
	    } else {
		e++;
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
fix_lead(struct a1_parser_type *parser_data, const char *name, unsigned length,
	 struct a1_link_type *link_data)
{
    int status;
    void *variable_tree;
    const void *variable_slip;

    variable_slip = parser_data->subtext;
    if (variable_slip) {
	status = x1f4_copy_mxdeck(&variable_tree, (void *) variable_slip);
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    const void **pick;

	    if (x1f4_pick_mxpath(variable_tree, name, length, &pick)) {
		*pick = &link_data->datatext;

		status = 0;
	    } else {
		status = x1f4_post_mxpath
		    (variable_tree, name, length, &link_data->datatext);
	    }
	    if (status) {
		x1f4_fini_mxdeck(&variable_tree);
		status = ALLOC_ERROR;
	    } else {
		parser_data->variable_tree = variable_tree;
	    }
	}
    } else {
	struct x1f4_mxdeck_type mxdeck;

	mxdeck.trans = &parser_data->m;

	status = x1f4_init_mxdeck
	    (&variable_tree, X1f4_MXDECK_TRANS_MASK, &mxdeck);
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    if (1) {
		status = x1f4_post_mxpath
		    (variable_tree, name, length, &link_data->datatext);
	    }
	    if (status) {
		x1f4_fini_mxdeck(&variable_tree);
		status = ALLOC_ERROR;
	    } else {
		parser_data->variable_tree = variable_tree;
	    }
	}
    }

    return status;
}


static int
fix_line(struct a1_parser_type *parser_data, const char *land)
{
    const char *e;
    int c, status;

    parser_data->half_expect = 0;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c != 0x28) {
	status = _x1f4_a1_090818_error_5(parser_data->back_data, e);
    } else {
	e++;

	parser_data->shuffle = e;

	status = ink_line(parser_data);
	if (status) {
	} else {
	    e = parser_data->shuffle;

	    c = *(const unsigned char *) e;
	    if (c != 0x29) {
		status = _x1f4_a1_090818_error_6(parser_data->back_data, e);
	    } else {
		if (land) {
		    e = land;
		} else {
		    e++;
		}
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
fix_list(struct a1_parser_type *parser_data, const char *land)
{
    const char *e;
    int c, status;

    parser_data->half_expect = 0;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (c != 0x28) {
	status = _x1f4_a1_090818_error_5(parser_data->back_data, e);
    } else {
	e++;

	parser_data->shuffle = e;

	status = ink_list(parser_data);
	if (status) {
	} else {
	    e = parser_data->shuffle;

	    c = *(const unsigned char *) e;
	    if (c != 0x29) {
		status = _x1f4_a1_090818_error_6(parser_data->back_data, e);
	    } else {
		if (land) {
		    e = land;
		} else {
		    e++;
		}
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
fix_main(struct a1_parser_type *parser_data, const char *name, unsigned length)
{
    int status;

    if (length != 4) {
	status = 0;
    } else {
	if (((unsigned char *) name)[0] != 0x6d
	    || ((unsigned char *) name)[1] != 0x61
	    || ((unsigned char *) name)[2] != 0x69
	    || ((unsigned char *) name)[3] != 0x6e) {
	    status = 0;
	} else {
	    if (parser_data->type == X1f4_E4_MODE) {
		parser_data->main = 1;

		status = 0;
	    } else {
		status = 3;
	    }
	}
    }

    return status;
}


static int
fix_miss(struct a1_parser_type *parser_data, struct a1_link_type *link_data,
	 int side, int type, int copy, const char *name, unsigned length,
	 const struct x1f4_datatype_type *datatype_data)
{
    char *text;
    int status = 0;

    text = (char *) (link_data + 1);

    memcpy(text, name, length);
    text[length] = 0;

    link_data->variable.length = length;
    link_data->variable.name = text;
    link_data->variable.type = type;

    link_data->datatext.type = datatype_data;

    link_data->datatext.data = &link_data->variable;

    /*
     * reference function arguments are not retained.  and this is okay, as
     * long as only variables are allowed for such arguments.
     * in the same fashion, type restrictions apply only for non references.
     */

    if (copy) {
	link_data->datatext.link = &link_data->slip.data;
	link_data->variable.flags = 0;
	if (type ^ X1f4_E4_TEXT) {
	    if (datatype_data) {
		if (datatype_data->lead) {
		    link_data->line = _x1f4_a1_lead_node;
		    link_data->miss = _x1f4_a1_slip_node;
		} else {
		    if (side == SIDE_TYPE) {
			link_data->line = NULL;
			link_data->miss = NULL;
		    } else {
			status = _x1f4_a1_111111_error_0
			    (parser_data->back_data, name, type);
		    }
		}
	    } else {
		link_data->line = NULL;
		link_data->miss = NULL;
	    }
	} else {
	    link_data->line = _x1f4_a1_lead_text;
	    link_data->miss = _x1f4_a1_slip_text;
	}
    } else {
	if (side == SIDE_TYPE) {
	    status = _x1f4_a1_130806_error_0
		(parser_data->back_data, name, type);
	} else {
	    link_data->datatext.link = &parser_data->shuffle_data->stateset;
	    link_data->line = _x1f4_a1_lead_lock;
	    link_data->miss = NULL;
	    link_data->variable.flags = X1f4_E4_REFERENCE;
	}
    }

    if (type < X1f4_E4_CALL) {
    } else {
	const struct x1f4_linetext_type *linetext_data;

	/*
	 * TODO
	 *
	 * the _pick_e4fine call and the look up it performs could have been
	 * avoided (by retrieving the function type info in the e4jack call)
	 */
	x1f4_pick_e4fine(parser_data->e4fine, type, &linetext_data);
	if (copy) {
	    const X1f4_E4_C_USER *user;

	    user = (void *) &link_data->slip.data;
	    *user = (void *) linetext_data;
	} else {
	    link_data->slip.data.wind = (void *) linetext_data;
	}
    }

    link_data->datatext.datatext_data = NULL;

    return status;
}


static int
fix_name(struct a1_parser_type *parser_data, const char **land)
{
    const char *e, *f;
    int open, status, type;
    unsigned size;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    type = parser_data->type;

    open = *e == '(';
    if (open) {
	const char *a;
	struct a1_back_type *back_data;
	struct x1f4_ejrecord_type *ejrecord_data;
	unsigned bits;

	back_data = parser_data->back_data;
	if (back_data) {
	    ejrecord_data = &back_data->data.higherof.ejrecord;
	} else {
	    ejrecord_data = NULL;
	}

	a = e;

	status = x1f4_pick_e4jack
	    (type, &type, &bits, &size, &f, &a, 1, 1, parser_data->e4fine,
	     parser_data->slip, parser_data->datatype_data,
	     parser_data->sidetype_data, ejrecord_data);
	if (status) {
	    size = 0;
	} else {
	    if (false(bits)) {
		size = 0;
	    } else {
		*land = a;

		e = f + size;

		parser_data->type = type;
	    }
	}
    } else {
	f = e;

	way_red(&e);

	size = e - f;

	status = 0;
    }
    if (!size) {
	if (open) {
	    if (status == X1f4_E4JACK_ALLOC_ERROR) {
		status = ALLOC_ERROR;
	    } else {
		status = _x1f4_a1_111221_error_0
		    (parser_data->back_data, e, status);
	    }
	} else {
	    status = _x1f4_a1_090818_error_2(parser_data->back_data, e);
	}
    } else {
	const struct x1f4_function_type *function_data;

	parser_data->node_text = NULL;

	status = _x1f4_a1_get_last(f, size, parser_data, &function_data);
	if (status) {
	    int type;

	    if (x1f4_look_atkey_l(f, size, _x1f4_c1_text_root)) {
		if (fit_type(parser_data, f, size, &type)) {
		    if (fix_main(parser_data, f, size)) {
			status = _x1f4_a1_090822_error_0
			    (parser_data->back_data, f, parser_data->type);
		    } else {
			status = 0;

			parser_data->name = f;

			parser_data->length = size;

			parser_data->offset = f - parser_data->thirteen;
		    }
		} else {
		    status = _x1f4_a1_090818_error_4
			(parser_data->back_data, f, size);
		}
	    } else {
		status = _x1f4_a1_090818_error_4
		    (parser_data->back_data, f, size);
	    }
	} else {
	    struct a1_node_type *node_text;

	    node_text = parser_data->node_text;
	    if (node_text) {
		if (type ^ node_text->linetext.function.type) {
		    status = _x1f4_a1_101116_error_0
			(parser_data->back_data, parser_data->thirteen,
			 f - parser_data->thirteen, node_text,
			 node_text->linetext.function.type, parser_data->type);
		} else {
		    parser_data->offset = f - parser_data->thirteen;
		}
	    } else {
		status = _x1f4_a1_090818_error_3
		    (parser_data->back_data, f, size);
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
fix_posh(struct a1_parser_type *parser_data, const char *f, unsigned size)
{
    int status;

    status = x1f4_look_atkey_l(f, size, _x1f4_c1_text_root);
    if (status) {
	int type;

	if (fit_type(parser_data, f, size, &type)) {
	    status = 0;
	} else {
	    status = _x1f4_a1_090822_error_5(parser_data->back_data, f, size);
	}
    } else {
	status = _x1f4_a1_090822_error_5(parser_data->back_data, f, size);
    }

    return status;
}


static int
fix_type(struct a1_parser_type *parser_data, int *class)
{
    const char *e;
    int c, status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    c = *(const unsigned char *) e;
    if (!c) {
	*class = 1;

	status = 0;
    } else {
	const char *f;
	unsigned size;

	f = e;

	way_red(&e);

	size = e - f;
	if (!size) {
	    status = _x1f4_a1_090818_error_0(parser_data->back_data, e);
	} else {
	    do {
		int type;

#if ____FUNCTION_RETURN__ == __RECORD_STRAIGHT__
		parser_data->slip(&e);
#elif __FUNCTION_RETURN__ == __SCALAR_STRAIGHT__
		parser_data->slip(&e);
#elif __FUNCTION_RETURN__ == __SIMPLE_STRAIGHT__
		parser_data->slip(&e);
#endif				/* ____FUNCTION_RETURN__ == __RECORD_STRA... */

#if ____FUNCTION_RETURN__ == __RECORD_STRAIGHT__
		if (*e == '(') {
#elif 0
		}
#elif __FUNCTION_RETURN__ == __SCALAR_STRAIGHT__
		if (*e == '(') {
#elif 0
		}
#elif __FUNCTION_RETURN__ == __SIMPLE_STRAIGHT__
		if (*e == '(') {
#endif				/* ____FUNCTION_RETURN__ == __RECORD_STRA... */
		    status = set_type(f, size, &type);
		    if (status) {
			status = fit_type(parser_data, f, size, &type);
		    }
#if ____FUNCTION_RETURN__ == __RECORD_STRAIGHT__
		} else {
		    status = set_type(f, size, &type);
		    if (status) {
			if (parser_data->flags & LEAD_FLATTEXT) {
			    const struct x1f4_datatype_type *datatype_data;

			    status = x1f4_fast_e4jack
				(parser_data->datatype_data, f, size, &type,
				 &datatype_data);
# if 1
			    if (status) {
				status = x1f4_fast_e4jack
				    (parser_data->sidetype_data, f, size,
				     &type, &datatype_data);
			    }
# endif				/* 1 */
			    if (status) {
			    } else {
				if (datatype_data->lead) {
				} else {
				    status = _x1f4_a1_130414_error_0
					(parser_data->back_data, f, size);
				    if (1) {
					break;
				    }
				}
			    }
			}
		    } else {
			if (type == X1f4_E4_TEXT) {
			    if (parser_data->flags & LEAD_FLATTEXT) {
			    } else {
				status = -1;
			    }
			}
		    }
		}
#elif 0
		if (0) {
#elif __FUNCTION_RETURN__ == __SCALAR_STRAIGHT__
		} else {
		    status = red_type(f, size, &type);
		}
#elif 0
		if (0) {
#elif __FUNCTION_RETURN__ == __SIMPLE_STRAIGHT__
		} else {
		    status = net_type(f, size, &type);
		}
#endif				/* ____FUNCTION_RETURN__ == __RECORD_STRA... */
		if (status) {
#if ____FUNCTION_RETURN__ == __RECORD_STRAIGHT__
		    status = _x1f4_a1_091210_error_0
			(parser_data->back_data, f, size);
#elif __FUNCTION_RETURN__ == __SCALAR_STRAIGHT__
		    status = _x1f4_a1_091210_error_0
			(parser_data->back_data, f, size);
#elif __FUNCTION_RETURN__ == __SIMPLE_STRAIGHT__
		    status = _x1f4_a1_091210_error_0
			(parser_data->back_data, f, size);
#else
		    status = _x1f4_a1_090818_error_1
			(parser_data->back_data, f, size);
#endif				/* ____FUNCTION_RETURN__ == __RECORD_STRA... */
		} else {
		    *class = 0;

		    status = 0;

		    parser_data->type = type;
		}
	    } while (0);
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
ink_data(struct a1_parser_type *parser_data)
{
    int status;

    while (1) {
	int class3;

	status = ink_last(parser_data, &class3);
	if (status) {
	    break;
	} else {
	    if (class3) {
		break;
	    }
	}
    }

    return status;
}


static int
ink_fine(struct a1_parser_type *parser_data)
{
    int status;
    struct x1f4_e4fine_type e4fine;
    void *fine;

    e4fine.resource_set.data = parser_data->m.data;

    e4fine.resource_set.free = parser_data->m.free;
    e4fine.resource_set.link = parser_data->m.link;
    e4fine.resource_set.mode = parser_data->m.mode;

    status = x1f4_init_e4fine(&fine, X1f4_E4FINE_RESOURCE, &e4fine);
    if (status) {
    } else {
	parser_data->e4fine = fine;
	parser_data->shuffle_data->fine = fine;
	parser_data->c1.transfer_set.fine = fine;
    }

    return status;
}


static int
ink_lane(struct a1_parser_type *parser_data)
{
    const char *slip;
    int side = 0, status, type;

    slip = parser_data->shuffle;

    status = net_list(parser_data, &side, &type);
    if (status) {
    } else {
	const char *e;

	e = parser_data->shuffle;

	parser_data->slip(&e);

	parser_data->shuffle = e;

	if (type == X1f4_E4_VOID && *e != '(') {
	    if (parser_data->node_text->linetext.function.count) {
		status = _x1f4_a1_101115_error_0
		    (parser_data->back_data, parser_data->thirteen,
		     parser_data->offset, parser_data->node_text);
	    } else {
		status = set_side(parser_data, side);
	    }
	} else {
	    if (0) {
	    } else {
		status = set_lane(parser_data, type);
	    }
	}
    }

    return status;
}


static int
ink_last(struct a1_parser_type *parser_data, int *class)
{
    int class2 = 0, status;

    parser_data->v_flags = 0;

    status = fix_type(parser_data, &class2);
    if (status) {
    } else {
	if (class2) {
	    *class = class2;
	} else {
	    const char *land = NULL;

	    *class = 0;

	    status = fix_name(parser_data, &land);
	    if (status) {
	    } else {
		struct a1_node_type *node_text;

		node_text = parser_data->node_text;
		if (node_text) {
		    if (node_text->aime) {
			status = fix_lane(parser_data, land);
			if (status) {
			} else {
			    status = elk_miss(parser_data, node_text);
			}
		    } else {
			status = fix_line(parser_data, land);
			if (status) {
			} else {
			    status = elk_last(parser_data, node_text);
			}
		    }
		} else {
		    status = fix_list(parser_data, land);
		    if (status) {
		    } else {
			status = set_slip(parser_data);
			if (status) {
			} else {
			    status = elk_last
				(parser_data, parser_data->node_data);
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
ink_line(struct a1_parser_type *parser_data)
{
    const char *slip;
    int side = 0, status, type;

    slip = parser_data->shuffle;

    status = net_list(parser_data, &side, &type);
    if (status) {
    } else {
	const char *e;

	e = parser_data->shuffle;

	parser_data->slip(&e);

	parser_data->shuffle = e;

	if (type == X1f4_E4_VOID && *e != '(') {
	    if (parser_data->node_text->linetext.function.count) {
		status = _x1f4_a1_101115_error_0
		    (parser_data->back_data, parser_data->thirteen,
		     parser_data->offset, parser_data->node_text);
	    } else {
		status = set_side(parser_data, side);
		if (status) {
		} else {
		    parser_data->c1.variable_set.context =
			parser_data->subtext;
		}
	    }
	} else {
	    if (0) {
	    } else {
		status = set_line(parser_data, type);
		if (status) {
		} else {
		    parser_data->c1.variable_set.context =
			parser_data->variable_tree;
		}
	    }
	}
    }

    return status;
}


static int
ink_list(struct a1_parser_type *parser_data)
{
    const char *slip;
    const struct x1f4_datatype_type *datatype_data;
    int status, side = 0, type;

    slip = parser_data->shuffle;

    status = run_list(parser_data, &side, &type, &datatype_data);
    if (status) {
    } else {
	const char *e;

	e = parser_data->shuffle;

	parser_data->slip(&e);

	parser_data->shuffle = e;

	if (type == X1f4_E4_VOID && *e != '(') {
	    parser_data->c1.variable_set.context = parser_data->subtext;
	    if (side == EXTENSION) {
		parser_data->v_flags |= EXTENSION_LIST;
	    } else {
		if (side == REDUCTION) {
		    parser_data->v_flags |= REDUCTION_LIST;
		}
	    }
	} else {
	    if (parser_data->main == 1) {
		status = _x1f4_a1_090822_error_1(parser_data->back_data, slip);
	    } else {
		if (side == EXTENSION) {
		    parser_data->c1.variable_set.context =
			parser_data->subtext;
		    parser_data->v_flags |= EXTENSION_LIST;
		} else {
		    if (side == REDUCTION) {
			parser_data->c1.variable_set.context =
			    parser_data->subtext;
			parser_data->v_flags |= REDUCTION_LIST;
		    } else {
			status = set_list
			    (parser_data, side, type, datatype_data);
			if (status) {
			} else {
			    parser_data->c1.variable_set.context =
				parser_data->variable_tree;
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
map_data(struct a1_parser_type *parser_data)
{
    int status;

    status = ink_data(parser_data);
    if (status) {
    } else {
	if (parser_data->main) {
	    status = _x1f4_a1_lock_list(parser_data);
	    if (status) {
	    } else {
		if (parser_data->undefined) {
		    status = _x1f4_a1_101114_error_0
			(parser_data->back_data, parser_data->thirteen,
			 parser_data->node_data);
		}
	    }
	} else {
	    status = _x1f4_a1_090822_error_3(parser_data->back_data);
	}
    }

    return status;
}


static int
map_miss(struct a1_parser_type *parser_data, struct a1_link_type *link_data,
	 unsigned length)
{
    int status;

    if (length ^ link_data->variable.length) {
	status = M_MODE
	    (parser_data, &link_data->variable.name, length + 1);
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	}
    } else {
	status = 0;
    }

    return status;
}


static int
map_zero(struct a1_parser_type *parser_data,
	 const struct a1_context_type *context_data)
{
    if (1) {
	parser_data->c1_flags |= X1f4_C1_RESOURCE;
    }
    {
	void *context;

	context = context_data->link_m.data;
	parser_data->m.data = context;
	parser_data->c1.resource_set.context = context;
    }
    {
	int (*free) (void *, void *);

	free = context_data->link_m.free;
	parser_data->m.free = free;
	parser_data->c1.resource_set.free = free;
    }
    {
	int (*link) (void *, void **, unsigned);

	link = context_data->link_m.link;
	parser_data->m.link = link;
	parser_data->c1.resource_set.link = link;
    }
    {
	int (*mode) (void *, void **, unsigned);

	mode = context_data->link_m.mode;
	parser_data->m.mode = mode;
	parser_data->c1.resource_set.mode = mode;
    }

    return 0;
}


static int
net_fine(struct a1_parser_type *parser_data, int side, int type,
	 const struct x1f4_datatype_type *datatype_data)
{
    const char *name;
    int copy, status;
    unsigned length;

    status = net_miss
	(parser_data, &side, &type, &copy, &name, &length, &datatype_data);
    if (status) {
    } else {
	do {
	    struct a1_link_type *link_data;

	    if (length) {
		status = fit_list
		    (parser_data, parser_data->link_data, name, length);
		if (status) {
		    break;
		} else {
		    status = set_miss(parser_data, &link_data, length);
		    if (status) {
			break;
		    } else {
			status = fix_fine
			    (parser_data, name, length, link_data);
			if (status) {
			    way_fit(parser_data, link_data);
			    if (1) {
				break;
			    }
			} else {
			}
		    }
		}
	    } else {
		status = set_miss(parser_data, &link_data, length);
		if (status) {
		    break;
		}
	    }

	    status = fix_miss
		(parser_data, link_data, side, type, copy, name, length,
		 datatype_data);
	    if (status) {
		way_fit(parser_data, link_data);
	    } else {
		parser_data->post_link->datatext.datatext_data =
		    &link_data->datatext;
		parser_data->post_link = link_data;
	    }
	} while (0);
    }

    return status;
}


static int
net_last(struct a1_parser_type *parser_data, struct a1_node_type *node_data)
{
    const char *e;
    int status;
    void *aime;

    e = parser_data->shuffle;

    parser_data->node_text = NULL;

    if (parser_data->type == X1f4_E4_VOID) {
	parser_data->c1.completion = X1f4_C1_BACK_COMPLETION;
    } else {
	parser_data->c1.completion = X1f4_C1_TURN_COMPLETION;
	parser_data->c1.detail = parser_data->type;
    }

    status = x1f4_inIt_program
	(&aime, &e, parser_data->c1_flags, &parser_data->c1);
    if (status) {
	if (status == X1f4_C1_ALLOC_ERROR) {
	    status = ALLOC_ERROR;
	} else {
	    status = _x1f4_a1_090820_error_0(parser_data->back_data, e);
	}
    } else {
	parser_data->undefined--;

	node_data->aime = aime;

	node_data->offset = parser_data->shuffle - parser_data->thirteen;

	x1f4_size_program(aime, &node_data->class);

	if (parser_data->main == 1) {
	    parser_data->main = 2;

	    parser_data->shuffle_data->slip_node = node_data;
	}

	if (1) {
	    void *variable_tree;

	    variable_tree = parser_data->variable_tree;
	    if (variable_tree) {
		parser_data->variable_tree = NULL;
		x1f4_fini_mxdeck(&variable_tree);
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
net_lead(struct a1_parser_type *parser_data, int side, int type,
	 const struct x1f4_datatype_type *datatype_data)
{
    const char *name;
    int copy, status;
    unsigned length;

    status = net_miss
	(parser_data, &side, &type, &copy, &name, &length, &datatype_data);
    if (status) {
    } else {
	if (0) {
	} else {
	    struct a1_link_type *link_data;

	    status = set_miss(parser_data, &link_data, length);
	    if (status) {
	    } else {
		status = fix_lead(parser_data, name, length, link_data);
		if (status) {
		    way_fit(parser_data, link_data);
		} else {
		    status = fix_miss
			(parser_data, link_data, side, type, copy, name,
			 length, datatype_data);
		    if (status) {
			way_fit(parser_data, link_data);
		    } else {
			parser_data->link_data = link_data;
			parser_data->post_link = link_data;
		    }
		}
	    }
	}
    }

    return status;
}


static int
net_list(struct a1_parser_type *parser_data, int *side, int *type)
{
    const char *e;
    int status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    if (0) {
    } else {
	const char *f;
	unsigned size;

	f = e;

	way_red(&e);

	size = e - f;
	if (size) {
	    status = set_type(f, size, type);
	    if (status) {
		status = fit_type(parser_data, f, size, type);
		if (status) {
		    status = _x1f4_a1_090818_error_1
			(parser_data->back_data, f, size);
		}
	    } else {
	    }
	} else {
	    if (far_side(parser_data, side, &e)) {
		status = 0;
		if (1) {
		    *type = X1f4_E4_VOID;
		}
	    } else {
		if (parser_data->flags & CASTTYPE_LINK) {
		    status = 0;
		    *type = X1f4_E4_SLIP;
		    parser_data->v_flags |= ANONYMOUS_LIST;
		} else {
		    status =
			_x1f4_a1_090819_error_0(parser_data->back_data, e);
		}
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
net_miss(struct a1_parser_type *parser_data, int *gene, int *jack, int *copy,
	 const char **name, unsigned *length,
	 const struct x1f4_datatype_type **datatype)
{
    int status;

    do {
	const char *e, *f;
	int c;
	unsigned size;

	e = parser_data->shuffle;

	parser_data->slip(&e);

	c = *(const unsigned char *) e;
	if (c ^ 0x28) {
	    c = c ^ 0x26;
	    if (c) {
	    } else {
		e++;

		parser_data->slip(&e);
	    }

	    f = e;

	    if (*jack ^ X1f4_E4_SLIP) {
		way_red(&e);
	    }

	    size = e - f;
	} else {
	    struct a1_back_type *back_data;
	    struct x1f4_ejrecord_type *ejrecord_data;
	    unsigned bits;

	    back_data = parser_data->back_data;
	    if (back_data) {
		ejrecord_data = &back_data->data.higherof.ejrecord;
	    } else {
		ejrecord_data = NULL;
	    }

	    status = x1f4_pick_e4jack
		(*jack, jack, &bits, &size, &f, &e, 0, 0, parser_data->e4fine,
		 parser_data->slip, parser_data->datatype_data,
		 parser_data->sidetype_data, ejrecord_data);
	    if (status) {
		if (status == X1f4_E4JACK_ALLOC_ERROR) {
		    status = ALLOC_ERROR;
		} else {
		    status = _x1f4_a1_111221_error_0
			(parser_data->back_data, e, status);
		}

		if (1) {
		    break;
		}
	    } else {
		c = bits ^ X1f4_E4_POST_XSET;
		if (1) {
		    *gene = 0;
		    if (1) {
			*datatype = NULL;
		    }
		}
	    }
	}

	if (size) {
	    status = fix_posh(parser_data, f, size);
	    if (status) {
		break;
	    } else {
		status = 0;

		*name = f;

		*length = size;
	    }
	} else {
	    status = 0;

	    *name = f;

	    *length = 0;

	    if (*jack ^ X1f4_E4_SLIP) {
		parser_data->half_expect = 1;
	    }
	}

	parser_data->shuffle = e;

	*copy = c;

	if (c) {
	} else {
	    parser_data->v_flags |= REFERENCE_LIST;
	}
    } while (0);

    return status;
}


static int
net_post(struct a1_parser_type *parser_data, int *type)
{
    const char *e;
    int status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    if (0) {
    } else {
	const char *f;
	unsigned size;

	f = e;

	way_red(&e);

	size = e - f;
	if (size) {
	    status = set_type(f, size, type);
	    if (status) {
		status = fit_type(parser_data, f, size, type);
		if (status) {
		    status = _x1f4_a1_090818_error_1
			(parser_data->back_data, f, size);
		}
	    } else {
		if (*type == X1f4_E4_VOID) {
		    parser_data->slip(&e);
		    if (*e == '(') {
		    } else {
			status = _x1f4_a1_090819_error_2
			    (parser_data->back_data, f);
		    }
		}
	    }
	} else {
	    if (0) {
		status = 0;
		if (1) {
		}
	    } else {
		if (parser_data->flags & CASTTYPE_LINK) {
		    status = 0;
		    *type = X1f4_E4_SLIP;
		    parser_data->v_flags |= ANONYMOUS_LIST;
		} else {
		    status =
			_x1f4_a1_090819_error_1(parser_data->back_data, e);
		}
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


#if __FUNCTION_RETURN__ == __SIMPLE_STRAIGHT__
static int
net_type(const char *deck, unsigned size, int *type)
{
    int status;

    if (size == 8) {
	int c;

	c = *(const unsigned char *) deck;
	if (c == 0x63) {
	    if (try_line(deck, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c)) {
		status = 1;
	    } else {
		status = 0;

		*type = X1f4_E4_BILL;
	    }
	} else {
	    if (1) {
		status = 1;
	    }
	}
    } else {
	if (size == 7) {
	    int c;

	    c = *(const unsigned char *) deck;
	    if (c == 0x69) {
		if (try_rate(deck, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72)) {
		    status = 1;
		} else {
		    status = 0;

		    *type = X1f4_E4_MODE;
		}
	    } else {
		if (1) {
		    status = 1;
		}
	    }
	} else {
	    if (size != 4) {
		status = 1;
	    } else {
		int c;

		c = *(const unsigned char *) deck;
		if (c == 0x72) {
		    if (try_type(deck, 0x65, 0x61, 0x6c)) {
			status = 1;
		    } else {
			status = 0;

			*type = X1f4_E4_REAL;
		    }
		} else {
		    if (c == 0x76) {
			if (try_type(deck, 0x6f, 0x69, 0x64)) {
			    status = 1;
			} else {
			    status = 0;

			    *type = X1f4_E4_VOID;
			}
		    } else {
			if (1) {
			    status = 1;
			}
		    }
		}
	    }
	}
    }

    return status;
}
#endif				/* __FUNCTION_RETURN__ == __SIMPLE_STRAIG... */


static int
new_fine(struct a1_parser_type *parser_data, int type,
	 struct a1_link_type *link_data, unsigned rank)
{
    const char *name;
    int status;
    unsigned length;

    if (1) {
	if (0) {
	} else {
	    status = new_miss
		(parser_data, type, &name, &length, link_data, rank);
	    if (status) {
	    } else {
		if (length) {
		    status = fit_list
			(parser_data, link_data, name, length);
		    if (status) {
		    } else {
			status = map_miss(parser_data, link_data, length);
			if (status) {
			} else {
			    status =
				fix_fine(parser_data, name, length, link_data);
			    if (status) {
			    } else {
				sub_miss(parser_data, link_data, name, length);
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
new_lead(struct a1_parser_type *parser_data, int type,
	 struct a1_node_type *node_data, unsigned offset)
{
    const char *name;
    int status;
    struct a1_link_type *link_data;
    unsigned length;

    link_data = node_data->link_data;

    if (link_data) {
	if (0) {
	} else {
	    status = new_miss
		(parser_data, type, &name, &length, link_data, 0);
	    if (status) {
	    } else {
		if (0) {
		} else {
		    if (length) {
			status = map_miss(parser_data, link_data, length);
			if (status) {
			} else {
			    node_data->link_data = link_data;

			    status =
				fix_lead(parser_data, name, length, link_data);
			    if (status) {
			    } else {
				sub_miss(parser_data, link_data, name, length);
			    }
			}
		    } else {
			if (0) {
			} else {
			    /*
			     * terrible as it is, a new tree is created and a
			     * nil name is added to it.
			     */
			    status = fix_lead(parser_data, name, 0, link_data);
			}
		    }
		}
	    }
	}
    } else {
	status = _x1f4_a1_101115_error_0
	    (parser_data->back_data, parser_data->thirteen, offset,
	     parser_data->node_text);
    }

    return status;
}


static int
new_miss(struct a1_parser_type *parser_data, int type, const char **name,
	 unsigned *length, struct a1_link_type *link_data, unsigned rank)
{
    int status;

    do {
	const char *e, *f;
	int c;
	unsigned copy, size;

	e = parser_data->shuffle;

	parser_data->slip(&e);

	c = *(const unsigned char *) e;
	if (c ^ 0x28) {
	    c = c ^ 0x26;
	    if (c) {
		copy = 0;
	    } else {
		copy = X1f4_E4_REFERENCE;

		e++;

		parser_data->slip(&e);
	    }

	    f = e;

	    way_red(&e);

	    size = e - f;
	} else {
	    struct a1_back_type *back_data;
	    struct x1f4_ejrecord_type *ejrecord_data;

	    back_data = parser_data->back_data;
	    if (back_data) {
		ejrecord_data = &back_data->data.higherof.ejrecord;
	    } else {
		ejrecord_data = NULL;
	    }

	    status = x1f4_pick_e4jack
		(type, &type, &copy, &size, &f, &e, 0, 0, parser_data->e4fine,
		 parser_data->slip, parser_data->datatype_data,
		 parser_data->sidetype_data, ejrecord_data);
	    if (status) {
		if (status == X1f4_E4JACK_ALLOC_ERROR) {
		    status = ALLOC_ERROR;
		} else {
		    status = _x1f4_a1_111221_error_0
			(parser_data->back_data, e, status);
		}

		if (1) {
		    break;
		}
	    } else {
		copy = copy & X1f4_E4_POST_XSET ? X1f4_E4_REFERENCE : 0;
	    }
	}

	if (type ^ link_data->variable.type) {
	    status = _x1f4_a1_101116_error_1
		(parser_data->back_data, parser_data->thirteen,
		 parser_data->offset, parser_data->node_text, rank,
		 link_data->variable.type, type);
	    if (status) {
		break;
	    }
	}

	if ((link_data->variable.flags ^ copy) & X1f4_E4_REFERENCE) {
	    status = _x1f4_a1_101116_error_2
		(parser_data->back_data, parser_data->thirteen,
		 parser_data->offset, parser_data->node_text, rank);
	    if (status) {
		break;
	    }
	}

	if (size) {
	    status = fix_posh(parser_data, f, size);
	    if (status) {
		break;
	    } else {
		status = 0;

		*name = f;

		*length = size;
	    }
	} else {
	    status = 0;

	    *name = f;

	    *length = 0;

	    if (type ^ X1f4_E4_SLIP) {
		parser_data->half_expect = 1;
	    }
	}

	parser_data->shuffle = e;
    } while (0);

    return status;
}


#if __FUNCTION_RETURN__ == __SCALAR_STRAIGHT__
static int
red_type(const char *deck, unsigned size, int *type)
{
    int status;

    if (size == 8) {
	int c;

	c = *(const unsigned char *) deck;
	if (c == 0x63) {
	    if (try_line(deck, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c)) {
		status = 1;
	    } else {
		status = 0;

		*type = X1f4_E4_BILL;
	    }
	} else {
	    if (1) {
		status = 1;
	    }
	}
    } else {
	if (size == 7) {
	    int c;

	    c = *(const unsigned char *) deck;
	    if (c == 0x69) {
		if (try_rate(deck, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72)) {
		    status = 1;
		} else {
		    status = 0;

		    *type = X1f4_E4_MODE;
		}
	    } else {
		if (1) {
		    status = 1;
		}
	    }
	} else {
	    if (size != 4) {
		status = 1;
	    } else {
		int c;

		c = *(const unsigned char *) deck;
		if (c == 0x72) {
		    if (try_type(deck, 0x65, 0x61, 0x6c)) {
			status = 1;
		    } else {
			status = 0;

			*type = X1f4_E4_REAL;
		    }
		} else {
		    if (1) {
			status = 1;
		    }
		}
	    }
	}
    }

    return status;
}
#endif				/* __FUNCTION_RETURN__ == __SCALAR_STRAIG... */


static int
run_list(struct a1_parser_type *parser_data, int *side, int *type,
	 const struct x1f4_datatype_type **datatype)
{
    const char *e;
    int status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    if (0) {
    } else {
	const char *f;
	unsigned size;

	f = e;

	way_red(&e);

	size = e - f;
	if (size) {
	    status = set_type(f, size, type);
	    if (status) {
		status = run_type(parser_data, f, size, side, type, datatype);
		if (status) {
		    status = _x1f4_a1_090818_error_1
			(parser_data->back_data, f, size);
		}
	    } else {
		*datatype = NULL;
	    }
	} else {
	    if (far_side(parser_data, side, &e)) {
		status = 0;
		if (1) {
		}
	    } else {
		if (parser_data->flags & CASTTYPE_LINK) {
		    status = 0;
		    *datatype = NULL;
		    *type = X1f4_E4_SLIP;
		    parser_data->v_flags |= ANONYMOUS_LIST;
		} else {
		    status =
			_x1f4_a1_090819_error_0(parser_data->back_data, e);
		}
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}


static int
run_post(struct a1_parser_type *parser_data, int *side, int *type,
	 const struct x1f4_datatype_type **datatype)
{
    const char *e;
    int status;

    e = parser_data->shuffle;

    parser_data->slip(&e);

    if (0) {
    } else {
	const char *f;
	unsigned size;

	f = e;

	way_red(&e);

	size = e - f;
	if (size) {
	    status = set_type(f, size, type);
	    if (status) {
		status = run_type(parser_data, f, size, side, type, datatype);
		if (status) {
		    status = _x1f4_a1_090818_error_1
			(parser_data->back_data, f, size);
		}
	    } else {
		*datatype = NULL;

		if (*type == X1f4_E4_VOID) {
		    parser_data->slip(&e);
		    if (*e == '(') {
		    } else {
			status = _x1f4_a1_090819_error_2
			    (parser_data->back_data, f);
		    }
		}
	    }
	} else {
	    if (far_side(parser_data, side, &e)) {
		status = 0;
		if (1) {
		}
	    } else {
		if (parser_data->flags & CASTTYPE_LINK) {
		    status = 0;
		    *datatype = NULL;
		    *type = X1f4_E4_SLIP;
		    parser_data->v_flags |= ANONYMOUS_LIST;
		} else {
		    status =
			_x1f4_a1_090819_error_1(parser_data->back_data, e);
		}
	    }
	}
    }

    parser_data->shuffle = e;

    return status;
}



static int
run_type(struct a1_parser_type *parser_data, const char *f, unsigned size,
	 int *side, int *type, const struct x1f4_datatype_type **datatype)
{
    int delete;

    delete = x1f4_fast_e4jack
	(parser_data->datatype_data, f, size, type, datatype);
    if (delete) {
	delete = x1f4_fast_e4jack
	    (parser_data->sidetype_data, f, size, type, datatype);
	if (delete) {
	} else {
	    *side = SIDE_TYPE;
	}
    }

    return delete;
}


static int
set_lane(struct a1_parser_type *parser_data, int type)
{
    int status;
    struct a1_link_type *link_data;
    struct a1_node_type *node_data;

    node_data = parser_data->node_text;

    link_data = node_data->link_data;

    status = tie_lead(parser_data, type, node_data);
    if (status) {
    } else {
	unsigned name = 0;

	while (1) {
	    const char *e;
	    int c;
	    void *slip;

	    slip = link_data->datatext.datatext_data;

	    e = parser_data->shuffle;

	    parser_data->slip(&e);

	    c = *(const unsigned char *) e;
	    if (c != 0x2c) {
		if (slip
		    || (node_data->linetext.function.flags
			& X1f4_E4_SIDE_LIST)) {
		    status = _x1f4_a1_101115_error_0
			(parser_data->back_data, parser_data->thirteen,
			 parser_data->offset, parser_data->node_text);
		    if (1) {
			break;
		    }
		} else {
		    parser_data->shuffle = e;
		}

		break;
	    } else {
		e++;

		parser_data->shuffle = e;

		if (slip) {
		    link_data = b_offset(slip);
		} else {
		    unsigned flags;

		    flags = node_data->linetext.function.flags;
		    if (flags & X1f4_E4_SIDE_LIST) {
			int side;

			parser_data->slip(&e);
			if (far_side(parser_data, &side, &e)) {
			    if (side == REDUCTION
				&& !(flags & X1f4_E4_LINK_PASS)) {
			    } else {
				parser_data->shuffle = e;
				if (1) {
				    break;
				}
			    }
			}
		    }

		    status = _x1f4_a1_101115_error_0
			(parser_data->back_data, parser_data->thirteen,
			 parser_data->offset, parser_data->node_text);
		    if (1) {
			break;
		    }
		}

		status = net_post(parser_data, &type);
		if (status) {
		    break;
		} else {
		    name++;
		    status = tie_fine(parser_data, type, link_data, name);
		    if (status) {
			break;
		    }
		}
	    }
	}
    }

    return status;
}


static int
set_last(struct a1_parser_type *parser_data, unsigned count)
{
    int status;
    struct a1_node_type *node_data;
    unsigned length, shift;

    length = parser_data->length;

    if (parser_data->v_flags & REFERENCE_LIST) {
	shift = 1;
    } else {
	shift = 0;
    }

    status = M_LINK
	(parser_data, &node_data,
	 sizeof(struct a1_node_type) + (count * sizeof(int) << shift) + length
	 + 1);
    if (status) {
	status = ALLOC_ERROR;
    } else {
	const char *name;

	name = parser_data->name;

	status = x1f4_post_mxpath
	    (parser_data->function_tree, name, length, node_data);
	if (status) {
	    M_FREE(parser_data, node_data);
	    if (status < 0) {
		status = ALLOC_ERROR;
	    } else {
		status = _x1f4_a1_090818_error_7(parser_data->back_data);
	    }
	} else {
	    struct a1_link_type *link_data;

	    status = call_3974(parser_data, count, &link_data);
	    if (status) {
		M_FREE(parser_data, node_data);
	    } else {
		char *text;
		int (*link) (void *, void *, void **);
		unsigned q;
		void *args;

		args = node_data + 1;
		text = (char *) ((int *) args + (count << shift));

		memcpy(text, name, length);
		text[length] = 0;

		if (shift) {
		    way_fix(link_data, args, count);
		} else {
		    way_net(link_data, args, count);
		}

		q = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
		if (shift) {
		    q |= X1f4_E4_POST_TYPE;
		}

		if (parser_data->v_flags
		    & (ANONYMOUS_LIST | EXTENSION_LIST | REDUCTION_LIST)) {
		    link = _x1f4_a1_side_aime;
		    if (parser_data->v_flags & ANONYMOUS_LIST) {
			q |= X1f4_E4_SLIP_LIST;
		    }
		    if (parser_data->v_flags & EXTENSION_LIST) {
			q |= X1f4_E4_SIDE_LIST;
		    }
		    if (parser_data->v_flags & REDUCTION_LIST) {
			q |= X1f4_E4_LINK_PASS | X1f4_E4_SIDE_LIST;
		    }
		} else {
		    link = _x1f4_a1_link_aime;
		}

		node_data->aime = NULL;

		node_data->depth = 0;

		node_data->linetext.context = node_data;
		node_data->linetext.function.args = args;
		node_data->linetext.function.count = count;
		node_data->linetext.function.flags = q;
		node_data->linetext.function.function = link;
		node_data->linetext.function.length = length;
		node_data->linetext.function.name = text;
		node_data->linetext.function.type = parser_data->type;

		node_data->link = parser_data->shuffle_data;

		node_data->link_data = link_data;

		node_data->node_data = parser_data->node_data;

		node_data->offset = parser_data->offset;

		parser_data->node_data = node_data;

		parser_data->undefined++;
	    }
	}
    }

    return status;
}


static int
set_line(struct a1_parser_type *parser_data, int type)
{
    int status;
    struct a1_node_type *node_data;

    node_data = parser_data->node_text;

    status = new_lead(parser_data, type, node_data, parser_data->offset);
    if (status) {
    } else {
	struct a1_link_type *link_data, *link_text;
	unsigned name = 0;

	link_text = node_data->link_data;

	link_data = link_text;

	while (1) {
	    const char *e;
	    int c;
	    struct a1_link_type *link_slip;
	    void *slip;

	    link_slip = link_data;

	    slip = link_data->datatext.datatext_data;

	    e = parser_data->shuffle;

	    parser_data->slip(&e);

	    c = *(const unsigned char *) e;
	    if (c != 0x2c) {
		if (slip
		    || (node_data->linetext.function.flags
			& X1f4_E4_SIDE_LIST)) {
		    status = _x1f4_a1_101115_error_0
			(parser_data->back_data, parser_data->thirteen,
			 parser_data->offset, parser_data->node_text);
		    if (1) {
			break;
		    }
		} else {
		    parser_data->shuffle = e;
		}

		break;
	    } else {
		e++;

		parser_data->shuffle = e;

		if (slip) {
		    link_data = b_offset(slip);
		} else {
		    unsigned flags;

		    flags = node_data->linetext.function.flags;
		    if (flags & X1f4_E4_SIDE_LIST) {
			int side;

			parser_data->slip(&e);
			if (far_side(parser_data, &side, &e)) {
			    if (side == REDUCTION
				&& !(flags & X1f4_E4_LINK_PASS)) {
			    } else {
				parser_data->shuffle = e;
				if (1) {
				    break;
				}
			    }
			}
		    }

		    status = _x1f4_a1_101115_error_0
			(parser_data->back_data, parser_data->thirteen,
			 parser_data->offset, parser_data->node_text);
		    if (1) {
			break;
		    }
		}

		status = net_post(parser_data, &type);
		if (status) {
		    break;
		} else {
		    name++;
		    status = new_fine(parser_data, type, link_data, name);
		    if (status) {
			break;
		    }
		}
	    }
	}
    }

    return status;
}


static int
set_list(struct a1_parser_type *parser_data, int side, int type,
	 const struct x1f4_datatype_type *datatype_data)
{
    int status;

    status = net_lead(parser_data, side, type, datatype_data);
    if (status) {
    } else {
	while (1) {
	    const char *e;
	    int c;

	    e = parser_data->shuffle;

	    parser_data->slip(&e);

	    c = *(const unsigned char *) e;
	    if (c != 0x2c) {
		parser_data->shuffle = e;
		if (1) {
		    break;
		}
	    } else {
		int side = 0;

		e++;

		parser_data->shuffle = e;

		status = run_post(parser_data, &side, &type, &datatype_data);
		if (status) {
		    break;
		} else {
		    if (side == EXTENSION) {
			parser_data->v_flags |= EXTENSION_LIST;
			break;
		    } else {
			if (side == REDUCTION) {
			    parser_data->v_flags |= REDUCTION_LIST;
			    break;
			} else {
			    status = net_fine
				(parser_data, side, type, datatype_data);
			    if (status) {
				break;
			    }
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
set_miss(struct a1_parser_type *parser_data, struct a1_link_type **link,
	 unsigned length)
{
    int status;

    status = M_LINK
	(parser_data, link, sizeof(struct a1_link_type) + length + 1);
    if (status) {
	status = ALLOC_ERROR;
    } else {
    }

    return status;
}


static int
set_side(struct a1_parser_type *parser_data, int side)
{
    int status = 0;
    struct a1_node_type *node_data;

    node_data = parser_data->node_text;

    do {
	unsigned call;

	if (side) {
	    call = X1f4_E4_SIDE_LIST;
	    if (side ^ EXTENSION) {
		call |= X1f4_E4_LINK_PASS;
	    }
	} else {
	    call = 0;
	}
	if ((node_data->linetext.function.flags
	     & (X1f4_E4_LINK_PASS | X1f4_E4_SIDE_LIST)) ^ call) {
	} else {
	    break;
	}

	status = _x1f4_a1_101115_error_0
	    (parser_data->back_data, parser_data->thirteen,
	     parser_data->offset, node_data);
    } while (0);

    return status;
}


static int
set_slip(struct a1_parser_type *parser_data)
{
    unsigned count;

    way_set(parser_data, &count);

    return set_last(parser_data, count);
}


static int
sub_fine(struct a1_parser_type *parser_data, const char *name, unsigned length,
	 struct a1_link_type *link_data)
{
    int status;
    void *variable_tree;

    variable_tree = parser_data->variable_tree;
    if (1) {
	if (0) {
	} else {
	    status = x1f4_post_mxpath
		(variable_tree, name, length, &link_data->datatext);
	    if (status) {
		if (status != X1f4_MXDECK_EVER_MATCH) {
		    status = ALLOC_ERROR;
		} else {
		    status = _x1f4_a1_090822_error_4
			(parser_data->back_data, name, length);
		}
	    }
	}
    }

    return status;
}


static int
sub_lead(struct a1_parser_type *parser_data, const char *name, unsigned length,
	 struct a1_link_type *link_data)
{
    int status;
    void *variable_tree;

    if (0) {
    } else {
	struct x1f4_mxdeck_type mxdeck;

	mxdeck.trans = &parser_data->m;

	status = x1f4_init_mxdeck
	    (&variable_tree, X1f4_MXDECK_TRANS_MASK, &mxdeck);
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    if (1) {
		status = x1f4_post_mxpath
		    (variable_tree, name, length, &link_data->datatext);
	    }
	    if (status) {
		x1f4_fini_mxdeck(&variable_tree);
		status = ALLOC_ERROR;
	    } else {
		parser_data->variable_tree = variable_tree;
	    }
	}
    }

    return status;
}


static int
sub_miss(struct a1_parser_type *parser_data, struct a1_link_type *link_data,
	 const char *name, unsigned length)
{
    char *text;

    text = (char *) link_data->variable.name;

    memcpy(text, name, length);
    text[length] = 0;

    link_data->variable.length = length;

    return 0;
}


static int
tie_fine(struct a1_parser_type *parser_data, int type,
	 struct a1_link_type *link_data, unsigned rank)
{
    const char *name;
    int status;
    unsigned length;

    if (1) {
	if (0) {
	} else {
	    status = new_miss
		(parser_data, type, &name, &length, link_data, rank);
	    if (status) {
	    } else {
		if (length) {
		    if (0) {
		    } else {
			if (0) {
			} else {
			    status =
				sub_fine(parser_data, name, length, link_data);
			}
		    }
		}
	    }
	}
    }

    return status;
}


static int
tie_lead(struct a1_parser_type *parser_data, int type,
	 struct a1_node_type *node_data)
{
    const char *name;
    int status;
    struct a1_link_type *link_data;
    unsigned length;

    link_data = node_data->link_data;

    if (link_data) {
	if (0) {
	} else {
	    status = new_miss
		(parser_data, type, &name, &length, link_data, 0);
	    if (status) {
	    } else {
		if (0) {
		} else {
		    if (0) {
		    } else {
			if (0) {
			} else {
			    status =
				sub_lead(parser_data, name, length, link_data);
			}
		    }
		}
	    }
	}
    } else {
	status = _x1f4_a1_101115_error_0
	    (parser_data->back_data, parser_data->thirteen,
	     parser_data->offset, parser_data->node_text);
    }

    return status;
}


static void
air_fix(struct a1_parser_type *parser_data)
{
    struct a1_link_type *link_data;

    link_data = parser_data->link_data;
    if (link_data) {
	_x1f4_a1_miss_lane(&parser_data->m, link_data);
    }
}


static void
air_net(struct a1_parser_type *parser_data, struct a1_node_type **node)
{
    struct a1_node_type *node_data;

    node_data = parser_data->node_data;

    parser_data->node_data = node_data->node_data;

    if (1) {
	struct a1_link_type *link_data;

	link_data = node_data->link_data;
	if (link_data) {
	    _x1f4_a1_miss_slip
		(&parser_data->m, link_data,
		 node_data->linetext.function.count);
	}
    }

    *node = node_data;
}


static void
air_set(struct a1_parser_type *parser_data)
{
    if (1) {
	x1f4_fini_mxdeck(&parser_data->function_tree);
    }
}


static void
air_way(struct a1_parser_type *parser_data)
{
    void *variable_tree;

    variable_tree = parser_data->variable_tree;
    if (variable_tree) {
	x1f4_fini_mxdeck(&variable_tree);
    }
}


static void
rule_cast(struct a1_parser_type *parser_data)
{
    const char *name;
    int type;
    const struct x1f4_datatype_type *sidetype_data;

    type = parser_data->lead;

    sidetype_data = parser_data->sidetype_data;
    name = sidetype_data->name;
    while (name) {
	if (sidetype_data->type == type) {
	    parser_data->c1_flags |= X1f4_C1_TURNCAST;
	    parser_data->c1.castlink_set.text = sidetype_data->context;
	    parser_data->c1.castlink_set.type = type;
	    if (1) {
		break;
	    }
	} else {
	    sidetype_data++;
	    name = sidetype_data->name;
	}
    }
}


static void
way_far(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    while (1) {
	c = *(const unsigned char *) e;
	if (C_TYPE_X(c_type_4, c)) {
	    e++;
	} else {
	    if (c ^ 35) {
		break;
	    } else {
		do {
		    ++e;
		    c = *(const unsigned char *) e;
		} while (c ^ 10);
	    }
	}
    }

    *deck = e;
}


static void
way_fit(struct a1_parser_type *parser_data, struct a1_link_type *link_data)
{
    M_FREE(parser_data, link_data);
}


static void
way_fix(struct a1_link_type *link_data, int *args, unsigned count)
{
    unsigned i;

    i = count;
    for (; i; i--) {
	*args = link_data->variable.type;
	if (link_data->variable.flags & X1f4_E4_REFERENCE) {
	    args[count] = X1f4_E4_POST_XSET;
	} else {
	    args[count] = 0;
	}

	args++;

	link_data++;
    }
}


static void
way_net(struct a1_link_type *link_data, int *args, unsigned count)
{
    for (; count; count--) {
	*args++ = link_data++->variable.type;
    }
}


static void
way_new(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    c = *(const unsigned char *) e;
    while (C_TYPE_X(c_type_4, c)) {
	e++;
	c = *(const unsigned char *) e;
    }

    *deck = e;
}


static void
way_red(const char **deck)
{
    const char *e;
    unsigned c;

    e = *deck;

    c = *(const unsigned char *) e;
    if (C_TYPE_X(c_type_1, c)) {
	e++;
	c = *(const unsigned char *) e;
	while (C_TYPE_X(c_type_2, c)) {
	    e++;
	    c = *(const unsigned char *) e;
	}
    }

    *deck = e;
}


static void
way_set(struct a1_parser_type *parser_data, unsigned *count)
{
    struct a1_link_type *link_data;

    link_data = parser_data->link_data;
    if (link_data) {
	unsigned fast = 1;

	while (1) {
	    void *slip;

	    slip = link_data->datatext.datatext_data;
	    if (slip) {
		link_data = b_offset(slip);
		fast++;
	    } else {
		break;
	    }
	}

	*count = fast;
    } else {
	*count = 0;
    }
}


int
x1f4_inIt_shuffle(struct a1_shuffle_type **shuffle, const char **shuffLe,
		  unsigned flags, const struct a1_context_type *context_data)
{
    int status;
    struct a1_parser_type parser;
    struct a1_shuffle_type *shuffle_data;
    unsigned extra = 0;

    parser.c1_flags = X1f4_C1_SLIPTEST | X1f4_C1_TRANSFER;

    if (flags & RESOURCE_LINK) {
	map_zero(&parser, context_data);
    } else {
	parser.m.data = NULL;
	parser.m.free = _x1f4_e4_free_data;
	parser.m.link = _x1f4_e4_link_data;
	parser.m.mode = _x1f4_e4_mode_data;
    }

    if (flags & CASTTYPE_LINK) {
	extra += sizeof(struct x1f4_linetext_type) * 3;
	extra += sizeof(struct x1f4_2ndscope_type);
	extra += sizeof(struct x1f4_operator_type);
	extra += sizeof(int) << 1;
    }

    status = parser.m.link
	(parser.m.data, (void *) &shuffle_data,
	 sizeof(struct a1_shuffle_type) + extra);
    if (status) {
	status = ALLOC_ERROR;
    } else {
	if (flags & DIRECT_ACCESS) {
	    parser.c1_flags |= X1f4_C1_DDACCESS;
	}
	if (flags & COMPOSER_LINK) {
	    parser.c1_flags |= X1f4_C1_COMPOSER;
	    parser.c1.composer_set.get = context_data->turn_0.get;
	    parser.c1.composer_set.context = context_data->turn_0.context;
	}
	if (flags & ERROR_STORAGE) {
	    parser.c1.bcollect_set.c1record_data =
		&((struct a1_back_type *)
		  context_data->link_e.back)->data.c_syntax.c1record;
	    parser.back_data = context_data->link_e.back;
	    parser.c1_flags |= X1f4_C1_BCOLLECT;
	} else {
	    parser.back_data = NULL;
	}
	if (flags & IMPLICIT_LINK) {
	    parser.c1_flags |= X1f4_C1_IMPLICIT;
	    parser.c1.implicit_set.get = context_data->trap_0.get;
	    parser.c1.implicit_set.context = context_data->trap_0.context;
	}
#if __FUNCTION_RETURN__ == __RECORD_STRAIGHT__
	if (flags & LEAD_FLATTEXT) {
	    parser.c1_flags |= X1f4_C1_LEADPOST;
	    parser.c1.autolead_set.context = context_data->near_f.data;
	    parser.c1.autolead_set.link = context_data->near_f.link;
	    parser.c1.autolead_set.pick = context_data->near_f.pick;
	}
#endif				/* __FUNCTION_RETURN__ == __RECORD_STRAIG... */
	if (flags & LINE_OPTIMIZE) {
	    parser.c1_flags |= X1f4_C1_OPTIMIZE;
	}
	if (flags & SKIP_SCOMMENT) {
	    parser.c1_flags |= X1f4_C1_SCOMMENT;
	    parser.slip = way_far;
	} else {
	    parser.slip = way_new;
	}
	if (flags & TRANSFER_LINK) {
	    parser.e4fine = context_data->link_i.fine;
	} else {
	    parser.e4fine = NULL;
	}
	parser.c1.completion = X1f4_C1_BACK_COMPLETION;
	parser.c1.function_set.context = &parser;
	parser.c1.function_set.fix = _x1f4_a1_fix_last;
	parser.c1.function_set.get = _x1f4_a1_get_last;
	parser.c1.operator1s = context_data->operator1s;
	parser.c1.operator2s = context_data->operator2s;
	parser.context = context_data->last_0.context;
	parser.fix = context_data->last_0.fix;
	parser.flags = flags;
	parser.function_tree = NULL;
	parser.get = context_data->last_0.get;
	parser.lead = context_data->link_g.type;
	parser.link_data = NULL;
	parser.main = 0;
	parser.node_data = NULL;
	parser.shuffle = *shuffLe;
	parser.shuffle_data = shuffle_data;
	parser.subtext = context_data->ever_0.context;
	parser.thirteen = parser.shuffle;
	parser.undefined = 0;
	parser.variable_tree = NULL;
	shuffle_data->back_pipe = NULL;
	shuffle_data->fine = NULL;
	shuffle_data->flat_data = NULL;
	shuffle_data->m.data = parser.m.data;
	shuffle_data->m.free = parser.m.free;
	shuffle_data->m.link = parser.m.link;
	shuffle_data->m.mode = parser.m.mode;
	shuffle_data->node_data = NULL;
	shuffle_data->pipe_long = NULL;
	shuffle_data->stateset.get = _x1f4_a1_fix_state;
	/* set the temporaries allocator as not in use,
	   so the data allocator is used instead */
	shuffle_data->v.link = NULL;
	if (flags & CASTTYPE_LINK) {
	    void *data;

	    data = shuffle_data + 1;
	    parser.linetext_data = data;
	    _x1f4_a1_line_aime(&parser, data);
	    shuffle_data->r.type = context_data->link_g.type;
	} else {
	    parser.linetext_data = NULL;
	    shuffle_data->r.type = -1;
	}
	if (flags & SIDELIST_LINK) {
	    parser.c1_flags |= X1f4_C1_SIDELIST;
	    parser.c1.sidetype_set.miss = context_data->user_z.miss;
	    parser.sidetype_data = context_data->user_z.miss;
	    shuffle_data->u.sidetype_data = parser.sidetype_data;
	    if (flags & CASTTYPE_LINK) {
		rule_cast(&parser);
	    }
	} else {
	    parser.sidetype_data = NULL;
	    shuffle_data->u.sidetype_data = &missed;
	}
	if (flags & TEXTFLAT_LINK) {
	    shuffle_data->x.data = context_data->call_e.data;
	    shuffle_data->x.line = context_data->call_e.line;
	    shuffle_data->x.post = context_data->call_e.post;
	    shuffle_data->x.push = context_data->call_e.push;
	} else {
	    shuffle_data->x.data = NULL;
	    shuffle_data->x.line = NULL;
	    shuffle_data->x.post = NULL;
	    shuffle_data->x.push = NULL;
	}
	if (flags & EELOOKUP_LINK) {
	    shuffle_data->y.eelookup_data = context_data->trap_e.eelookup_data;
	} else {
	    shuffle_data->y.eelookup_data = NULL;
	}
	if (flags & TYPELIST_LINK) {
	    if (1) {
		parser.c1.datatype_set.miss = context_data->user_w.miss;
		parser.c1_flags |= X1f4_C1_TYPELIST;
		parser.datatype_data = context_data->user_w.miss;
		shuffle_data->u.datatype_data = parser.datatype_data;
	    } else {
	    }
	} else {
	    parser.datatype_data = NULL;
	    shuffle_data->u.datatype_data = &missed;
	}
	status = fit_deck(&parser);
	if (status) {
	} else {
	    status = fit_fine(&parser);
	    if (status) {
	    } else {
		status = _x1f4_a1_lead_link(&parser);
		if (status) {
		} else {
		    status = map_data(&parser);

		    if (parser.c1.operator1s != context_data->operator1s) {
			M_FREE(&parser, (void *) parser.c1.operator1s);
		    }
		}
	    }

	    air_set(&parser);
	}
	if (status) {
	    struct a1_node_type *node_text = NULL;

	    if (1) {
		struct a1_node_type *node_data;

		node_data = parser.node_data;
		if (node_data) {
		    if (node_data->aime) {
		    } else {
			air_net(&parser, &node_text);
		    }
		}
	    }

	    air_way(&parser);

	    air_fix(&parser);

	    _x1f4_a1_flat_list(&parser.m, parser.node_data);

	    if (node_text) {
		M_FREE(&parser, node_text);
	    }

	    x1f4_fini_shuffle(&shuffle_data);
	} else {
	    *shuffle = shuffle_data;
	    if (1) {
		shuffle_data->node_data = parser.node_data;
		shuffle_data->v.link = context_data->were_f.link;
		shuffle_data->v.text = context_data->were_f.data;
	    }
	}

	*shuffLe = parser.shuffle;
    }

    return status;
}
