/*
 * a1.7.4.c
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-inter.h>
#include <a1-parse.h>
#include <c1.h>
#include <trans.h>

#define parser(text) \
    ((struct a1_parser_type *) (text))

static int miss_node(struct trans_type *, struct a1_node_type *);

static int
miss_node(struct trans_type *trans_data, struct a1_node_type *node_data)
{
    int excess, status;

    status = _x1f4_a1_miss_node(trans_data, node_data);

    excess = trans_data->free(trans_data->data, node_data);
    if (excess) {
	if (status) {
	} else {
	    status = excess;
	}
    }

    return status;
}


int
_x1f4_a1_lock_list(void *parser)
{
    int status = 0;
    struct a1_node_type *node_data;

    node_data = parser(parser)->node_data;
    if (node_data) {
	struct a1_node_type *last_node = NULL, *slip_node;
	struct trans_type *trans_data;

	slip_node = parser(parser)->shuffle_data->slip_node;

	trans_data = &parser(parser)->m;

	do {
	    struct a1_node_type *next_node;

	    next_node = node_data->node_data;

	    if (node_data->depth) {
		node_data->depth = 0;
		last_node = node_data;
	    } else {
		if (node_data != slip_node) {
		    if (node_data->aime) {
		    } else {
			parser(parser)->undefined--;
		    }

		    status = miss_node(trans_data, node_data);

		    if (last_node) {
			last_node->node_data = next_node;
		    } else {
			parser(parser)->node_data = next_node;
		    }

		    if (status) {
			break;
		    }
		} else {
		    last_node = node_data;
		}
	    }

	    node_data = next_node;
	} while (node_data);
    }

    return status;
}
