/*
 * a1.7.3.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <a1-defs.h>
#include <a1-inter.h>
#include <a1-parse.h>
#include <e4.h>

#define parser(text) \
    ((struct a1_parser_type *) (text))

int
_x1f4_a1_lead_link(void *parser)
{
    int status;

    if (parser(parser)->flags & CASTTYPE_LINK) {
	const struct x1f4_operator_type *const *operator1s;
	unsigned count = 0;
	void *data;

	operator1s = parser(parser)->c1.operator1s;
	while (*operator1s) {
	    operator1s++;
	    count++;
	}

	status = parser(parser)->m.link
	    (parser(parser)->m.data, &data,
	     (count + 2) * sizeof(const struct x1f4_operator_type *));
	if (status) {
	    status = ALLOC_ERROR;
	} else {
	    const struct x1f4_operator_type **operator0s;

	    memcpy
		(data, operator1s - count,
		 count * sizeof(const struct x1f4_operator_type *));

	    parser(parser)->c1.operator1s = data;

	    operator0s = data;
	    operator0s += count;
	    *operator0s++ = (struct x1f4_operator_type *)
		((struct x1f4_2ndscope_type *)
		 ((struct x1f4_linetext_type *)
		  (parser(parser)->shuffle_data + 1) + 3) + 1);
	    *operator0s = NULL;
	}
    } else {
	status = 0;
    }

    return status;
}
