/*
 * a1.7.2.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-inter.h>
#include <a1-parse.h>
#include <e4.h>

#define parser(text) \
    ((struct a1_parser_type *) (text))

int
_x1f4_a1_line_aime(void *parser, struct x1f4_linetext_type *linetext_data)
{
    int *args;
    struct x1f4_2ndscope_type *endscope_data;
    struct x1f4_operator_type *operator_data;

    endscope_data = (void *) (linetext_data + 3);

    operator_data = (void *) (endscope_data + 1);

    args = (void *) (operator_data + 1);

    linetext_data->context = parser(parser)->shuffle_data;

    linetext_data->function.count = 0;
    linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    linetext_data->function.function = _x1f4_a1_beta_fine;
    linetext_data->function.name = "count";
    linetext_data->function.length = 5;
    linetext_data->function.type = X1f4_E4_MODE;

    linetext_data++;

    linetext_data->context = parser(parser)->shuffle_data;

    linetext_data->function.args = &(linetext_data - 1)->function.type;
    linetext_data->function.count = 1;
    linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    linetext_data->function.function = _x1f4_a1_beta_lead;
    linetext_data->function.name = "lead";
    linetext_data->function.length = 4;
    linetext_data->function.type = parser(parser)->lead;

    endscope_data->bits = X1f4_E4_CALL_LINK;
    endscope_data->line = linetext_data;

    operator_data->args = linetext_data->function.args;
    operator_data->extension2 = endscope_data;
    operator_data->flags = X1f4_E4_KEEP_CALL | X1f4_E4_E2ND_LINK;
    operator_data->length = 1;
    operator_data->name = "$";
    operator_data->type = parser(parser)->lead;

    linetext_data++;

    linetext_data->context = parser(parser)->shuffle_data;

    linetext_data->function.args = args;
    linetext_data->function.count = 2;
    linetext_data->function.flags = X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
    linetext_data->function.function = _x1f4_a1_beta_call;
    linetext_data->function.name = "set";
    linetext_data->function.length = 3;
    linetext_data->function.type = X1f4_E4_VOID;

    *args = X1f4_E4_MODE;
    args++;
    *args = parser(parser)->lead;

    return 0;
}
