/*
 * a1.7.1.c
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-parse.h>
#include <e4.h>
#include <mxdeck.h>
#include <string.h>

#define parser(text) \
    ((struct a1_parser_type *) (text))

int
_x1f4_a1_fix_last(const void *context,
		  const struct x1f4_function_type *function_data,
		  void **subtext)
{
#if 1
    /* calling ->fix is still required */

    int status;

    if (parser(context)->node_text) {
	*subtext = parser(context)->node_text;

	status = 0;
    } else {
	status = parser(context)->fix
	    (parser(context)->context, function_data, subtext);
    }

    return status;
#else
    *subtext = (void *)
	((const struct x1f4_linetext_type *)
	 ((const char *) function_data
	  - offsetof(struct x1f4_linetext_type, function)))->context;

    return 0;
#endif
}


int
_x1f4_a1_get_last(const char *name, unsigned size, const void *context,
		  const struct x1f4_function_type **function)
{
    int delete;

    delete = parser(context)->get
	(name, size, parser(context)->context, function);
    if (delete) {
	void *function_tree;

	function_tree = parser(context)->function_tree;
	if (1) {
	    const void *node;

	    delete = x1f4_find_mxpath(function_tree, name, size, &node);
	    if (delete) {
		parser(context)->node_text = (void *) node;

		*function = &((struct a1_node_type *) node)->linetext.function;

		((struct a1_node_type *) node)->depth++;

		delete = 0;
	    } else {
		const struct x1f4_linetext_type *linetext_data;

		parser(context)->node_text = NULL;

		delete = 1;

		linetext_data = parser(context)->linetext_data;
		if (linetext_data) {
		    if (size == 3) {
			if (memcmp(name, "set", 3)) {
			} else {
			    *function = &linetext_data[2].function;

			    delete = 0;
			}
		    } else {
			if (size == 4) {
			    if (memcmp(name, "lead", 4)) {
			    } else {
				*function = &linetext_data[1].function;

				delete = 0;
			    }
			} else {
			    if (size == 5) {
				if (memcmp(name, "count", 5)) {
				} else {
				    *function = &linetext_data[0].function;

				    delete = 0;
				}
			    }
			}
		    }
		}
	    }
	}
    } else {
	parser(context)->node_text = NULL;
    }

    return delete;
}
