/*
 * a1.5.c
 * Copyright (C) 2011-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1-types.h>
#include <e4.h>

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

int
_x1f4_a1_beta_fine(void *context, void *output, void **input)
{
    const struct x1f4_function_type *function_data;
    struct a1_shuffle_type *shuffle_data;

    shuffle_data = context;

    function_data = &shuffle_data->fail_node->linetext.function;
    if (function_data->flags & X1f4_E4_SIDE_LIST) {
	function_data = shuffle_data->s.function_data;
    }

    l_MODE(function_data->count, output);

    return 0;
}
