/*
 * a1.4.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <e4.h>
#include <lxcast.h>

#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

int
_x1f4_a1_beta_lead(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE mode;
    int status;
    struct a1_node_type *node_data;
    struct a1_shuffle_type *shuffle_data;
    const struct x1f4_function_type *function_data;
    unsigned count, flags;

    shuffle_data = context;

    node_data = shuffle_data->fail_node;

    function_data = &node_data->linetext.function;

    flags = function_data->flags;

    if (flags & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	function_data = shuffle_data->s.function_data;
	if (1) {
	    flags = function_data->flags;
	}
    }

    count = function_data->count;

    mode = I_MODE(input[0]);
    if (-(X1f4_E4_C_MODE) count - 1 < mode && mode < (X1f4_E4_C_MODE) count) {
	do {
	    unsigned class;
	    void *data;

	    class = node_data->linetext.function.count;

	    if (mode < 0) {
		mode += count;
	    }

	    if (mode < class) {
		struct a1_link_type *link_data;

#if 0
		if (flags & X1f4_E4_POST_TYPE) {
		    if (function_data->args[class + mode]
			& X1f4_E4_POST_XSET) {
			status = _x1f4_a1_stat_post(shuffle_data);
			if (1) {
			    break;
			}
		    }
		}
#endif				/* 0 */

		status = shuffle_data->v.link
		    (shuffle_data->v.text, &data,
		     sizeof(struct x1f4_dxcast_type));
		if (status) {
		    status = _x1f4_a1_stat_link(shuffle_data);
		} else {
		    const int *args;
		    int type;
		    struct x1f4_dxcast_type *object_data;

		    args = function_data->args + mode;

		    type = *args;

		    l_USER(data, output);

		    object_data = data;

		    link_data = node_data->link_data;

		    link_data += mode;

		    if (type == shuffle_data->r.type) {
			struct x1f4_dxcast_type *object_text;

			object_text = *(void **) &link_data->slip.data;
			type = object_text->type;
			copy_miss(&object_data->data, type,
				  &object_text->data);
		    } else {
			if (flags & X1f4_E4_POST_TYPE) {
			    class = function_data->count;
			    if (args[class] & X1f4_E4_POST_XSET) {
				copy_miss(&object_data->data, type,
					  link_data->slip.data.wind);
			    } else {
				copy_miss(&object_data->data, type,
					  &link_data->slip.data);
			    }
			} else {
			    copy_miss(&object_data->data, type,
				      &link_data->slip.data);
			}
		    }

		    object_data->call = 0;
		    object_data->type = type;
		}
	    } else {
		status = 0;

		do {
		    int trap;
		    struct x1f4_dxcast_type *dxcast_data;

		    dxcast_data = shuffle_data->s.lead;

		    trap = mode - class;

		    if (flags & X1f4_E4_POST_TYPE) {
			const int *args;

			args = function_data->args + mode;

			if (args[count] & X1f4_E4_POST_XSET) {
			    copy_miss(&(dxcast_data + trap)->data, *args,
				      *((void **) (dxcast_data + count - class)
					+ trap));
			}
		    }

		    l_USER(dxcast_data + trap, output);
		} while (0);
	    }
	} while (0);
    } else {
	status = _x1f4_a1_stat_deck(shuffle_data, count, mode);
    }

    return status;
}
