/*
 * a1.1.c
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2012, Ciprian Niculescu
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>

#include <a1-copy.h>
#include <a1-inter.h>
#include <a1-types.h>
#include <c1.h>
#include <e4.h>
#include <exerrors.h>

#define copy_link(link, call) \
    copy_miss(&(link)->slip.data, (link)->variable.type, (call))

static int fast_aime(struct a1_node_type *, void *, void **, unsigned);
static int file_aime(struct a1_node_type *, void *, void **);
static int lead_aime(struct a1_node_type *, void *, void **, unsigned);
static int line_aime(struct a1_node_type *, void *, void **);
static int link_aime(struct a1_node_type *, void *, void **, void *);
static int long_aime(struct a1_node_type *, void *, void **);
static int miss_line(struct a1_shuffle_type *, struct a1_link_type *,
		     unsigned);
static int near_aime(struct a1_node_type *, void *, void **);
static int pipe_aime(struct a1_pipe_type *, struct a1_node_type *, void *,
		     void *, void **);
static int pipe_line(struct a1_node_type *, struct a1_link_type *, void **,
		     void *);
static int pipe_side(struct a1_node_type *, void **, void *);
static int text_line(struct a1_node_type *, struct a1_link_type *);
static int text_side(struct a1_node_type *);
static int type_line(struct a1_node_type *, struct a1_link_type *, void **);
static int type_side(struct a1_node_type *, void **);

static int
fast_aime(struct a1_node_type *node_data, void *output, void **input,
	  unsigned class)
{
    int status;
    struct a1_shuffle_type *shuffle_data;
    void *data;

    shuffle_data = node_data->link;

    status = shuffle_data->m.link(shuffle_data->m.data, &data, class);
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	int excess;

	status = x1f4_push_program(node_data->aime, data);
	if (status) {
	    status = X1f4_EX_CANNOT_CONTINUE;
	} else {
	    struct a1_lead_type lead;

	    status = link_aime(node_data, &lead, input, data);

	    x1f4_fast_program(node_data->aime, data);

	    if (status) {
	    } else {
		struct a1_lead_type *lead_data;

		lead_data = output;
		*lead_data = lead;
	    }
	}

	excess = shuffle_data->m.free(shuffle_data->m.data, data);
	if (excess) {
	    if (status) {
	    } else {
		status = _x1f4_a1_stat_free(shuffle_data);
	    }
	}
    }

    return status;
}


static int
file_aime(struct a1_node_type *node_data, void *output, void **input)
{
    int status;
    unsigned class;

    class = node_data->class;
    if (class) {
	status = fast_aime(node_data, output, input, class);
    } else {
	status = link_aime(node_data, output, input, NULL);
    }

    return status;
}


static int
lead_aime(struct a1_node_type *node_data, void *output, void **input,
	  unsigned class)
{
    int status;
    void *data;
    struct a1_shuffle_type *shuffle_data;

    shuffle_data = node_data->link;

    status = shuffle_data->m.link
	(shuffle_data->m.data, &data, sizeof(struct a1_lead_type) * class);
    if (status) {
	status = _x1f4_a1_stat_link(shuffle_data);
    } else {
	int excess;
	struct a1_lead_type *lead_data;
	struct a1_link_type *link_data;
	unsigned count;

	link_data = node_data->link_data;

	lead_data = data;

	count = class;
	for (; count; count--) {
	    *lead_data++ = link_data++->slip;
	}

	status = file_aime(node_data, output, input);

	count = class;
	for (; count; count--) {
	    link_data--;
	    link_data->slip = *--lead_data;
	}

	excess = shuffle_data->m.free(shuffle_data->m.data, data);
	if (excess) {
	    if (status) {
	    } else {
		status = _x1f4_a1_stat_free(shuffle_data);
	    }
	}
    }

    return status;
}


static int
line_aime(struct a1_node_type *node_data, void *output, void **input)
{
    int status;
    unsigned count;

    count = node_data->linetext.function.count;
    if (count) {
	status = lead_aime(node_data, output, input, count);
    } else {
	status = file_aime(node_data, output, input);
    }

    return status;
}


static int
link_aime(struct a1_node_type *node_data, void *output, void **input,
	  void *mirror)
{
    int status;

    if (1) {
	struct a1_link_type *link_data;

	link_data = node_data->link_data;
	if (link_data) {
	    if (node_data->depth) {
		status = pipe_line(node_data, link_data, input, mirror);
	    } else {
		status = type_line(node_data, link_data, input);
	    }
	    if (status) {
	    } else {
		int excess;

		status = long_aime(node_data, output, input);

		excess = text_line(node_data, link_data);
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	} else {
	    if (node_data->depth) {
		status = pipe_side(node_data, input, mirror);
	    } else {
		status = type_side(node_data, input);
	    }
	    if (status) {
	    } else {
		int excess;

		status = long_aime(node_data, output, input);

		excess = text_side(node_data);
		if (excess) {
		    if (status) {
		    } else {
			status = excess;
		    }
		}
	    }
	}
    }

    return status;
}


static int
long_aime(struct a1_node_type *node_data, void *output, void **input)
{
    int *note, status;
    struct a1_node_type *fail_node;
    struct a1_shuffle_type *shuffle_data;

    shuffle_data = node_data->link;

    fail_node = shuffle_data->fail_node;

    shuffle_data->fail_node = node_data;

    node_data->depth++;

    note = shuffle_data->z.note;
    if (note) {
	status = x1f4_long_program
	    (node_data->aime, note,
	     shuffle_data->z.back, shuffle_data->z.call, output);
    } else {
	status = x1f4_ever_program(node_data->aime, output);
    }
    if (status) {
	x1f4_flat_program(node_data->aime);
    }

    node_data->depth--;

    shuffle_data->fail_node = fail_node;

    return status;
}


static int
miss_line(struct a1_shuffle_type *shuffle_data,
	  struct a1_link_type *link_data, unsigned count)
{
    int status = 0;

    if (1) {
	void *subtext[2];

	subtext[1] = shuffle_data;

	for (; count; count--) {
	    int (*miss) (void **, struct a1_link_type *);

	    link_data--;

	    miss = link_data->miss;
	    if (miss) {
		status = miss(subtext, link_data);
		if (status) {
		    if (1) {
			break;
		    }
		}
	    }
	}
    }

    return status;
}


static int
near_aime(struct a1_node_type *node_data, void *output, void **input)
{
    int status;

    if (node_data->depth) {
	status = line_aime(node_data, output, input);
    } else {
	status = link_aime(node_data, output, input, NULL);
    }

    return status;
}


static int
pipe_aime(struct a1_pipe_type *pipe_data, struct a1_node_type *node_data,
	  void *context, void *output, void **input)
{
    int status;

    do {
	status = pipe_data->pass.fast
	    (pipe_data->pass.text, &node_data->linetext.function);
	if (status) {
	    status = X1f4_EX_CANNOT_CONTINUE;
	    break;
	}

	pipe_data = pipe_data->pipe_long;
    } while (pipe_data);
    if (pipe_data) {
    } else {
	int excess;

	status = near_aime(node_data, output, input);

	pipe_data = ((struct a1_shuffle_type *) node_data->link)->back_pipe;

	do {
	    excess = pipe_data->pass.lose
		(pipe_data->pass.text, &node_data->linetext.function);
	    if (excess) {
		status = X1f4_EX_CANNOT_CONTINUE;
		break;
	    }

	    pipe_data = pipe_data->back_pipe;
	} while (pipe_data);
    }
    if (pipe_data) {
	pipe_data = pipe_data->back_pipe;
	while (pipe_data) {
	    pipe_data->pass.back
		(pipe_data->pass.text, &node_data->linetext.function);
	    pipe_data = pipe_data->back_pipe;
	}
    }

    return status;
}


static int
pipe_line(struct a1_node_type *node_data, struct a1_link_type *link_data,
	  void **input, void *mirror)
{
    int status = 0;

    if (1) {
	unsigned count;
	void *subtext[4];

	subtext[1] = NULL;
	subtext[2] = node_data;
	subtext[3] = mirror;

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*line) (void **, void **, struct a1_link_type *);

	    line = link_data->line;
	    if (line) {
		status = line(subtext, input, link_data);
		if (status) {
		    miss_line
			(node_data->link, link_data,
			 node_data->linetext.function.count - count);
		    if (1) {
			break;
		    }
		}
	    } else {
		copy_link(link_data, *input);
	    }

	    input++;

	    link_data++;
	}
    }

    if (status) {
    } else {
	status = pipe_side(node_data, input, mirror);
	if (status) {
	    text_line(node_data, node_data->link_data);
	}
    }

    return status;
}


static int
pipe_side(struct a1_node_type *node_data, void **input, void *mirror)
{
    int status = 0;

    if (node_data->linetext.function.function == _x1f4_a1_side_aime) {
	struct a1_shuffle_type *shuffle_data;
	const struct x1f4_function_type *function_data;
	unsigned prefix, offset;

	shuffle_data = node_data->link;

	function_data = shuffle_data->s.function_data;

	prefix = node_data->linetext.function.count;

	offset = function_data->count - prefix;
	if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
	    status = _x1f4_a1_lead_slip
		(shuffle_data, input - prefix, node_data->link_data,
		 function_data, &node_data->linetext.function, node_data->aime,
		 mirror);
	    if (status) {
		offset = 0;
	    } else {
	    }
	}
	if (offset) {
	    void *line;

	    status = _x1f4_a1_lead_side
		(shuffle_data, offset, input - prefix, prefix, &line,
		 function_data, node_data->aime, mirror);
	    if (status) {
		if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
		    _x1f4_a1_slip_slip
			(shuffle_data, node_data->link_data, -1, function_data,
			 &node_data->linetext.function);
		}
	    } else {
		shuffle_data->s.lead = line;
	    }
	} else {
	    shuffle_data->s.lead = NULL;
	}
    }

    return status;
}


static int
text_line(struct a1_node_type *node_data, struct a1_link_type *link_data)
{
    int status;

    status = text_side(node_data);

    if (1) {
	unsigned count;
	void *subtext[2];

	subtext[1] = node_data->link;

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*miss) (void **, struct a1_link_type *);

	    miss = link_data->miss;
	    if (miss) {
		status = miss(subtext, link_data);
		if (status) {
		    if (1) {
			break;
		    }
		}
	    }

	    link_data++;
	}
    }

    return status;
}


static int
text_side(struct a1_node_type *node_data)
{
    int status = 0;

    if (node_data->linetext.function.function == _x1f4_a1_side_aime) {
	struct a1_shuffle_type *shuffle_data;
	const struct x1f4_function_type *function_data;
	void *line;

	shuffle_data = node_data->link;

	function_data = shuffle_data->s.function_data;

	line = shuffle_data->s.lead;
	if (line) {
	    unsigned prefix, offset;

	    prefix = node_data->linetext.function.count;

	    offset = function_data->count - prefix;

	    status = _x1f4_a1_slip_side
		(shuffle_data, prefix, offset, line, function_data);
	}
	if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
	    int excess;

	    excess = _x1f4_a1_slip_slip
		(shuffle_data, node_data->link_data, -1, function_data,
		 &node_data->linetext.function);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    return status;
}


static int
type_line(struct a1_node_type *node_data, struct a1_link_type *link_data,
	  void **input)
{
    int status = 0;

    if (1) {
	unsigned count;
	void *subtext[4];

	subtext[1] = NULL;
	subtext[2] = node_data;
	subtext[3] = NULL;

	count = node_data->linetext.function.count;
	for (; count; count--) {
	    int (*line) (void **, void **, struct a1_link_type *);

	    line = link_data->line;
	    if (line) {
		status = line(subtext, input, link_data);
		if (status) {
		    miss_line
			(node_data->link, link_data,
			 node_data->linetext.function.count - count);
		    if (1) {
			break;
		    }
		}
	    } else {
		copy_link(link_data, *input);
	    }

	    input++;

	    link_data++;
	}
    }

    if (status) {
    } else {
	status = type_side(node_data, input);
	if (status) {
	    text_line(node_data, node_data->link_data);
	}
    }

    return status;
}


static int
type_side(struct a1_node_type *node_data, void **input)
{
    int status = 0;

    if (node_data->linetext.function.function == _x1f4_a1_side_aime) {
	struct a1_shuffle_type *shuffle_data;
	const struct x1f4_function_type *function_data;
	unsigned prefix, offset;

	shuffle_data = node_data->link;

	function_data = shuffle_data->s.function_data;

	prefix = node_data->linetext.function.count;

	offset = function_data->count - prefix;
	if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
	    status = _x1f4_a1_lead_slip
		(shuffle_data, input - prefix, node_data->link_data,
		 function_data, &node_data->linetext.function, NULL, NULL);
	    if (status) {
		offset = 0;
	    } else {
	    }
	}
	if (offset) {
	    void *line;

	    status = _x1f4_a1_lead_side
		(shuffle_data, offset, input - prefix, prefix, &line,
		 function_data, NULL, NULL);
	    if (status) {
		if (node_data->linetext.function.flags & X1f4_E4_SLIP_LIST) {
		    _x1f4_a1_slip_slip
			(shuffle_data, node_data->link_data, -1, function_data,
			 &node_data->linetext.function);
		}
	    } else {
		shuffle_data->s.lead = line;
	    }
	} else {
	    shuffle_data->s.lead = NULL;
	}
    }

    return status;
}


int
_x1f4_a1_link_aime(void *context, void *output, void **input)
{
    int status;
    struct a1_node_type *node_data;
    struct a1_pipe_type *pipe_data;

    node_data = context;

    pipe_data = ((struct a1_shuffle_type *) node_data->link)->pipe_long;
    if (pipe_data) {
	status = pipe_aime(pipe_data, node_data, context, output, input);
    } else {
	status = near_aime(node_data, output, input);
    }

    return status;
}
