/*
 * a1-types.h
 * Copyright (C) 2006, 2007, 2008, 2009, 2010, 2011, 2012, Ciprian Niculescu
 * Copyright (C) 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_a1_TYPES_H__
#define __LIBx1f4_a1_TYPES_H__

#include <c1.h>
#include <e4jack.h>

#define HERE_A1_C_WIND			void *

typedef struct a1_back_type {
    const char *line;
    struct {
	int (*rule) (void *, unsigned, unsigned);
	void *data;
    } hint;
    union {
	struct {
	    x1f4_c1record_type c1record;
	} c_syntax;
	struct {
	    unsigned size;
	} flattype;
	struct {
	    x1f4_ejrecord_type ejrecord;
	} higherof;
	struct {
	    unsigned size;
	} lesslink;
	struct {
	    int type;
	} maintype;
	struct {
	    int type;
	} misslead;
	struct {
	    const char *fast;
	    union {
		struct {
		    unsigned name;
		} namecall;
		struct {
		    int slip, type;
		    unsigned name;
		} nametype;
		struct {
		    int slip, type;
		} sliptype;
	    } data;
	    unsigned code, size;
	} missline;
	struct {
	    unsigned size;
	} misslink;
	struct {
	    unsigned size;
	} missname;
	struct {
	    unsigned size;
	} misstype;
	struct {
	    const char *fast;
	    unsigned size;
	} postfeat;
	struct {
	    unsigned size;
	} reserved;
	struct {
	    int type;
	} sideline;
	struct {
	    unsigned size;
	} xdefined;
    } data;
    unsigned code, pick;
} a1_back_type;

typedef struct a1_context_type {
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } call_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	int (*fix) (const void *, const struct x1f4_function_type *, void **),
	    (*get) (const char *, unsigned, const void *,
		    const struct x1f4_function_type **);
	const void *context;
    } last_0;
    struct {
	const void *context;
    } ever_0;
    struct {
	int type;
    } link_g;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_operator_type **);
	const void *context;
    } trap_0;
    struct {
	int (*get) (const void *, int, int,
		    const struct x1f4_linetext_type **);
	const void *context;
    } turn_0;
    struct {
	void *back;
    } link_e;
    struct {
	void *fine;
    } link_i;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *data;
    } near_f;
    struct {
	const void *miss;
    } user_w;
    struct {
	const void *miss;
    } user_z;
    struct {
	int (*link) (void *, void **, unsigned);
	void *data;
    } were_f;
    const struct x1f4_operator_type **operator1s, **operator2s;
} a1_context_type;

typedef struct a1_fast_type {
    struct a1_fast_type *fast_data;
    struct x1f4_dispatch_type *dispatch_data;
    void *dispatched_output;
} a1_fast_type;

typedef struct a1_flat_type {
    struct a1_flat_type *flat_data;
} a1_flat_type;

typedef struct a1_lead_type {
    union {
	X1f4_E4_C_MODE mode;
	X1f4_E4_C_REAL real;
	X1f4_E4_C_TEXT text;
	X1f4_E4_C_USER user;
	HERE_A1_C_WIND wind;
    } data;
} a1_lead_type;

typedef struct a1_link_type {
    int (*line) (void **, void **, struct a1_link_type *),
	(*miss) (void **, struct a1_link_type *);
    struct a1_lead_type slip;
    struct x1f4_datatext_type datatext;
    struct x1f4_variable_type variable;
} a1_link_type;

typedef struct a1_lock_type {
    struct a1_fast_type *fast_head, *fast_tail;
    struct a1_lock_type *lock_data;
    struct a1_node_type *fail_node, *node_data;
    struct x1f4_c1node_type *c1node_deck;
    struct x1f4_dispatch_type *dispatch_data;
    const struct x1f4_function_type *function_data, *function_lead;
    void *dispatched_output, *lead, *output, *port, *post, *side, *slip;
} a1_lock_type;

typedef struct a1_node_type {
    struct a1_link_type *link_data;
    struct a1_node_type *node_data;
    struct x1f4_linetext_type linetext;
    unsigned class, depth, offset;
    void *aime, *link;
} a1_node_type;

typedef struct a1_pass_type {
    int (*back) (void *, const struct x1f4_function_type *),
	(*fast) (void *, const struct x1f4_function_type *),
	(*lose) (void *, const struct x1f4_function_type *);
    void *text;
} a1_pass_type;

typedef struct a1_pipe_type {
    struct a1_pass_type pass;
    struct a1_pipe_type *back_pipe, *pipe_long;
} a1_pipe_type;

/*
 * the _main_ function is pointed to by _slip_node_
 * maybe this attribute should be removed and have the _main_ function
 * pointed to by the first in the _node_data_ linked list
 */
typedef struct a1_shuffle_type {
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } m;
    struct {
	int type;
    } r;
    struct {
	const struct x1f4_function_type *function_data;
	void *lead;
    } s;
    struct {
	const struct x1f4_datatype_type *datatype_data, *sidetype_data;
    } u;
    struct {
	int (*link) (void *, void **, unsigned);
	void *text;
    } v;
    struct {
	int (*line) (void *), (*post) (void *),
	    (*push) (void *, const char *, unsigned);
	void *data;
    } x;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } y;
    struct {
	int (*call) (void *), *note;
	void *back;
    } z;
    struct a1_flat_type *flat_data;
    struct a1_node_type *fail_node, *node_data, *slip_node;
    struct a1_pipe_type *back_pipe, *pipe_long;
    struct x1f4_stateset_type stateset;
    void *fine;
} a1_shuffle_type;

typedef struct a1_trans19_type {
    struct {
	void *deck, *lock, *port, *slip;
    } e;
    struct {
	struct a1_shuffle_type *shuffle_data;
    } f;
} a1_trans19_type;

#endif				/* __LIBx1f4_a1_TYPES_H__ */
