/*
 * a1-parse.h
 * Copyright (C) 2006-2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_a1_PARSE_H__
#define __LIBx1f4_a1_PARSE_H__

#include <a1-types.h>
#include <c1.h>
#include <trans.h>

#define ANONYMOUS_LIST			(1L << 0)
#define EXTENSION_LIST			(1L << 1)
#define REDUCTION_LIST			(1L << 2)
#define REFERENCE_LIST			(1L << 3)

typedef struct a1_parser_type {
    const char *name, *shuffle, *thirteen;
    int (*fix) (const void *, const struct x1f4_function_type *, void **),
	(*get) (const char *, unsigned, const void *,
		const struct x1f4_function_type **), half_expect, lead, main,
	type;
    struct a1_back_type *back_data;
    struct a1_link_type *link_data, *post_link;
    struct a1_node_type *node_data, *node_text;
    struct a1_shuffle_type *shuffle_data;
    struct trans_type m;
    struct x1f4_c1_type c1;
    const struct x1f4_datatype_type *datatype_data, *sidetype_data;
    const struct x1f4_linetext_type *linetext_data;
    unsigned c1_flags, flags, length, offset, undefined, v_flags;
    void *e4fine, *function_tree, *variable_tree, (*slip) (const char **);
    const void *context, *subtext;
} a1_parser_type;

#endif				/* __LIBx1f4_a1_PARSE_H__ */
