/*
 * tf13.c
 * Copyright (C) 2002-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined HAVE_FEATURES_H
# include <features.h>
#endif				/* HAVE_FEATURES_H */

#include <getopt.h>
#if defined HAVE_LIBx1f4l0
# include <libx1f4l0.h>
#endif				/* HAVE_LIBx1f4l0 */
#include <signal.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/wait.h>

#include <aime.h>
#if !defined HAVE_LIBx1f4i0
# include <integral.v-d.h>
#endif				/* !HAVE_LIBx1f4i0 */
#include <inter.h>
#include <types.h>

/*
 * The SLIP pass loses the return of main.
 */
#define __NOTE_PASS__			1
#define __SLIP_PASS__			2

#define __AIME_PASS__			__NOTE_PASS__

#define ____AIME_PASS__			__AIME_PASS__

#define __ROLL_VALIST__			1

#if defined HAVE_LIBx1f4l0
#else
# undef __ROLL_VALIST__
# define __ROLL_VALIST__		0
#endif				/* HAVE_LIBx1f4l0 */

/*
 * this one seems ruined (since introduction of the `file' type)
 */
#define __CLASS_DEBUG__			0

#define DATA_LINK \
    X1f4_LXDATA_EVERLINK

#define DATA_BITS \
    DATA_LINK | X1f4_LXDATA_TEXTFLAT

#define DATE_LINK \
    X1f4_LXDATE_EVERLINK

#define DATE_BITS \
    DATE_LINK | X1f4_LXDATE_TEXTFLAT

#define FILE_LINK \
    X1f4_LXFILE_DATALINK | X1f4_LXFILE_EVERLINK | X1f4_LXFILE_LISTLINK

#define FILE_BITS \
    FILE_LINK | X1f4_LXFILE_SETCLOSE | X1f4_LXFILE_TEXTFLAT

#define LINE_LINK \
    X1f4_LXLINE_CASTTYPE | X1f4_LXLINE_EVERLINK | X1f4_LXLINE_RESETNEW

#define LINE_BITS \
    LINE_LINK | X1f4_LXLINE_TEXTFLAT

#define LIST_LINK \
    X1f4_LXLIST_CASTTYPE | X1f4_LXLIST_EVERLINK | X1f4_LXLIST_RESETNEW

#define LIST_BITS \
    LIST_LINK | X1f4_LXLIST_TEXTFLAT

#define PORT_LINK \
    X1f4_LXPORT_EVERLINK

#define PORT_BITS \
    PORT_LINK | X1f4_LXPORT_SETCLOSE | X1f4_LXPORT_TEXTFLAT

#define C113_BITS \
    X1f4_C1_BCOLLECT | X1f4_C1_COMPOSER | X1f4_C1_DDACCESS | X1f4_C1_IMPLICIT \
    | X1f4_C1_SCOMMENT | X1f4_C1_SIDELIST | X1f4_C1_TRANSFER

#define A113_BITS \
    X1f4_A1_BCOLLECT | X1f4_A1_COMPOSER | X1f4_A1_DDACCESS | X1f4_A1_IMPLICIT \
    | X1f4_A1_SCOMMENT | X1f4_A1_SIDELIST | X1f4_A1_TRANSFER

#define HERE_13_DATA			(X1f4_E4_LAST + 1)
#define HERE_13_DATE			(X1f4_E4_LAST + 2)
#define HERE_13_DECQ			(X1f4_E4_LAST + 3)
#define HERE_13_FILE			(X1f4_E4_LAST + 4)
#define HERE_13_LIST			(X1f4_E4_LAST + 5)
#define HERE_13_TIME			(X1f4_E4_LAST + 6)

#define HERE_13_SIX			(X1f4_E4_LAST + 7)

#define HERE_13_RECORD			(X1f4_E4_LAST + 7)
#define HERE_13_SSHELL			(X1f4_E4_LAST + 8)
#define HERE_13_XSHELL			(X1f4_E4_LAST + 9)

#define LIST_13_DATA			0
#define LIST_13_DATE			1
#define LIST_13_DECQ			2
#define LIST_13_FILE			3
#define LIST_13_LINE			4
#define LIST_13_LIST			5
#define LIST_13_TIME			6

#define LIST_13_SSHELL			7
#define LIST_13_XSHELL			8

#define LIST_13_NULL			9

#define LIST_13_SIZE			10

#define LIST_TYPES			4

#define NODE_TYPES			(LIST_TYPES + LIST_13_NULL)

#define MAKE_SINGLE(a, b)		a

#define I_BILL(b)			(*((X1f4_E4_C_BILL *) (b)))
#define I_MODE(i)			(*((X1f4_E4_C_MODE *) (i)))
#define I_REAL(r)			(*((X1f4_E4_C_REAL *) (r)))
#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))
#define I_USER(u)			(*((X1f4_E4_C_USER *) (u)))

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_REAL(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

typedef X1f4_E4_C_TEXT e4_c_text;

typedef struct context_type {
    char **argv;
    const char *program, *self;
    int argc, class, (*deck) (void **), disallow_comments, do_memory,
	do_optimize, do_print, do_storage, do_trace, error, exit, immediate,
	(*line) (struct context_type *, unsigned *);
    struct {
	int (*link) (void *, void **, unsigned),
	    (*pick) (void *, void ***, int (*) (void *), unsigned, void **);
	void *text;
    } autolink;
#if __ROLL_VALIST__
    struct list_type dlist;
#endif				/* __ROLL_VALIST__ */
    struct x1f4_datatype_type typelist[LIST_13_SIZE];
    struct x1f4_e2line_type e2line;
    const struct x1f4_function_type *function_slip;
    const struct x1f4_linetext_type *linetext_data;
    struct x1f4_trans_type trans;
    unsigned call;
    void *context, *dtlist, *e4deck, *e4fine, *e4less, *fsdeck, *driver_fringe,
	*logic, *lxdata, *lxdate, *lxdecq, *lxfile, *lxline, *lxlist, *lxnear,
	*lxport, *lxtext, *object_fringe;
#if __ROLL_VALIST__
    void *valist;
#endif				/* __ROLL_VALIST__ */
    const void *data;
} context_type;

typedef struct fringe_type {
    struct fringe_type *fringe_data;
    struct x1f4_linetext_type linetext;
} fringe_type;

typedef struct upcast_type {
    struct x1f4_datatype_type *datatype_data;
    struct x1f4_dxcast_type dxcast;
} upcast_type;

typedef struct window_type {
    int (*fini) (struct context_type *), (*init) (struct context_type *);
} window_type;

static int c19xx_f_f(void *, void **);
static int c19xx_t_t(void *, void **);
static int case_window(struct context_type *);
static int cfix_lxdecq(struct context_type *);
static int cfix_lxline(struct context_type *);
static int cfix_lxlist(struct context_type *);
static int copy_error(void *, const char *, unsigned);
static int copy_output(void *, const char *, unsigned);
static int d19xx_b__(void *, void **);
static int d19xx_m__(void *, void **);
static int d19xx_r__(void *, void **);
static int d19xx_t__(void *, void **);
static int dfix_lxfile(struct context_type *);
static int dumb_mode(void *, void *, void **);
#if 0
static int ever_list(void *, void *, struct x1f4_variable_type *);
#endif				/* 0 */
static int fast_call(void *, const struct x1f4_function_type *);
static int fini_dtlist(struct context_type *);
static int fini_e4fine(struct context_type *);
static int fini_e4less(struct context_type *);
static int fini_fsdeck(struct context_type *);
static int fini_lxdata(struct context_type *);
static int fini_lxdate(struct context_type *);
static int fini_lxdecq(struct context_type *);
static int fini_lxfile(struct context_type *);
static int fini_lxline(struct context_type *);
static int fini_lxlist(struct context_type *);
static int fini_lxnear(struct context_type *);
static int fini_lxport(struct context_type *);
static int fini_lxtext(struct context_type *);
static int fini_tf13(struct context_type *);
static int fini_valist(struct context_type *);
static int fix_logic(struct context_type *, unsigned, void *,
		     const char *, const void *);
#if __CLASS_DEBUG__
static int flat_List(void *, void *, void **);
#endif				/* __CLASS_DEBUG__ */
#if __AIME_PASS__ == __NOTE_PASS__
static int flat_text(void *);
#endif				/* __AIME_PASS__ == __NOTE_PASS__ */
static int flush_error(struct context_type *, const char *);
static int init_dtlist(struct context_type *);
static int init_e4fine(struct context_type *);
static int init_e4less(struct context_type *);
static int init_fsdeck(struct context_type *);
static int init_lvfile(struct context_type *);
static int init_lxdata(struct context_type *);
static int init_lxdate(struct context_type *);
static int init_lxdecq(struct context_type *);
static int init_lxfile(struct context_type *);
static int init_lxline(struct context_type *);
static int init_lxlist(struct context_type *);
static int init_lxnear(struct context_type *);
static int init_lxport(struct context_type *);
static int init_lxtext(struct context_type *);
static int init_tf13(struct context_type *);
static int init_trans(struct context_type *);
static int init_valist(struct context_type *);
#if __CLASS_DEBUG__
static int line_List(void *, void *, void **);
#endif				/* __CLASS_DEBUG__ */
static int line_driver(void *, void *, void **);
static int line_flat(void *);
static int line_object(void *, void *, void **);
static int line_program(struct context_type *, unsigned *);
#if __AIME_PASS__ == __SLIP_PASS__
static int line_shuffle(struct context_type *, unsigned *);
#endif				/* __AIME_PASS__ == __SLIP_PASS__ */
#if __CLASS_DEBUG__
static int link_List(void *, void *, void **);
#endif				/* __CLASS_DEBUG__ */
static int link_dtlist(struct context_type *);
static int link_types(struct x1f4_nodetype_type *);
static int list_text(void *, const void *);
static int lock_composer(void *, int, int, const struct x1f4_linetext_type **);
static int lock_implicit(void *, int, int, const struct x1f4_operator_type **);
static int look_type(const void *, int, const char **, unsigned *);
static int lose_call(void *, const struct x1f4_function_type *);
static int merge_operators(const struct x1f4_operator_type *const **,
			   const struct x1f4_operator_type *const *,
			   const struct x1f4_operator_type *const *, unsigned);
static int mode_argc(void *, void *, void **);
static int o19xb_o__(void *, void **);
static int o19xm_o__(void *, void **);
static int o19xr_o__(void *, void **);
static int o19xt_o__(void *, void **);
static int pick_object(void *, void *, void **);
#if __AIME_PASS__ == __NOTE_PASS__
static int pick_shuffle(struct context_type *, unsigned *);
#endif				/* __AIME_PASS__ == __NOTE_PASS__ */
static int pipe_shuffle(struct context_type *, void *);
static int post_flat(void *);
static int push_flat(void *, const char *, unsigned);
static int rule_fset(struct context_type *, const struct x1f4_function_type *);
static int rule_lset(struct context_type *, const struct x1f4_linetext_type *);
static int run_logic(struct context_type *, unsigned, void *,
		     const char *, const void *);
static int seek_driver(struct context_type *, int,
		       const struct x1f4_linetext_type **);
static int seek_line(struct context_type *, unsigned, unsigned *);
static int seek_object(struct context_type *, int,
		       const struct x1f4_linetext_type **);
static int select_context(const void *, const struct x1f4_function_type *,
			  void **);
static int select_logic(const char *, unsigned, const void *,
			const struct x1f4_function_type **);
static int set_logic(struct context_type *, unsigned, void *,
		     const char *, const void *);
static int slip_object(void *);
static int stat_argv(void *, int);
static int stat_type(struct context_type *, int, int);
static int test_cast(void *, const char *, unsigned);
static int tempt_logic(struct context_type *, int, char **);
static int text_argv(void *, void *, void **);
static int type_13list(struct context_type *);
static int type_lxfile(struct context_type *);
static int type_lxport(struct context_type *);
static int wait_some(struct context_type *);

static void SIGCHLD_handler(int);
static void free_fringe(struct fringe_type *);
static void list_0010(struct context_type *);
static void list_0011(void);
static void list_0012(struct context_type *);
static void list_0013(void);
static void list_0014(void);
static void list_0015(void);
static void list_0016(void);
static void list_0017(struct context_type *);
static void list_0022(struct context_type *, void *);
static void list_0023(struct context_type *);
static void list_0111(void);
static void list_0220(void);
static void list_0223(void);
static void usage(void);

#if __AIME_PASS__ == __NOTE_PASS__
static int *static_class;
#endif				/* __AIME_PASS__ == __NOTE_PASS__ */
static const int c_____b__[] = {
/* *INDENT-OFF* */
    X1f4_E4_BILL
/* *INDENT-ON* */
}, c_____f_f[] = {
/* *INDENT-OFF* */
    X1f4_E4_CALL,
    X1f4_E4_CALL
/* *INDENT-ON* */
}, c_____m__[] = {
/* *INDENT-OFF* */
    X1f4_E4_MODE
/* *INDENT-ON* */
}, c_____o__[] = {
/* *INDENT-OFF* */
    X1f4_E4_OBJECT
/* *INDENT-ON* */
}, c_____r__[] = {
/* *INDENT-OFF* */
    X1f4_E4_REAL
/* *INDENT-ON* */
}, c_____t__[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT
/* *INDENT-ON* */
}, c_____t_t[] = {
/* *INDENT-OFF* */
    X1f4_E4_TEXT,
    X1f4_E4_TEXT
/* *INDENT-ON* */
};
static sig_atomic_t SIGCHLD_received;
static const struct window_type riddle[] = {
/* *INDENT-OFF* */
    {	fini_valist,		init_valist			},
    {	fini_dtlist,		init_dtlist			},
    {	case_window,		link_dtlist			},
    {	fini_e4less,		init_e4less			},
    {	fini_fsdeck,		init_fsdeck			},
    {	fini_e4fine,		init_e4fine			},
    {	fini_lxdata,		init_lxdata			},
    {	fini_lxdate,		init_lxdate			},
    {	fini_lxdecq,		init_lxdecq			},
    {	fini_lxfile,		init_lvfile			},
    {	fini_lxline,		init_lxline			},
    {	fini_lxlist,		init_lxlist			},
    {	fini_lxnear,		init_lxnear			},
    {	fini_lxport,		init_lxport			},
    {	fini_lxtext,		init_lxtext			},
    {	case_window,		cfix_lxdecq			},
    {	case_window,		cfix_lxline			},
    {	case_window,		cfix_lxlist			},
    {	case_window,		dfix_lxfile			},
    {	case_window,		type_lxfile			},
    {	case_window,		type_lxport			},
    {	case_window,		type_13list			}
/* *INDENT-ON* */
};
static const struct x1f4_datapipe_type long_pipes[] = {
/* *INDENT-OFF* */
    {	"f",		x1f4_pipe_lxfile,
	HERE_13_FILE,				1,	NULL	}
/* *INDENT-ON* */
};
#if __CLASS_DEBUG__
static const struct x1f4_datatype_type class_datatypes[] = {
/* *INDENT-OFF* */
    {	"list",		flat_List,		line_List,
	link_List,	HERE_13_LIST,		4,
	NULL							},
    {	NULL,		NULL,			NULL,
	NULL,		0,			0,
	NULL							}
/* *INDENT-ON* */
};
#endif				/* __CLASS_DEBUG__ */
static const struct x1f4_datatype_type parameter_datatypes[] = {
/* *INDENT-OFF* */
    {	"object",		NULL,		NULL,
	NULL,			NULL,
	NULL,			NULL,
	X1f4_E4_OBJECT,		6,		NULL		},
    {	NULL,			NULL,		NULL,
	NULL,			NULL,
	NULL,			NULL,
	0,			0,		NULL		}
/* *INDENT-ON* */
};
static const struct x1f4_function_type command_set[] = {
/* *INDENT-OFF* */
    {	"argc",			mode_argc,
	X1f4_E4_MODE,		NULL,		0,
	X1f4_E4_KEEP_CALL,			4		},
    {	"argv",			text_argv,
	X1f4_E4_TEXT,		c_____m__,	1,
	X1f4_E4_KEEP_CALL,			4		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
}, t13_set[] = {
/* *INDENT-OFF* */
    {	"exit",			dumb_mode,
	X1f4_E4_VOID,		c_____m__,	1,
	X1f4_E4_KEEP_CALL,			4		},
    {	NULL,			NULL,
	0,			NULL,		0,
	0,					1		}
/* *INDENT-ON* */
};
static const struct x1f4_nodetype_type list_types[] = {
/* *INDENT-OFF* */
    {	"cardinal",	NULL,		X1f4_E4_BILL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,
	0,		8,			NULL		},
    {	"integer",	NULL,		X1f4_E4_MODE,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,
	0,		7,			NULL		},
    {	"real",		NULL,		X1f4_E4_REAL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,
	0,		4,			NULL		},
    {	"text",		NULL,		X1f4_E4_TEXT,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,		NULL,			NULL,
	NULL,
	0,		4,			NULL		}
/* *INDENT-ON* */
};
static const struct x1f4_operator_type driver_implicit[] = {
/* *INDENT-OFF* */
    {	"(cardinal) ",		d19xx_b__,	0000,
	X1f4_E4_BILL,		c_____o__,
	0,			11,
	NULL,			NULL				},
    {	"(integer) ",		d19xx_m__,	0000,
	X1f4_E4_MODE,		c_____o__,
	0,			10,
	NULL,			NULL				},
    {	"(real) ",		d19xx_r__,	0000,
	X1f4_E4_REAL,		c_____o__,
	0,			7,
	NULL,			NULL				},
    {	"(text) ",		d19xx_t__,	0000,
	X1f4_E4_TEXT,		c_____o__,
	0,			7,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e19xx_f_f[] = {
/* *INDENT-OFF* */
    {	"=",			c19xx_f_f,	0400,
	X1f4_E4_CALL,		c_____f_f,
	X1f4_E4_CALL_XSET,	1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, e19xx_t_t[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  c19xx_t_t,	0400,
	X1f4_E4_TEXT,		c_____t_t,
	X1f4_E4_LEFT_XSET,	1,
	NULL,			NULL				}
/* *INDENT-ON* */
}, object_implicit[] = {
/* *INDENT-OFF* */
    {	"(object) ",		o19xb_o__,	0000,
	X1f4_E4_OBJECT,		c_____b__,
	0,			7,
	NULL,			NULL				},
    {	"(object) ",		o19xm_o__,	0000,
	X1f4_E4_OBJECT,		c_____m__,
	0,			7,
	NULL,			NULL				},
    {	"(object) ",		o19xr_o__,	0000,
	X1f4_E4_OBJECT,		c_____r__,
	0,			7,
	NULL,			NULL				},
    {	"(object) ",		o19xt_o__,	0000,
	X1f4_E4_OBJECT,		c_____t__,
	0,			7,
	NULL,			NULL				}
/* *INDENT-ON* */
}, *tf13_e4_2_arithmetics[] = {
/* *INDENT-OFF* */
    e19xx_f_f,
    e19xx_t_t
/* *INDENT-ON* */
};
static const struct x1f4_textpipe_type near_pipes[] = {
/* *INDENT-OFF* */
    {	"o",		copy_output,		1,	NULL	},
    {	"v",		copy_error,		1,	NULL	}
/* *INDENT-ON* */
};
static void *static_context, *static_text;

static int
c19xx_f_f(void *output, void **input)
{
    X1f4_E4_C_USER user;

    user = I_USER(input[1]);

    l_USER(user, output);
    l_USER(user, input[0]);

    return 0;
}


static int
c19xx_t_t(void *output, void **input)
{
    e4_c_text text_0, text_1;
    int status;
    struct context_type *context_data;

    text_0 = I_TEXT(input[0]);
    text_1 = I_TEXT(input[1]);

    context_data = static_text;

    if (text_1 == x1f4_c1_empty_string) {
	l_TEXT(text_1, output);
	l_TEXT(text_1, input[0]);

	if (text_0 != x1f4_c1_empty_string) {
	    status = context_data->trans.free
		(context_data->trans.data, text_0);
	} else {
	    status = 0;
	}
    } else {
	unsigned length;
	void *string;

	length = strlen(text_1) + 1;

	status = context_data->trans.link
	    (context_data->trans.data, &string, length);
	if (status) {
	} else {
	    memcpy(string, text_1, length);

	    l_TEXT(string, output);
	    l_TEXT(string, input[0]);

	    if (text_0 != x1f4_c1_empty_string) {
		status = context_data->trans.free
		    (context_data->trans.data, text_0);
	    }
	}
    }

    return status;
}


static int
case_window(struct context_type *context_data)
{
    return 0;
}


static int
cfix_lxdecq(struct context_type *context_data)
{
    void *lxdecq;

    lxdecq = context_data->lxdecq;

    x1f4_cfix_lxdecq(lxdecq, LIST_13_DATA + LIST_TYPES, context_data->lxdata);
    x1f4_cfix_lxdecq(lxdecq, LIST_13_DATE + LIST_TYPES, context_data->lxdate);
    x1f4_cfix_lxdecq(lxdecq, LIST_13_DECQ + LIST_TYPES, lxdecq);
    x1f4_cfix_lxdecq(lxdecq, LIST_13_FILE + LIST_TYPES, context_data->lxfile);
    x1f4_cfix_lxdecq(lxdecq, LIST_13_LINE + LIST_TYPES, context_data->lxline);
    x1f4_cfix_lxdecq(lxdecq, LIST_13_LIST + LIST_TYPES, context_data->lxlist);
    x1f4_cfix_lxdecq(lxdecq, LIST_13_TIME + LIST_TYPES, context_data->lxdate);

    x1f4_cfix_lxdecq
	(lxdecq, LIST_13_SSHELL + LIST_TYPES, context_data->lxport);
    x1f4_cfix_lxdecq
	(lxdecq, LIST_13_XSHELL + LIST_TYPES, context_data->lxport);

    return 0;
}


static int
cfix_lxline(struct context_type *context_data)
{
    void *lxline;

    lxline = context_data->lxline;

    x1f4_cfix_lxline(lxline, LIST_13_DATA + LIST_TYPES, context_data->lxdata);
    x1f4_cfix_lxline(lxline, LIST_13_DATE + LIST_TYPES, context_data->lxdate);
    x1f4_cfix_lxline(lxline, LIST_13_DECQ + LIST_TYPES, context_data->lxdecq);
    x1f4_cfix_lxline(lxline, LIST_13_FILE + LIST_TYPES, context_data->lxfile);
    x1f4_cfix_lxline(lxline, LIST_13_LINE + LIST_TYPES, lxline);
    x1f4_cfix_lxline(lxline, LIST_13_LIST + LIST_TYPES, context_data->lxlist);
    x1f4_cfix_lxline(lxline, LIST_13_TIME + LIST_TYPES, context_data->lxdate);

    x1f4_cfix_lxline
	(lxline, LIST_13_SSHELL + LIST_TYPES, context_data->lxport);
    x1f4_cfix_lxline
	(lxline, LIST_13_XSHELL + LIST_TYPES, context_data->lxport);

    return 0;
}


static int
cfix_lxlist(struct context_type *context_data)
{
    void *lxlist;

    lxlist = context_data->lxlist;

    x1f4_cfix_lxlist(lxlist, LIST_13_DATA + LIST_TYPES, context_data->lxdata);
    x1f4_cfix_lxlist(lxlist, LIST_13_DATE + LIST_TYPES, context_data->lxdate);
    x1f4_cfix_lxlist(lxlist, LIST_13_DECQ + LIST_TYPES, context_data->lxdecq);
    x1f4_cfix_lxlist(lxlist, LIST_13_FILE + LIST_TYPES, context_data->lxfile);
    x1f4_cfix_lxlist(lxlist, LIST_13_LINE + LIST_TYPES, context_data->lxline);
    x1f4_cfix_lxlist(lxlist, LIST_13_LIST + LIST_TYPES, lxlist);
    x1f4_cfix_lxlist(lxlist, LIST_13_TIME + LIST_TYPES, context_data->lxdate);

    x1f4_cfix_lxlist
	(lxlist, LIST_13_SSHELL + LIST_TYPES, context_data->lxport);
    x1f4_cfix_lxlist
	(lxlist, LIST_13_XSHELL + LIST_TYPES, context_data->lxport);

    return 0;
}


static int
copy_error(void *none, const char *data, unsigned size)
{
    fwrite(data, size, 1, stderr);

    return 0;
}


static int
copy_output(void *none, const char *data, unsigned size)
{
    fwrite(data, size, 1, stdout);

    return 0;
}


static int
d19xx_b__(void *output, void **input)
{
    int status = 0;
    struct x1f4_dxcast_type *object_data;

    object_data = I_USER(input[0]);

    switch (object_data->type) {
    case X1f4_E4_BILL:
	l_BILL(I_BILL(&object_data->data), output);
	break;
    case X1f4_E4_MODE:
	l_BILL(I_MODE(&object_data->data), output);
	break;
    case X1f4_E4_REAL:
	l_BILL(I_REAL(&object_data->data), output);
	break;
    default:
	status = stat_type(static_text, X1f4_E4_BILL, object_data->type);
    }

    return status;
}


static int
d19xx_m__(void *output, void **input)
{
    int status = 0;
    struct x1f4_dxcast_type *object_data;

    object_data = I_USER(input[0]);

    switch (object_data->type) {
    case X1f4_E4_BILL:
	l_MODE(I_BILL(&object_data->data), output);
	break;
    case X1f4_E4_MODE:
	l_MODE(I_MODE(&object_data->data), output);
	break;
    case X1f4_E4_REAL:
	l_MODE(I_REAL(&object_data->data), output);
	break;
    default:
	status = stat_type(static_text, X1f4_E4_MODE, object_data->type);
    }

    return status;
}


static int
d19xx_r__(void *output, void **input)
{
    int status = 0;
    struct x1f4_dxcast_type *object_data;

    object_data = I_USER(input[0]);

    switch (object_data->type) {
    case X1f4_E4_BILL:
	l_REAL(I_BILL(&object_data->data), output);
	break;
    case X1f4_E4_MODE:
	l_REAL(I_MODE(&object_data->data), output);
	break;
    case X1f4_E4_REAL:
	l_REAL(I_REAL(&object_data->data), output);
	break;
    default:
	status = stat_type(static_text, X1f4_E4_REAL, object_data->type);
    }

    return status;
}


static int
d19xx_t__(void *output, void **input)
{
    int status;
    struct x1f4_dxcast_type *object_data;

    object_data = I_USER(input[0]);

    if (object_data->type ^ X1f4_E4_TEXT) {
	status = stat_type(static_text, X1f4_E4_TEXT, object_data->type);
    } else {
	status = 0;

	l_TEXT(I_TEXT(&object_data->data), output);
    }

    return status;
}


static int
dfix_lxfile(struct context_type *context_data)
{
    x1f4_dfix_lxnear(context_data->lxnear, 0, context_data->lxfile);

    return 0;
}


static int
dumb_mode(void *context, void *output, void **input)
{
    ((struct context_type *) context)->exit = I_MODE(input[0]) << 1 | 1;

    return 1;
}


#if 0
static int
ever_list(void *none, void *data, struct x1f4_variable_type *variable_data)
{
    puts(variable_data->name);

    return 0;
}
#endif				/* 0 */


static int
fast_call(void *context, const struct x1f4_function_type *function_data)
{
    struct context_type *context_data;
    unsigned call;

    context_data = context;

    call = context_data->call;

    call++;

    context_data->call = call;

    for (; call; call--) {
	fputs("    ", stderr);
    }

    fputs("<---- ", stderr);
    fputs(function_data->name, stderr);
    fputs(" ----\n", stderr);

    return 0;
}


static int
fini_dtlist(struct context_type *context_data)
{
    free(context_data->dtlist);

    return 0;
}


static int
fini_e4fine(struct context_type *context_data)
{
    return x1f4_fini_e4fine(&context_data->e4fine);
}


static int
fini_e4less(struct context_type *context_data)
{
    return x1f4_fini_e4ll(&context_data->e4less);
}


static int
fini_fsdeck(struct context_type *context_data)
{
    return x1f4_fini_mxdeck(&context_data->fsdeck);
}


static int
fini_lxdata(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxdata(&context_data->lxdata);

    return status;
}


static int
fini_lxdate(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxdate(&context_data->lxdate);

    return status;
}


static int
fini_lxdecq(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxdecq(&context_data->lxdecq);

    return status;
}


static int
fini_lxfile(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxfile(&context_data->lxfile);

    return status;
}


static int
fini_lxline(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxline(&context_data->lxline);

    return status;
}


static int
fini_lxlist(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxlist(&context_data->lxlist);

    return status;
}


static int
fini_lxnear(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxnear(&context_data->lxnear);

    return status;
}


static int
fini_lxport(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxport(&context_data->lxport);

    return status;
}


static int
fini_lxtext(struct context_type *context_data)
{
    int status;

    status = x1f4_fini_lxtext(&context_data->lxtext);

    return status;
}


static int
fini_tf13(struct context_type *context_data)
{
    int excess, status = 0;
    static const struct window_type *window_data;
    unsigned access;

    access = sizeof(riddle) / sizeof(struct window_type);

    window_data = riddle + access;

    for (; access; access--) {
	window_data--;
	excess = window_data->fini(context_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}


static int
fini_valist(struct context_type *context_data)
{
#if !__ROLL_VALIST__
# define status				0
#endif				/* !__ROLL_VALIST__ */

#if __ROLL_VALIST__
    int status = 0;
    void *valist;
#endif				/* __ROLL_VALIST__ */

#if __ROLL_VALIST__
    valist = context_data->valist;
    if (valist) {
	libx1f4i0_fini_valist
	    (context_data->self, valist, context_data->do_memory,
	     context_data->do_storage, &status);
	if (status) {
	} else {
	    if (context_data->do_memory) {
		fprintf(stderr, " %7u max allocation\n",
			context_data->dlist.ever);
	    }
	}
    }
#endif				/* __ROLL_VALIST__ */

    return status;

#if !__ROLL_VALIST__
# undef status
#endif				/* !__ROLL_VALIST__ */
}


static int
fix_logic(struct context_type *context_data, unsigned count,
	  void *state_data, const char *program, const void *data)
{
    int status;
    unsigned bits = 0;

    if (context_data->disallow_comments) {
    } else {
	bits |= X1f4_A1_SCOMMENT; 
    }

    {
	struct x1f4_frame_type frame;

	x1f4_copy_e4ll(context_data->e4less, &frame);

	context_data->autolink.link = frame.link;
	context_data->autolink.pick = frame.pick;
	context_data->autolink.text = frame.data;
    }

    context_data->driver_fringe = NULL;
    context_data->object_fringe = NULL;

    static_context = context_data;

    if (x1f4_peer_shuffle(data, bits)) {
	status = set_logic(context_data, count, state_data, program, data);
    } else {
	status = run_logic(context_data, count, state_data, program, data);
    }

    {
	void *fringe;

	fringe = context_data->driver_fringe;
	if (fringe) {
	    free_fringe(fringe);
	}
	fringe = context_data->object_fringe;
	if (fringe) {
	    free_fringe(fringe);
	}
    }

    return status;
}


#if __CLASS_DEBUG__
static int
flat_List(void *context, void *subtext, void **address)
{
    fputs("list down...\n", stderr);

    return ((const struct x1f4_datatype_type *) context)->flat
	(context, ((const struct x1f4_datatype_type *) context)->context,
	 address);
}
#endif				/* __CLASS_DEBUG__ */


#if __AIME_PASS__ == __NOTE_PASS__
static int
flat_text(void *context)
{
    int status;
    struct context_type *context_data;

    context_data = context;

    status = context_data->deck(&context_data->e4deck);

    if (SIGCHLD_received) {
	int excess;

	excess = wait_some(context_data);
	if (excess) {
	    if (status) {
	    } else {
		status = excess;
	    }
	}
    }

    return status;
}
#endif				/* __AIME_PASS__ == __NOTE_PASS__ */


static int
flush_error(struct context_type *context_data, const char *program)
{
    if (context_data->error) {
    } else {
	fflush(stdout);
	fprintf(stderr, "%s:", context_data->self);
	if (program) {
	    fprintf(stderr, " %s:", program);
	}
	if (1) {
	    int (*line) (struct context_type *, unsigned *);

	    line = context_data->line;
	    if (line) {
		unsigned copy, miss;

		line(context_data, &copy);
		seek_line(context_data, copy, &miss);
		fprintf(stderr, " %u:", miss + 1);
	    }
	}

	fprintf(stderr, " cannot execute program\n");
    }

    return 17;
}


static int
init_dtlist(struct context_type *context_data)
{
    int status;

    context_data->dtlist =
	malloc(sizeof(struct x1f4_nodetype_type) * NODE_TYPES);
    if (context_data->dtlist) {
	status = 0;
    } else {
	status = -1;
	perror(context_data->self);
    }

    return status;
}


static int
init_e4fine(struct context_type *context_data)
{
    return x1f4_init_e4fine(&context_data->e4fine, 0, NULL);
}


static int
init_e4less(struct context_type *context_data)
{
    int status;
    struct x1f4_e2line_type *e2line_data;
    struct x1f4_e4less_type e4line;
    void *e4less;

    e2line_data = &context_data->e2line;

    e2line_data->bits = X1f4_E2LIST_FLATLINE;

    e2line_data->e2list.flatline_set.class = &context_data->class;

#if __ROLL_VALIST__
    if (context_data->valist) {
	e2line_data->bits |= X1f4_E2LIST_MISSLINK;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &e2line_data->e2list.misslink_set.free,
	     &e2line_data->e2list.misslink_set.link,
	     &e2line_data->e2list.misslink_set.mode,
	     &e2line_data->e2list.misslink_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    e4line.misslink_set.data = e2line_data;

    x1f4_type_e2list(&e4line.misslink_set);

    status = x1f4_init_e4ll(&e4less, X1f4_E4LL_MISSLINK, &e4line);
    if (status) {
    } else {
	context_data->e4less = e4less;

	x1f4_deck_e4ll(e4less, &context_data->e4deck, &context_data->deck);
    }

    return status;
}


static int
init_fsdeck(struct context_type *context_data)
{
    int status;

    status = x1f4_init_mxdeck(&context_data->fsdeck, 0, NULL);
    if (status) {
    } else {
	rule_fset(context_data, t13_set);
	rule_fset(context_data, x1f4_e4_defaults);
	if (context_data->argv) {
	    rule_fset(context_data, command_set);
	}
    }

    return status;
}


static int
init_lvfile(struct context_type *context_data)
{
    int status;

    status = init_lxfile(context_data);
    if (status) {
    } else {
	status =
	    x1f4_vset_lxfile(context_data->lxfile, &context_data->context);
    }

    return status;
}


static int
init_lxdata(struct context_type *context_data)
{
    int status;
    struct x1f4_lxdata_type lxnone;
    unsigned flags = DATA_BITS;
    void *lxdata;

    lxnone.datatype_set.type = HERE_13_DATA;

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_LXDATA_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &lxnone.resource_set.free, &lxnone.resource_set.link,
	     &lxnone.resource_set.mode, &lxnone.resource_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxdata(&lxdata, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_datatype_type *datatype_data;
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxdata = lxdata;

	x1f4_dset_lxdate(lxdata, &datatype_data);

	context_data->typelist[LIST_13_DATA] = datatype_data[0];

	x1f4_fset_lxdate(lxdata, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxdate(struct context_type *context_data)
{
    int status;
    struct x1f4_lxdate_type lxnone;
    unsigned flags = DATE_BITS;
    void *lxdate;

    lxnone.datetype_set.type = HERE_13_DATE;
    lxnone.timetype_set.type = HERE_13_TIME;

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_LXDATE_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &lxnone.resource_set.free, &lxnone.resource_set.link,
	     &lxnone.resource_set.mode, &lxnone.resource_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxdate(&lxdate, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_datatype_type *datatype_data;
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxdate = lxdate;

	x1f4_dset_lxdate(lxdate, &datatype_data);

	context_data->typelist[LIST_13_DATE] = datatype_data[0];
	context_data->typelist[LIST_13_TIME] = datatype_data[1];

	x1f4_fset_lxdate(lxdate, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxdecq(struct context_type *context_data)
{
    int status;
    struct x1f4_lxdecq_type lxnone;
    unsigned flags =
	X1f4_LXDECQ_EVERLINK | X1f4_LXDECQ_RESETNEW | X1f4_LXDECQ_TEXTFLAT;
    void *lxdecq;

    lxnone.datatype_set.nodetype_data = context_data->dtlist;
    lxnone.datatype_set.miss = NODE_TYPES;

    lxnone.decqtype_set.type = HERE_13_DECQ;

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_LXDECQ_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &lxnone.resource_set.free, &lxnone.resource_set.link,
	     &lxnone.resource_set.mode, &lxnone.resource_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxdecq(&lxdecq, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_datatype_type *datatype_data;
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxdecq = lxdecq;

	x1f4_dset_lxdecq(lxdecq, &datatype_data);

	context_data->typelist[LIST_13_DECQ] = datatype_data[0];

	x1f4_fset_lxdecq(lxdecq, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxfile(struct context_type *context_data)
{
    int status;
    struct x1f4_lxfile_type lxnone;
    unsigned flags = FILE_BITS;
    void *lxfile;

    lxnone.filetype_set.type = HERE_13_FILE;

    lxnone.datalink_set.type = HERE_13_DATA;
    lxnone.listlink_set.type = HERE_13_LIST;

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_LXFILE_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &lxnone.resource_set.free, &lxnone.resource_set.link,
	     &lxnone.resource_set.mode, &lxnone.resource_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxfile(&lxfile, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_datatype_type *datatype_data;
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxfile = lxfile;

	x1f4_dset_lxfile(lxfile, &datatype_data);

	context_data->typelist[LIST_13_FILE] = datatype_data[0];

	x1f4_fset_lxfile(lxfile, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxline(struct context_type *context_data)
{
    int status;
    struct x1f4_lxline_type lxnone;
    struct x1f4_frame_type frame;
    unsigned flags = LINE_BITS;
    void *lxline;

    lxnone.datatype_set.nodetype_data = context_data->dtlist;
    lxnone.datatype_set.miss = NODE_TYPES;

    lxnone.linetype_set.type = HERE_13_RECORD;

    x1f4_copy_e4ll(context_data->e4less, &frame);

    lxnone.autolink_set.data = frame.data;
    lxnone.autolink_set.free = frame.free;
    lxnone.autolink_set.link = frame.link;
    lxnone.autolink_set.mode = frame.mode;
    lxnone.autolink_set.pick = frame.pick;
    lxnone.autolink_set.slip = frame.slip;

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_LXLINE_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &lxnone.resource_set.free, &lxnone.resource_set.link,
	     &lxnone.resource_set.mode, &lxnone.resource_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    lxnone.transfer_set.fine = context_data->e4fine;

    status = x1f4_init_lxline(&lxline, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_datatype_type *datatype_data;
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxline = lxline;

	x1f4_dset_lxline(lxline, &datatype_data);

	context_data->typelist[LIST_13_LINE] = datatype_data[0];

	x1f4_fset_lxline(lxline, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxlist(struct context_type *context_data)
{
    int status;
    struct x1f4_lxlist_type lxnone;
    struct x1f4_frame_type frame;
    unsigned flags = LIST_BITS;
    void *lxlist;

    lxnone.datatype_set.nodetype_data = context_data->dtlist;
    lxnone.datatype_set.miss = NODE_TYPES;

    lxnone.listtype_set.type = HERE_13_LIST;

    x1f4_copy_e4ll(context_data->e4less, &frame);

    lxnone.autolink_set.data = frame.data;
    lxnone.autolink_set.free = frame.free;
    lxnone.autolink_set.link = frame.link;
    lxnone.autolink_set.mode = frame.mode;
    lxnone.autolink_set.pick = frame.pick;
    lxnone.autolink_set.slip = frame.slip;

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_LXLIST_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &lxnone.resource_set.free, &lxnone.resource_set.link,
	     &lxnone.resource_set.mode, &lxnone.resource_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxlist(&lxlist, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_datatype_type *datatype_data;
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxlist = lxlist;

	x1f4_dset_lxlist(lxlist, &datatype_data);

	context_data->typelist[LIST_13_LIST] = datatype_data[0];

	x1f4_fset_lxlist(lxlist, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxnear(struct context_type *context_data)
{
    int status;
    struct x1f4_lxnear_type lxnone;
    unsigned flags = X1f4_LXNEAR_LONGPIPE | X1f4_LXNEAR_TEXTFLAT;
    void *lxnear;

    lxnone.longpipe_set.datapipe_data = long_pipes;
    lxnone.longpipe_set.miss = 1;

    lxnone.nearpipe_set.textpipe_data = near_pipes;
    lxnone.nearpipe_set.miss = 2;

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxnear(&lxnear, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxnear = lxnear;

	x1f4_fset_lxnear(lxnear, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxport(struct context_type *context_data)
{
    int status;
    struct x1f4_lxport_type lxnone;
    unsigned flags = PORT_BITS;
    void *lxport;

    lxnone.porttype_set.sshell = HERE_13_SSHELL;
    lxnone.porttype_set.xshell = HERE_13_XSHELL;

    lxnone.sidelink_set.data = HERE_13_DATA;
    lxnone.sidelink_set.file = HERE_13_FILE;
    lxnone.sidelink_set.list = HERE_13_LIST;
    lxnone.sidelink_set.time = HERE_13_TIME;

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_LXPORT_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage,
	     &lxnone.resource_set.free, &lxnone.resource_set.link,
	     &lxnone.resource_set.mode, &lxnone.resource_set.data,
	     &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxport(&lxport, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_datatype_type *datatype_data;
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxport = lxport;

	x1f4_dset_lxport(lxport, &datatype_data);

	context_data->typelist[LIST_13_SSHELL] = datatype_data[0];
	context_data->typelist[LIST_13_XSHELL] = datatype_data[1];

	x1f4_fset_lxport(lxport, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_lxtext(struct context_type *context_data)
{
    int status;
    struct x1f4_lxtext_type lxnone;
    struct x1f4_trans_type trans;
    unsigned flags = X1f4_LXTEXT_TEXTFLAT;
    void *lxtext;

    x1f4_line_e4ll(context_data->e4less, &trans);

    lxnone.autolink_set.data = trans.data;
    lxnone.autolink_set.free = trans.free;
    lxnone.autolink_set.link = trans.link;
    lxnone.autolink_set.mode = trans.mode;

    lxnone.textflat_set.data = context_data;
    lxnone.textflat_set.line = line_flat;
    lxnone.textflat_set.post = post_flat;
    lxnone.textflat_set.push = push_flat;

    status = x1f4_init_lxtext(&lxtext, flags, &lxnone);
    if (status) {
    } else {
	const struct x1f4_linetext_type *linetext_data;

	context_data->lxtext = lxtext;

	x1f4_fset_lxtext(lxtext, &linetext_data);

	rule_lset(context_data, linetext_data);
    }

    return status;
}


static int
init_tf13(struct context_type *context_data)
{
    int status;
    static const struct window_type *window_data;
    unsigned access;

#if __ROLL_VALIST__
    context_data->valist = NULL;
#endif				/* __ROLL_VALIST__ */

    access = sizeof(riddle) / sizeof(struct window_type);

    window_data = riddle;

    for (; access; access--) {
	status = window_data->init(context_data);
	if (status) {
	    break;
	} else {
	    window_data++;
	}
    }

    if (status) {
	access = sizeof(riddle) / sizeof(struct window_type) - access;

	for (; access; access--) {
	    window_data--;
	    window_data->fini(context_data);
	}
    }

    return status;
}


static int
init_trans(struct context_type *context_data)
{
#if __ROLL_VALIST__
    if (context_data->valist) {
	libx1f4i0_lead_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage, &context_data->trans,
	     &context_data->dlist);
    } else {
#endif				/* __ROLL_VALIST__ */
	x1f4_type_mset(&context_data->trans);
#if __ROLL_VALIST__
    }
#endif				/* __ROLL_VALIST__ */

    return 0;
}


static int
init_valist(struct context_type *context_data)
{
#if __ROLL_VALIST__
    libx1f4i0_init_valist
	(&context_data->valist, context_data->do_memory,
	 context_data->do_storage);
#endif				/* __ROLL_VALIST__ */

#if __ROLL_VALIST__
    context_data->dlist.ever = 0;
    context_data->dlist.size = 0;
#endif				/* __ROLL_VALIST__ */

#if __ROLL_VALIST__
    context_data->dlist.valist = context_data->valist;
#endif				/* __ROLL_VALIST__ */

    init_trans(context_data);

    return 0;
}


#if __CLASS_DEBUG__
static int
line_List(void *context, void *subtext, void **address)
{
    fputs("list up...\n", stderr);

    return ((const struct x1f4_datatype_type *) context)->line
	(context, ((const struct x1f4_datatype_type *) context)->context,
	 address);
}
#endif				/* __CLASS_DEBUG__ */


static int
line_driver(void *context, void *output, void **input)
{
    int status;
    struct x1f4_dxcast_type *object_data;

    object_data = I_USER(input[0]);

    if (object_data->type ^ (integral_q) context) {
	status = stat_type
	    (static_text, (integral_q) context, object_data->type);
    } else {
	status = 0;

	l_USER(I_USER(&object_data->data), output);
    }

    return status;
}


static int
line_flat(void *tf13)
{
    fflush(stdout);
    fputs(((struct context_type *) tf13)->self, stderr);
    fputs(":", stderr);
    if (((struct context_type *) tf13)->program) {
	fputs(" ", stderr);
	fputs(((struct context_type *) tf13)->program, stderr);
	fputs(":", stderr);
    }
    if (1) {
	int (*line) (struct context_type *, unsigned *);

	line = ((struct context_type *) tf13)->line;
	if (line) {
	    unsigned copy, miss;

	    line(tf13, &copy);
	    seek_line(tf13, copy, &miss);
	    fprintf(stderr, " %u:", miss + 1);
	}
    }

    fputs(" ", stderr);

    return 0;
}


static int
line_object(void *context, void *output, void **input)
{
    int status;
    struct context_type *context_data;
    void *data;

    context_data = static_text;

    status = context_data->autolink.link
	(context_data->autolink.text, &data, sizeof(struct x1f4_dxcast_type));
    if (status) {
    } else {
	struct x1f4_dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = (integral_q) context;

	l_USER(I_USER(input[0]), &object_data->data);
    }

    return status;
}


static int
line_program(struct context_type *context_data, unsigned *copy)
{
    return x1f4_look_program(context_data->logic, copy);
}


#if __AIME_PASS__ == __SLIP_PASS__
static int
line_shuffle(struct context_type *context_data, unsigned *copy)
{
    return x1f4_look_shuffle(context_data->logic, copy);
}
#endif				/* __AIME_PASS__ == __SLIP_PASS__ */


#if __CLASS_DEBUG__
static int
link_List(void *context, void *subtext, void **address)
{
    fputs("list reset...\n", stderr);

    return ((const struct x1f4_datatype_type *) context)->link
	(context, ((const struct x1f4_datatype_type *) context)->context,
	 address);
}
#endif				/* __CLASS_DEBUG__ */


static int
link_dtlist(struct context_type *context_data)
{
    link_types(context_data->dtlist);

    return 0;
}


static int
link_types(struct x1f4_nodetype_type *nodetype_data)
{
    memcpy(nodetype_data, list_types,
	   LIST_TYPES * sizeof(struct x1f4_nodetype_type));

    nodetype_data += LIST_TYPES;

    x1f4_type_lxdata(nodetype_data, HERE_13_DATA);

    nodetype_data++;

    x1f4_type_lxdate(nodetype_data, HERE_13_DATE);

    nodetype_data++;

    x1f4_type_lxdecq(nodetype_data, HERE_13_DECQ);

    nodetype_data++;

    x1f4_type_lxfile(nodetype_data, HERE_13_FILE);

    nodetype_data++;

    x1f4_type_lxline(nodetype_data, HERE_13_RECORD);

    nodetype_data++;

    x1f4_type_lxlist(nodetype_data, HERE_13_LIST);

    nodetype_data++;

    x1f4_type_lxtime(nodetype_data, HERE_13_TIME);

    nodetype_data++;

    x1f4_type_ssport(nodetype_data, HERE_13_SSHELL);

    nodetype_data++;

    x1f4_type_xsport(nodetype_data, HERE_13_XSHELL);

    return 0;
}


static int
list_text(void *context, const void *text)
{
    const char *name;
    const struct x1f4_linetext_type *linetext_data;

    linetext_data = text;

    name = linetext_data->function.name;
    while (name) {
	x1f4_print_htfunction
	    (stdout, &linetext_data->function, "", NULL, look_type);
	linetext_data++;
	name = linetext_data->function.name;
    }

    return 0;
}


static int
lock_composer(void *context, int outer, int inner,
	      const struct x1f4_linetext_type **linetext)
{
    int delete = 1;

    if (outer == X1f4_E4_OBJECT) {
	delete = seek_object((void *) context, inner, linetext);
    } else {
	if (inner == X1f4_E4_OBJECT) {
	    delete = seek_driver((void *) context, outer, linetext);
	} else {
	    delete = 1;
	}
    }

    return delete;
}


static int
lock_implicit(void *context, int outer, int inner,
	      const struct x1f4_operator_type **operator)
{
    int delete = 1;

    if (outer == X1f4_E4_OBJECT) {
	if (1) {
	    delete = 0;
	    switch (inner) {
	    case X1f4_E4_BILL:
		*operator = object_implicit + 0;
		break;
	    case X1f4_E4_MODE:
		*operator = object_implicit + 1;
		break;
	    case X1f4_E4_REAL:
		*operator = object_implicit + 2;
		break;
	    case X1f4_E4_TEXT:
		*operator = object_implicit + 3;
		break;
	    default:
		delete = 1;
	    }
	}
    } else {
	if (inner == X1f4_E4_OBJECT) {
	    delete = 0;
	    switch (outer) {
	    case X1f4_E4_BILL:
		*operator = driver_implicit + 0;
		break;
	    case X1f4_E4_MODE:
		*operator = driver_implicit + 1;
		break;
	    case X1f4_E4_REAL:
		*operator = driver_implicit + 2;
		break;
	    case X1f4_E4_TEXT:
		*operator = driver_implicit + 3;
		break;
	    default:
		delete = 1;
	    }
	} else {
	    delete = 1;
	}
    }

    return delete;
}


static int
look_type(const void *none, int type, const char **name, unsigned *size)
{
    int delete = 0;

    if (type < HERE_13_SIX) {
	*size = 4;

	switch (type) {
	case HERE_13_DATA:
	    *name = "data";
	    break;
	case HERE_13_DATE:
	    *name = "date";
	    break;
	case HERE_13_DECQ:
	    *name = "decq";
	    break;
	case HERE_13_FILE:
	    *name = "file";
	    break;
	case HERE_13_LIST:
	    *name = "list";
	    break;
	case HERE_13_TIME:
	    *name = "time";
	    break;
	default:
	    delete = 1;
	}
    } else {
	*size = 6;

	switch (type) {
	case X1f4_E4_OBJECT:
	    *name = "object";
	    break;
	case HERE_13_RECORD:
	    *name = "record";
	    break;
	case HERE_13_SSHELL:
	    *name = "sshell";
	    break;
	case HERE_13_XSHELL:
	    *name = "xshell";
	    break;
	default:
	    delete = 1;
	}
    }

    return delete;
}


static int
lose_call(void *context, const struct x1f4_function_type *function_data)
{
    struct context_type *context_data;
    unsigned call;

    context_data = context;

    call = context_data->call;

    call--;

    context_data->call = call;

    for (++call; call; call--) {
	fputs("    ", stderr);
    }

    fputs(" ---- ", stderr);
    fputs(function_data->name, stderr);
    fputs(" ---->\n", stderr);

    return 0;
}


static int
merge_operators(const struct x1f4_operator_type *const **f13,
		const struct x1f4_operator_type *const *x1f4,
		const struct x1f4_operator_type *const *tf13, unsigned class)
{
    const struct x1f4_operator_type **data, *const *z1f4;
    int status = 0;
    unsigned count;

    z1f4 = x1f4;
    while (*z1f4) {
	z1f4++;
    }

    count = z1f4 - x1f4;
    data = (const struct x1f4_operator_type **) malloc
	(sizeof(const struct x1f4_operator_type *) * (class + count + 1));
    if (!data) {
	status = 1;
	*f13 = x1f4;
    } else {
	*f13 = data;
	memcpy(data, tf13,
	       sizeof(const struct x1f4_operator_type *) * class);
	data += class;
	memcpy(data, x1f4,
	       sizeof(const struct x1f4_operator_type *) * (count + 1));
    }

    return status;
}


static int
mode_argc(void *context, void *output, void **input)
{
    l_MODE(((struct context_type *) static_context)->argc, output);

    return 0;
}


static int
o19xb_o__(void *output, void **input)
{
    int status;
    struct context_type *context_data;
    void *data;

    context_data = static_text;

    status = context_data->autolink.link
	(context_data->autolink.text, &data, sizeof(struct x1f4_dxcast_type));
    if (status) {
    } else {
	struct x1f4_dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_BILL;

	l_BILL(I_BILL(input[0]), &object_data->data);
    }

    return status;
}


static int
o19xm_o__(void *output, void **input)
{
    int status;
    struct context_type *context_data;
    void *data;

    context_data = static_text;

    status = context_data->autolink.link
	(context_data->autolink.text, &data, sizeof(struct x1f4_dxcast_type));
    if (status) {
    } else {
	struct x1f4_dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_MODE;

	l_MODE(I_MODE(input[0]), &object_data->data);
    }

    return status;
}


static int
o19xr_o__(void *output, void **input)
{
    int status;
    struct context_type *context_data;
    void *data;

    context_data = static_text;

    status = context_data->autolink.link
	(context_data->autolink.text, &data, sizeof(struct x1f4_dxcast_type));
    if (status) {
    } else {
	struct x1f4_dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_REAL;

	l_REAL(I_REAL(input[0]), &object_data->data);
    }

    return status;
}


static int
o19xt_o__(void *output, void **input)
{
    int status;
    struct context_type *context_data;
    void *data;

    context_data = static_text;

    status = context_data->autolink.link
	(context_data->autolink.text, &data, sizeof(struct x1f4_dxcast_type));
    if (status) {
    } else {
	struct x1f4_dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = X1f4_E4_TEXT;

	l_TEXT(I_TEXT(input[0]), &object_data->data);
    }

    return status;
}


static int
pick_object(void *context, void *output, void **input)
{
    int status;
    struct context_type *context_data;
    void *data, **mind;

    context_data = static_text;

    status = context_data->autolink.pick
	(context_data->autolink.text, &mind, slip_object,
	 sizeof(struct upcast_type), &data);
    if (status) {
    } else {
	struct upcast_type *upcast_data;
	struct x1f4_datatype_type *datatype_data;
	struct x1f4_dxcast_type *object_data;

	*mind = data;

	upcast_data = data;

	data = &upcast_data->dxcast;

	l_USER(data, output);

	object_data = data;

	datatype_data = context;

	object_data->call = 1;
	object_data->type = datatype_data->type;

	l_USER(I_USER(input[0]), &object_data->data);

	if (0) {
	} else {
	    status = datatype_data->lead
		(datatype_data->context, (void *) &object_data->data);
	    if (status) {
		upcast_data->datatype_data = NULL;
	    } else {
		upcast_data->datatype_data = datatype_data;
	    }
	}
    }

    return status;
}


#if __AIME_PASS__ == __NOTE_PASS__
static int
pick_shuffle(struct context_type *context_data, unsigned *copy)
{
    return x1f4_seek_shuffle(context_data->logic, copy);
}
#endif				/* __AIME_PASS__ == __NOTE_PASS__ */


static int
pipe_shuffle(struct context_type *context_data, void *shuffle)
{
    x1f4_a1screen_type screen;

    screen.data = context_data;

    screen.back = lose_call;
    screen.fast = fast_call;
    screen.lose = lose_call;

    context_data->call = 0;

    return x1f4_pipe_shuffle(shuffle, &screen);
}


static int
post_flat(void *tf13)
{
    ((struct context_type *) tf13)->error = 1;

    fputs("\n", stderr);

    return 0;
}


static int
push_flat(void *tf13, const char *data, unsigned size)
{
    fwrite(data, size, 1, stderr);

    return 0;
}


static int
rule_fset(struct context_type *context_data,
	  const struct x1f4_function_type *function_data)
{
    const char *name;
    int status;

    name = function_data->name;
    if (name) {
	void *fsdeck;

	fsdeck = context_data->fsdeck;

	do {
	    status = x1f4_post_mxpath
		(fsdeck, name, function_data->length, function_data);
	    if (status) {
		break;
	    } else {
		function_data++;
	    }

	    name = function_data->name;
	} while (name);
    } else {
	status = 0;
    }

    return status;
}


static int
rule_lset(struct context_type *context_data,
	  const struct x1f4_linetext_type *linetext_data)
{
    const char *name;
    int status;

    name = linetext_data->function.name;
    if (name) {
	void *fsdeck;

	fsdeck = context_data->fsdeck;

	do {
	    status = x1f4_post_mxpath
		(fsdeck, name, linetext_data->function.length,
		 &linetext_data->function);
	    if (status) {
		break;
	    } else {
		linetext_data++;
	    }

	    name = linetext_data->function.name;
	} while (name);
    } else {
	status = 0;
    }

    return status;
}


static int
run_logic(struct context_type *context_data, unsigned count,
	  void *state_data, const char *program, const void *data)
{
    int status;
    struct x1f4_c1_type c1;
    struct x1f4_c1record_type c1record;
    const struct x1f4_operator_type *const *operator2s;
    unsigned flags = C113_BITS;
    void *proGram;

    if (context_data->disallow_comments) {
	flags &= ~X1f4_C1_SCOMMENT;
    }

    if (context_data->do_optimize) {
	flags |= X1f4_C1_OPTIMIZE;
    }

    c1.bcollect_set.c1record_data = &c1record;
    c1.composer_set.context = context_data;
    c1.composer_set.get = lock_composer;
    c1.function_set.fix = select_context;
    c1.function_set.get = select_logic;
    c1.function_set.context = context_data;
    c1.implicit_set.get = lock_implicit;
    x1f4_llink_operator1s(&c1.operator1s);
    x1f4_llink_operator2s(&operator2s);
    merge_operators(&c1.operator2s, operator2s, tf13_e4_2_arithmetics, 2);
    c1.sidetype_set.miss = parameter_datatypes;
    c1.transfer_set.fine = context_data->e4fine;
    c1.variable_set.context = context_data->context;

    if (1) {
#if __CLASS_DEBUG__
	c1.datatype_set.miss = class_datatypes;
#else
	c1.datatype_set.miss = context_data->typelist;
#endif				/* __CLASS_DEBUG__ */

	flags |= X1f4_C1_TYPELIST;
    }

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_C1_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage, &c1.resource_set.free,
	     &c1.resource_set.link, &c1.resource_set.mode,
	     &c1.resource_set.context, &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    status = x1f4_init_program(&proGram, data, flags, &c1);
    if (status) {
	if (status == X1f4_C1_ALLOC_ERROR) {
	    perror(context_data->self);
	} else {
	    struct x1f4_eelookup_type eelookup;

	    fprintf(stderr, "%s: cannot parse ", context_data->self);
	    if (program) {
		fprintf(stderr, "`%s'", program);
	    } else {
		fprintf(stderr, "program");
	    }
	    fprintf(stderr, "\n");
	    fprintf(stderr, "%s: ", context_data->self);
	    eelookup.type_l.fix = look_type;
	    eelookup.type_q.e4fine = context_data->e4fine;
	    c1record.pick = 1;
	    x1f4_stat_program(stderr, test_cast, data, &c1record, &eelookup);
	    fprintf(stderr, "\n");
	}
    } else {
	if (context_data->do_print) {
	    x1f4_vprint_program(stdout, test_cast, proGram, /*print_flags*/0);
	} else {
	    context_data->class = 0;
	    context_data->error = 0;

	    context_data->exit = 0;

	    context_data->logic = proGram;

	    context_data->line = line_program;

#if ____AIME_PASS__ == __NOTE_PASS__
	    status = x1f4_note_program
		(proGram, &context_data->class, context_data, flat_text);
#elif __AIME_PASS__ == __SLIP_PASS__
	    x1f4_head_program(proGram);
	    while (!x1f4_tail_program(proGram)) {
		status = x1f4_slip_program(proGram);

		if (context_data->class) {
		    int excess;

		    context_data->class = 0;
		    excess = context_data->deck(&context_data->e4deck);
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
		} else {
		    if (SIGCHLD_received) {
			int excess;

			excess = wait_some(context_data);
			if (excess) {
			    if (status) {
			    } else {
				status = excess;
			    }
			}
		    }
		}

		if (status) {
		    break;
		}
	    }
#endif				/* ____AIME_PASS__ == __NOTE_PASS__ */

	    if (status) {
		if (context_data->exit) {
		    status = context_data->exit >> 1;
		} else {
		    flush_error(context_data, program);
		}
	    }
	}

#if __ROLL_VALIST__
	if (context_data->valist) {
	    if (context_data->do_storage) {
		unsigned size;

		x1f4_size_xalist(context_data->valist, &size);
		fprintf(stderr, " %7u\n", size);
	    }
	}
#endif				/* __ROLL_VALIST__ */

	x1f4_fini_program(&proGram);
    }

    if (c1.operator2s != operator2s) {
	free((void *) c1.operator2s);
    }

    return status;
}


static int
seek_driver(struct context_type *context_data, int outer,
	    const struct x1f4_linetext_type **linetext)
{
    int delete;
    struct fringe_type *fringe_data;

    fringe_data = context_data->driver_fringe;
    while (fringe_data) {
	if (fringe_data->linetext.function.type == outer) {
	    break;
	}

	fringe_data = fringe_data->fringe_data;
    }

    if (fringe_data) {
	delete = 0;
	*linetext = &fringe_data->linetext;
    } else {
	fringe_data = malloc(sizeof(struct fringe_type) + sizeof(int));
	if (fringe_data) {
	    int *args;

	    delete = 0;

	    fringe_data->fringe_data = context_data->driver_fringe;
	    context_data->driver_fringe = fringe_data;

	    *linetext = &fringe_data->linetext;

	    fringe_data->linetext.context = (void *) (integral_q) outer;

	    args = (void *) (fringe_data + 1);

	    *args = X1f4_E4_OBJECT;

	    fringe_data->linetext.function.args = args;
	    fringe_data->linetext.function.count = 1;
	    fringe_data->linetext.function.flags =
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
	    fringe_data->linetext.function.function = line_driver;
	    fringe_data->linetext.function.length = 12;
	    fringe_data->linetext.function.name = "(object) -> ";
	    fringe_data->linetext.function.type = outer;
	} else {
	    delete = 1;
	}
    }

    return delete;
}


static int
seek_line(struct context_type *context_data, unsigned copy, unsigned *miss)
{
    const char *data;
    unsigned line = 0;

    data = context_data->data;
    while (copy) {
	if (*data == 10) {
	    line++;
	}

	copy--;
	data++;
    }

    *miss = line;

    return 0;
}


static int
seek_object(struct context_type *context_data, int inner,
	    const struct x1f4_linetext_type **linetext)
{
    int delete;
    struct fringe_type *fringe_data;

    fringe_data = context_data->object_fringe;
    while (fringe_data) {
	if ((integral_q) fringe_data->linetext.context == inner) {
	    break;
	}

	fringe_data = fringe_data->fringe_data;
    }

    if (fringe_data) {
	delete = 0;
	*linetext = &fringe_data->linetext;
    } else {
	struct x1f4_datatype_type *datatype_data;

	datatype_data = context_data->typelist;
	while (datatype_data->name) {
	    if (datatype_data->type == inner) {
		break;
	    } else {
		datatype_data++;
	    }
	}

	if (datatype_data->name) {
	    if (datatype_data->lead) {
	    } else {
		datatype_data = NULL;
	    }
	} else {
	    datatype_data = NULL;
	}

	fringe_data = malloc(sizeof(struct fringe_type) + sizeof(int));
	if (fringe_data) {
	    int *args;

	    delete = 0;

	    fringe_data->fringe_data = context_data->object_fringe;
	    context_data->object_fringe = fringe_data;

	    *linetext = &fringe_data->linetext;

	    fringe_data->linetext.context =
		datatype_data ? datatype_data : (void *) (integral_q) inner;

	    args = (void *) (fringe_data + 1);

	    *args = inner;

	    fringe_data->linetext.function.args = args;
	    fringe_data->linetext.function.count = 1;
	    fringe_data->linetext.function.flags =
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
	    fringe_data->linetext.function.function =
		datatype_data ? pick_object : line_object;
	    fringe_data->linetext.function.length = 12;
	    fringe_data->linetext.function.name = "(object) <- ";
	    fringe_data->linetext.function.type = X1f4_E4_OBJECT;
	} else {
	    delete = 1;
	}
    }

    return delete;
}


static int
select_context(const void *context, const struct x1f4_function_type *miss,
	       void **text)
{
#if 1
    *text = (void *)
	((const struct x1f4_linetext_type *)
	 ((const char *) miss
	  - offsetof(struct x1f4_linetext_type, function)))->context;
#else
    *text = (void *)
	((const struct x1f4_linetext_type *)
	 ((const char *) ((const struct context_type *) context)->function_slip
	  - offsetof(struct x1f4_linetext_type, function)))->context;
#endif				/* 1 */

    return 0;
}


static int
select_logic(const char *f, unsigned length, const void *context,
	     const struct x1f4_function_type **function)
{
    int status;
    struct context_type *context_data;
    const void *mind;

    context_data = (void *) context;

    status = x1f4_find_mxpath(context_data->fsdeck, f, length, &mind);
    if (status) {
	status = 0;

	*function = mind;

	context_data->function_slip = mind;
    } else {
	status = 1;
    }

    return status;
}


static int
set_logic(struct context_type *context_data, unsigned count,
	  void *state_data, const char *program, const void *data)
{
    int status;
    struct x1f4_a1_type a1;
    struct x1f4_a1record_type a1record;
    const struct x1f4_operator_type *const *operator2s;
    unsigned flags = A113_BITS;
    void *proGram;

    if (context_data->disallow_comments) {
	flags &= ~X1f4_A1_SCOMMENT;
    }

    if (context_data->do_optimize) {
	flags |= X1f4_A1_OPTIMIZE;
    }

    a1.bcollect_set.a1record_data = &a1record;
    a1.composer_set.context = context_data;
    a1.composer_set.get = lock_composer;
    a1.function_set.fix = select_context;
    a1.function_set.get = select_logic;
    a1.function_set.context = context_data;
    a1.implicit_set.get = lock_implicit;
    x1f4_llink_operator1s(&a1.operator1s);
    x1f4_llink_operator2s(&operator2s);
    merge_operators(&a1.operator2s, operator2s, tf13_e4_2_arithmetics, 2);
    a1.sidetype_set.miss = parameter_datatypes;
    a1.transfer_set.fine = context_data->e4fine;
    a1.variable_set.context = context_data->context;

    if (1) {
#if __CLASS_DEBUG__
	a1.datatype_set.miss = class_datatypes;
#else
	a1.datatype_set.miss = context_data->typelist;
#endif				/* __CLASS_DEBUG__ */

	flags |= X1f4_A1_TYPELIST;
    }

#if __ROLL_VALIST__
    if (context_data->valist) {
	flags |= X1f4_A1_RESOURCE;
	libx1f4i0_line_valist
	    (context_data->valist, context_data->do_memory,
	     context_data->do_storage, &a1.resource_set.free,
	     &a1.resource_set.link, &a1.resource_set.mode,
	     &a1.resource_set.context, &context_data->dlist);
    }
#endif				/* __ROLL_VALIST__ */

    status = x1f4_init_shuffle(&proGram, data, flags, &a1);
    if (status) {
	if (status == X1f4_A1_ALLOC_ERROR) {
	    perror(context_data->self);
	} else {
	    struct x1f4_eelookup_type eelookup;

	    fprintf(stderr, "%s: cannot parse ", context_data->self);
	    if (program) {
		fprintf(stderr, "`%s'", program);
	    } else {
		fprintf(stderr, "program");
	    }
	    fprintf(stderr, "\n");
	    fprintf(stderr, "%s: ", context_data->self);
	    eelookup.type_l.fix = look_type;
	    eelookup.type_q.e4fine = context_data->e4fine;
	    a1record.pick = 1;
	    x1f4_stat_shuffle(stderr, test_cast, data, &a1record, &eelookup);
	    fprintf(stderr, "\n");
	}
    } else {
	if (context_data->do_print) {
	} else {
	    status = x1f4_pipe_e4ll(context_data->e4less, proGram);
	    if (status) {
		perror(context_data->self);
	    } else {
		X1f4_E4_C_MODE degree;
#if ____AIME_PASS__ == __SLIP_PASS__
		void *subtext;
#endif				/* ____AIME_PASS__ == __SLIP_PASS__ */

		if (context_data->do_trace) {
		    pipe_shuffle(context_data, proGram);
		}

		context_data->class = 0;
		context_data->error = 0;

		context_data->exit = 0;

#if ____AIME_PASS__ == __SLIP_PASS__
		x1f4_rail_shuffle(proGram);
#endif				/* ____AIME_PASS__ == __SLIP_PASS__ */

#if ____AIME_PASS__ == __NOTE_PASS__
		context_data->line = pick_shuffle;
#endif				/* ____AIME_PASS__ == __NOTE_PASS__ */

#if ____AIME_PASS__ == __NOTE_PASS__
		context_data->logic = proGram;
#endif				/* ____AIME_PASS__ == __NOTE_PASS__ */

#if ____AIME_PASS__ == __NOTE_PASS__
		status = x1f4_long_shuffle
		    (proGram, &context_data->class, context_data,
		     flat_text, &degree);
		if (status) {
		    if (context_data->exit) {
			status = context_data->exit >> 1;
		    } else {
			flush_error(context_data, program);
		    }
		} else {
		    status = degree;
		}
#elif __AIME_PASS__ == __SLIP_PASS__
		status = x1f4_near_shuffle(&subtext, proGram);
		if (status) {
		} else {
		    int excess;

		    context_data->logic = subtext;

		    context_data->line = line_shuffle;

		    x1f4_head_shuffle(subtext);
		    while (!x1f4_tail_shuffle(subtext)) {
			status = x1f4_slip_shuffle(subtext);

			if (context_data->class) {
			    int excess;

			    context_data->class = 0;
			    excess = context_data->deck(&context_data->e4deck);
			    if (excess) {
				if (status) {
				} else {
				    status = excess;
				}
			    }
			} else {
			    if (SIGCHLD_received) {
				int excess;

				excess = wait_some(context_data);
				if (excess) {
				    if (status) {
				    } else {
					status = excess;
				    }
				}
			    }
			}

			if (status) {
			    break;
			}
		    }

		    if (status) {
			if (context_data->exit) {
			    status = context_data->exit >> 1;
			} else {
			    flush_error(context_data, program);
			}
		    }

		    excess = x1f4_side_shuffle
			(&subtext, proGram, context_data);
		    if (excess) {
			if (status) {
			} else {
			    status = excess;
			}
		    }
		}
#endif				/* ____AIME_PASS__ == __NOTE_PASS__ */
	    }
	}

#if __ROLL_VALIST__
	if (context_data->valist) {
	    if (context_data->do_storage) {
		unsigned size;

		x1f4_size_xalist(context_data->valist, &size);
		fprintf(stderr, " %7u\n", size);
	    }
	}
#endif				/* __ROLL_VALIST__ */

	x1f4_fini_shuffle(&proGram);
    }

    if (a1.operator2s != operator2s) {
	free((void *) a1.operator2s);
    }

    return status;
}


static int
slip_object(void *upcast)
{
    int status;
    struct upcast_type *upcast_data;
    struct x1f4_datatype_type *datatype_data;

    upcast_data = upcast;

    datatype_data = upcast_data->datatype_data;
    if (datatype_data) {
	status = datatype_data->slip
	    (datatype_data->context, (void *) &upcast_data->dxcast.data);
    } else {
	status = 0;
    }

    return status;
}


static int
stat_argv(void *context, int index)
{
    line_flat(context);
    push_flat(context, "out of range argv index: ", 25);
    x1f4_vprint_dintegral(context, push_flat, index);
    post_flat(context);

    return -1;
}


static int
stat_type(struct context_type *context_data, int call, int type)
{
    struct x1f4_eelookup_type e4lookup;

    e4lookup.type_l.fix = look_type;
    e4lookup.type_l.context = context_data;
    e4lookup.type_q.e4fine = context_data->e4fine;

    line_flat(context_data);
    push_flat(context_data, "mismatched type", 15);
    push_flat(context_data, ": ", 2);
    x1f4_dump_type(context_data, push_flat, call, &e4lookup);
    push_flat(context_data, " expected, ", 11);
    x1f4_dump_type(context_data, push_flat, type, &e4lookup);
    push_flat(context_data, " found", 6);
    post_flat(context_data);

    return -1;
}


static int
test_cast(void *cast, const char *name, unsigned size)
{
    return size ^ fwrite(name, 1, size, cast);
}


static int
tempt_logic(struct context_type *context_data, int argc, char **argv)
{
    int status;

    context_data->context = NULL;

    status = init_tf13(context_data);
    if (status) {
    } else {
	const char *program;
	unsigned count;
	void *state_data;

	program = argv[optind];
	optind++;

	if (context_data->argv) {
	    state_data = NULL;
	} else {
	    status = libx1f4i0_init_fine
		(optind, argc, argv, &count, &state_data,
		 &context_data->context);
	}
	if (status) {
	} else {
	    SIGCHLD_received = 0;

#if ____AIME_PASS__ == __NOTE_PASS__
	    static_class = &context_data->class;
#endif				/* ____AIME_PASS__ == __NOTE_PASS__ */

	    signal(SIGCHLD, SIGCHLD_handler);

	    if (0) {
	    } else {
		if (context_data->immediate) {
		    if (0) {
		    } else {
			context_data->data = program;

			context_data->program = NULL;

			status = fix_logic
			    (context_data, count, state_data, NULL, program);
		    }
		} else {
		    unsigned size;
		    void *data;

		    status = libx1f4i0_read_file(&data, &size, program, 1);
		    if (status) {
			libx1f4i0_stat_failure(argv[0], status, program);
		    } else {
			if (1) {
			    char *mine;

			    mine = data;
			    mine[size] = 0;
			}

			context_data->data = data;

			context_data->program = program;

			status = fix_logic
			    (context_data, count, state_data, program, data);

			free(data);
		    }
		}
	    }

	    signal(SIGCHLD, SIG_DFL);
	}

	if (state_data) {
	    free(state_data);
	}

	if (1) {
	    int excess;

	    excess = fini_tf13(context_data);
	    if (excess) {
		if (status) {
		} else {
		    status = excess;
		}
	    }
	}
    }

    if (context_data->context) {
	x1f4_air_state(context_data->context);
    }

    return status;
}


static int
text_argv(void *context, void *output, void **input)
{
    X1f4_E4_C_MODE index;
    int status = 0;

    index = I_MODE(input[0]);
    if (index < 0) {
	status = stat_argv(static_context, index);
    } else {
	if (index) {
	    if (index < ((struct context_type *) static_context)->argc) {
		l_TEXT(((struct context_type *) static_context)->argv[index],
		        output);
	    } else {
		status = stat_argv(static_context, index);
	    }
	} else {
	    char *program;

	    program = (char *)
		((struct context_type *) static_context)->program;
	    if (program) {
		l_TEXT(program, output);
	    } else {
		l_TEXT((char *) x1f4_c1_empty_string, output);
	    }
	}
    }

    return status;
}


static int
type_13list(struct context_type *context_data)
{
    context_data->typelist[LIST_13_NULL].name = NULL;

    return 0;
}


static int
type_lxfile(struct context_type *context_data)
{
    void *lxfile;

    lxfile = context_data->lxfile;

    x1f4_data_lxfile(lxfile, context_data->lxdata);
    x1f4_list_lxfile(lxfile, context_data->lxlist);

    return 0;
}


static int
type_lxport(struct context_type *context_data)
{
    void *lxport;

    lxport = context_data->lxport;

    x1f4_data_lxport(lxport, context_data->lxdata);
    x1f4_date_lxport(lxport, context_data->lxdate);
    x1f4_file_lxport(lxport, context_data->lxfile);
    x1f4_list_lxport(lxport, context_data->lxlist);

    return 0;
}


static int
wait_some(struct context_type *context_data)
{
    int status;

    SIGCHLD_received = 0;

    while (1) {
	pid_t wait;

	wait = waitpid(-1, NULL, WNOHANG);
	if (wait == -1) {
	    status = 0;
	    if (1) {
		break;
	    }
	} else {
	    if (wait) {
		x1f4_wait_lxport(context_data->lxport, wait);
	    } else {
		status = 0;
		if (1) {
		    break;
		}
	    }
	}
    }

    return status;
}


static void
SIGCHLD_handler(int signal)
{
    SIGCHLD_received = 1;
#if __AIME_PASS__ == __NOTE_PASS__
    *static_class = 1;
#endif				/* __AIME_PASS__ == __NOTE_PASS__ */
}


static void
free_fringe(struct fringe_type *fringe_data)
{
    do {
	struct fringe_type *fringe_link;

	fringe_link = fringe_data->fringe_data;
	free(fringe_data);
	fringe_data = fringe_link;
    } while (fringe_data);
}


static void
list_0010(struct context_type *context_data)
{
    int status;

    status = init_dtlist(context_data);
    if (status) {
    } else {
	link_dtlist(context_data);

	x1f4_print_functions(stdout, x1f4_e4_defaults);
	x1f4_print_functions(stdout, command_set);
	x1f4_print_functions(stdout, t13_set);
	list_0011();
	list_0012(context_data);
	list_0013();
	list_0014();
	list_0015();
	list_0016();
	list_0017(context_data);
	list_0023(context_data);
	list_0111();

	fini_dtlist(context_data);
    }
}


static void
list_0011(void)
{
    struct x1f4_lxtext_type lxnone;
    void *lxtext;

    if (x1f4_init_lxtext(&lxtext, 0, &lxnone)) {
    } else {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxtext(lxtext, &linetext_data);
	list_text(NULL, linetext_data);

	x1f4_fini_lxtext(&lxtext);
    }
}


static void
list_0012(struct context_type *context_data)
{
    struct x1f4_lxlist_type lxnone;
    void *lxlist;

    lxnone.datatype_set.nodetype_data = context_data->dtlist;
    lxnone.datatype_set.miss = NODE_TYPES;

    lxnone.listtype_set.type = HERE_13_LIST;

    if (x1f4_init_lxlist(&lxlist, LIST_LINK, &lxnone)) {
    } else {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxlist(lxlist, &linetext_data);
	list_text(NULL, linetext_data);

	x1f4_fini_lxlist(&lxlist);
    }
}


static void
list_0013(void)
{
    int status;
    struct x1f4_lxfile_type lxnone;
    void *lxfile;

    lxnone.filetype_set.type = HERE_13_FILE;

    lxnone.datalink_set.type = HERE_13_DATA;
    lxnone.listlink_set.type = HERE_13_LIST;

    status = x1f4_init_lxfile(&lxfile, FILE_LINK, &lxnone);
    if (!status) {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxfile(lxfile, &linetext_data);
	list_text(NULL, linetext_data);

	status = x1f4_fini_lxfile(&lxfile);
    }
}


static void
list_0014(void)
{
    int status;
    struct x1f4_lxdate_type lxnone;
    void *lxdate;

    lxnone.datetype_set.type = HERE_13_DATE;
    lxnone.timetype_set.type = HERE_13_TIME;

    status = x1f4_init_lxdate(&lxdate, DATE_LINK, &lxnone);
    if (!status) {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxdate(lxdate, &linetext_data);
	list_text(NULL, linetext_data);

	status = x1f4_fini_lxdate(&lxdate);
    }
}


static void
list_0015(void)
{
    struct x1f4_lxnear_type lxnone;
    void *lxnear;

    lxnone.longpipe_set.datapipe_data = long_pipes;
    lxnone.longpipe_set.miss = 1;

    lxnone.nearpipe_set.textpipe_data = near_pipes;
    lxnone.nearpipe_set.miss = 2;

    if (x1f4_init_lxnear(&lxnear, X1f4_LXNEAR_LONGPIPE, &lxnone)) {
    } else {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxnear(lxnear, &linetext_data);
	list_text(NULL, linetext_data);

	x1f4_fini_lxnear(&lxnear);
    }
}


static void
list_0016(void)
{
    int status;
    struct x1f4_lxdata_type lxnone;
    void *lxdata;

    lxnone.datatype_set.type = HERE_13_DATA;

    status = x1f4_init_lxdata(&lxdata, DATA_LINK, &lxnone);
    if (!status) {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxdata(lxdata, &linetext_data);
	list_text(NULL, linetext_data);

	status = x1f4_fini_lxdata(&lxdata);
    }
}


static void
list_0017(struct context_type *context_data)
{
    int status;
    struct x1f4_lxdecq_type lxnone;
    void *lxdecq;

    lxnone.datatype_set.nodetype_data = context_data->dtlist;
    lxnone.datatype_set.miss = NODE_TYPES;

    lxnone.decqtype_set.type = HERE_13_DECQ;

    status = x1f4_init_lxdecq
	(&lxdecq, X1f4_LXDECQ_EVERLINK | X1f4_LXDECQ_RESETNEW, &lxnone);
    if (!status) {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxdecq(lxdecq, &linetext_data);
	list_text(NULL, linetext_data);

	status = x1f4_fini_lxdecq(&lxdecq);
    }
}


static void
list_0022(struct context_type *context_data, void *e4fine)
{
    struct x1f4_lxline_type lxnone;
    void *lxline;

    lxnone.datatype_set.nodetype_data = context_data->dtlist;
    lxnone.datatype_set.miss = NODE_TYPES;

    lxnone.linetype_set.type = HERE_13_RECORD;

    lxnone.transfer_set.fine = e4fine;

    if (x1f4_init_lxline(&lxline, LINE_LINK, &lxnone)) {
    } else {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxline(lxline, &linetext_data);
	list_text(NULL, linetext_data);

	x1f4_fini_lxline(&lxline);
    }
}


static void
list_0023(struct context_type *context_data)
{
    void *e4fine;

    if (x1f4_init_e4fine(&e4fine, 0, NULL)) {
    } else {
	list_0022(context_data, e4fine);

	x1f4_fini_e4fine(&e4fine);
    }
}


static void
list_0111(void)
{
    int status;
    struct x1f4_lxport_type lxnone;
    void *lxport;

    lxnone.porttype_set.sshell = HERE_13_SSHELL;
    lxnone.porttype_set.xshell = HERE_13_XSHELL;

    lxnone.sidelink_set.data = HERE_13_DATA;
    lxnone.sidelink_set.file = HERE_13_FILE;
    lxnone.sidelink_set.list = HERE_13_LIST;
    lxnone.sidelink_set.time = HERE_13_TIME;

    status = x1f4_init_lxport(&lxport, PORT_LINK, &lxnone);
    if (!status) {
	const struct x1f4_linetext_type *linetext_data;

	x1f4_fset_lxport(lxport, &linetext_data);
	list_text(NULL, linetext_data);

	status = x1f4_fini_lxport(&lxport);
    }
}


static void
list_0220(void)
{
    list_0223();
}


static void
list_0223(void)
{
#if 0
    void *context = NULL;

    if (x1f4_vset_lxfile(&context)) {
    } else {
	x1f4_list_state(context, NULL, ever_list);

	x1f4_air_state(context);
    }
#endif				/* 0 */
}


static void
usage(void)
{
    puts("Usage: tf13 [OPTIONS] PROGRAM [TYPE NAME VALUE]\n\
Execute PROGRAM.\n\
\n\
Options:\n\
  -M, --stat-storage		stat program memory storage requirements\n\
  -P, --print			print program\n\
  -a				make arguments available as argc()/argv()\n\
  -c				execute the PROGRAM program instead program\n\
				read from the PROGRAM file\n\
  -m, --stat-memory		stat memory operations\n\
  -o, --optimize		enable optimizations\n\
  -t, --trace			trace function calls\n\
      --data			list defined constants and exit\n\
      --disallow-comments	disallow # led comments\n\
      --list			list available functions and exit\n\
      --help			display this help and exit\n\
      --version			output version information and exit");
}


int
main(int argc, char **argv)
{
    int list_functions = 0, status = 0;
    struct context_type context;

    context.disallow_comments = 0;

    context.do_memory = 0;
    context.do_optimize = 0;
    context.do_print = 0;
    context.do_storage = 0;
    context.do_trace = 0;

    context.immediate = 0;

    unsetenv("POSIXLY_CORRECT");

    {
	int fast = ~0, miss_fine = 0;

	while (1) {
	    char c;
	    static struct option long_options[] = {
/* *INDENT-OFF* */
		{   "data",	    0x00,   NULL,   0x02    },
		{   "disallow-comments",
				    0x00,   NULL,   0x03    },
		{   "help",	    0x00,   NULL,   0x68    },
		{   "list",	    0x00,   NULL,   0x01    },
		{   "optimize",	    0x00,   NULL,   0x6f    },
		{   "print",	    0x00,   NULL,   0x50    },
		{   "stat-memory",  0x00,   NULL,   0x6d    },
		{   "stat-storage", 0x00,   NULL,   0x4d    },
		{   "trace",	    0x00,   NULL,   0x74    },
		{   "version",	    0x00,   NULL,   0x76    },
		{   NULL,	    0x00,   NULL,   0x00    }
/* *INDENT-ON* */
	    };

	    c = getopt_long(argc, argv, "MPacmot", long_options, NULL);

	    if (!~c) {
		break;
	    }

	    switch (c) {
	    case 001:
		list_functions = 1;
		break;
	    case 002:
		list_functions = 2;
		break;
	    case 003:
		context.disallow_comments = 1;
		break;
	    case 'M':
		context.do_storage = 1;
		break;
	    case 'P':
		context.do_print = 1;
		break;
	    case 'a':
		miss_fine = 1;
		break;
	    case 'c':
		context.immediate = 1;
		break;
	    case 'h':
	    case 'v':
		if (!~fast) {
		    fast = c;
		}
		break;
	    case 'm':
		context.do_memory = 1;
		break;
	    case 'o':
		context.do_optimize = 1;
		break;
	    case 't':
		context.do_trace = 1;
		break;
	    case '?':
		return 1;
	    }
	}

	if (~fast) {
	    switch (fast) {
	    case 'h':
		usage();
		break;
	    case 'v':
		printf("%s (%s) %s\n", argv[0], PACKAGE, VERSION);
	    }

	    return 0;
	}

	if (miss_fine) {
	    context.argc = argc - optind;
	    context.argv = argv + optind;
	} else {
	    context.argv = NULL;
	}
    }

    if (list_functions) {
	if (list_functions == 1) {
	    list_0010(&context);
	} else {
	    if (list_functions == 2) {
		list_0220();
	    }
	}
    } else {
	if (context.argv ? !(argc - optind) : (argc - optind) % 3 != 1) {
	    fprintf(stderr, "%s: wrong number of arguments\nTry `%s --help' "
		    "for more information.\n", argv[0], argv[0]);

	    return 1;
	} else {
	    context.self = argv[0];

	    static_text = &context;

	    status = tempt_logic(&context, argc, argv);
	}
    }

    return status;
}
